let _ = Mltop.add_known_module "rocq-runtime.plugins.ltac"

# 13 "plugins/ltac/g_ltac.mlg"
 

open Util
open Pp
open Constrexpr
open Tacexpr
open Genarg
open Names
open Attributes

open Procq
open Procq.Prim
open Procq.Constr
open Pvernac.Vernac_
open Pltac

let fail_default_value = Locus.ArgArg 0

let arg_of_expr = function
    { CAst.v=(TacArg v) } -> v
  | e -> Tacexp (e:raw_tactic_expr)

let genarg_of_unit () = in_gen (rawwit Stdarg.wit_unit) ()
let genarg_of_int n = in_gen (rawwit Stdarg.wit_int) n
let genarg_of_ipattern pat = in_gen (rawwit Tacarg.wit_simple_intropattern) pat
let genarg_of_uconstr c = in_gen (rawwit Stdarg.wit_uconstr) c

let reference_to_id qid =
  if Libnames.qualid_is_ident qid then
    CAst.make ?loc:qid.CAst.loc @@ Libnames.qualid_basename qid
  else
    CErrors.user_err ?loc:qid.CAst.loc
      (str "This expression should be a simple identifier.")

let tactic_mode = Entry.make "tactic_command"

let tacdef_body = Entry.make "tacdef_body"

(* Registers [tactic_mode] as a parser for proof editing *)
let classic_proof_mode = Pvernac.register_proof_mode "Classic"
    (ProofMode {
        command_entry = tactic_mode;
        wit_tactic_expr = Tacarg.wit_ltac;
        tactic_expr_entry = Pltac.tactic;
      })

(* Tactics grammar rules *)

let hint = G_proofs.hint

let for_extraargs = ()

let goal_selector = G_vernac.goal_selector
let toplevel_selector = G_vernac.toplevel_selector
let subprf = G_vernac.subprf
let subprf_with_selector = G_vernac.subprf_with_selector


# 63 "plugins/ltac/g_ltac.ml"

let _ =
  let tactic_then_last = Procq.Entry.make "tactic_then_last"
  and for_each_goal = Procq.Entry.make "for_each_goal"
  and tactic_then_locality = Procq.Entry.make "tactic_then_locality"
  and failkw = Procq.Entry.make "failkw"
  and tactic_arg = Procq.Entry.make "tactic_arg"
  and fresh_id = Procq.Entry.make "fresh_id"
  and tactic_atom = Procq.Entry.make "tactic_atom"
  and match_key = Procq.Entry.make "match_key"
  and input_fun = Procq.Entry.make "input_fun"
  and let_clause = Procq.Entry.make "let_clause"
  and match_pattern = Procq.Entry.make "match_pattern"
  and match_hyp = Procq.Entry.make "match_hyp"
  and match_context_rule = Procq.Entry.make "match_context_rule"
  and match_context_list = Procq.Entry.make "match_context_list"
  and match_rule = Procq.Entry.make "match_rule"
  and match_list = Procq.Entry.make "match_list"
  and message_token = Procq.Entry.make "message_token"
  and ltac_def_kind = Procq.Entry.make "ltac_def_kind"
  in
  let () = assert (Procq.Entry.is_empty tactic_then_last) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:0")
  tactic_then_last
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 80 "plugins/ltac/g_ltac.mlg"
             [||] 
# 95 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.list0sep ((Procq.Symbol.opt (Procq.Symbol.nterm ltac_expr))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun lta _ loc -> 
# 79 "plugins/ltac/g_ltac.mlg"
          Array.map (function None -> CAst.make ~loc (TacId []) | Some t -> t) (Array.of_list lta) 
# 105 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty for_each_goal) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:1")
  for_each_goal
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 89 "plugins/ltac/g_ltac.mlg"
             ([CAst.make ~loc (TacId [])], None) 
# 117 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.nterm for_each_goal)))
                           (fun tg _ loc -> 
# 88 "plugins/ltac/g_ltac.mlg"
                                     let (first,last) = tg in (CAst.make ~loc (TacId []) :: first, last) 
# 127 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun ta loc -> 
# 87 "plugins/ltac/g_ltac.mlg"
                            ([ta], None) 
# 135 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                            ((Procq.Symbol.nterm tactic_then_last)))
                           (fun l _ loc -> 
# 86 "plugins/ltac/g_ltac.mlg"
                                        ([], Some (CAst.make ~loc (TacId []), l)) 
# 145 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ltac_expr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                            ((Procq.Symbol.nterm tactic_then_last)))
                           (fun l _ ta loc -> 
# 85 "plugins/ltac/g_ltac.mlg"
                                                        ([], Some (ta, l)) 
# 157 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ltac_expr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.nterm for_each_goal)))
                           (fun tg _ ta loc -> 
# 84 "plugins/ltac/g_ltac.mlg"
                                                     let (first,last) = tg in (ta::first, last) 
# 169 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tactic_then_locality) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:2")
  tactic_then_locality
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.opt (Procq.Symbol.token (Tok.PKEYWORD (">"))))))
                            (fun l _ loc -> 
# 94 "plugins/ltac/g_ltac.mlg"
                            if Option.is_empty l then true else false 
# 185 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ltac_expr) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:3")
  ltac_expr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(Some ("5"), Some (Gramlib.Gramext.RightA), []);
                          (Some ("4"), Some (Gramlib.Gramext.LeftA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm ltac_expr)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                              ((Procq.Symbol.nterm tactic_then_locality)))
                             ((Procq.Symbol.nterm for_each_goal)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ tg l _ ta0 loc -> 
# 101 "plugins/ltac/g_ltac.mlg"
                                                                                    
          let (first,tail) = tg in
          match l , tail with
          | false , Some (t,last) -> CAst.make ~loc (TacThen (ta0,
              CAst.make ~loc (TacExtendTac (Array.of_list first, t, last))))
          | true  , Some (t,last) -> CAst.make ~loc (TacThens3parts (ta0, Array.of_list first, t, last))
          | false , None -> CAst.make ~loc (TacThen (ta0, CAst.make ~loc (TacDispatch first)))
          | true  , None -> CAst.make ~loc (TacThens (ta0,first)) 
# 215 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ltac_expr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta1 _ ta0 loc -> 
# 100 "plugins/ltac/g_ltac.mlg"
                                                   CAst.make ~loc (TacThen (ta0,ta1)) 
# 227 "plugins/ltac/g_ltac.ml"
)]);
                          (Some ("3"), Some (Gramlib.Gramext.RightA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("only"))))))
                              ((Procq.Symbol.nterm goal_selector)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun ta _ sel _ loc -> 
# 122 "plugins/ltac/g_ltac.mlg"
                                                                    CAst.make ~loc (TacSelect (sel, ta)) 
# 243 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("abstract"))))))
                             (Procq.Symbol.next))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("using")))))
                           ((Procq.Symbol.nterm ident)))
                          (fun s _ tc _ loc -> 
# 121 "plugins/ltac/g_ltac.mlg"
          CAst.make ~loc (TacAbstract (tc,Some s)) 
# 258 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("abstract"))))))
                           (Procq.Symbol.next))
                          (fun tc _ loc -> 
# 119 "plugins/ltac/g_ltac.mlg"
                                         CAst.make ~loc (TacAbstract (tc,None)) 
# 269 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("exactly_once"))))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta _ loc -> 
# 117 "plugins/ltac/g_ltac.mlg"
                                                  CAst.make ~loc (TacExactlyOnce ta) 
# 280 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("once"))))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta _ loc -> 
# 116 "plugins/ltac/g_ltac.mlg"
                                          CAst.make ~loc (TacOnce  ta) 
# 291 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("progress"))))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta _ loc -> 
# 115 "plugins/ltac/g_ltac.mlg"
                                              CAst.make ~loc (TacProgress ta) 
# 302 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("repeat"))))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta _ loc -> 
# 114 "plugins/ltac/g_ltac.mlg"
                                            CAst.make ~loc (TacRepeat ta) 
# 313 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("time"))))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm string))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta s _ loc -> 
# 113 "plugins/ltac/g_ltac.mlg"
                                                          CAst.make ~loc (TacTime (s,ta)) 
# 326 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("timeout"))))))
                            ((Procq.Symbol.nterm nat_or_var)))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta n _ loc -> 
# 112 "plugins/ltac/g_ltac.mlg"
                                                             CAst.make ~loc (TacTimeout (n,ta)) 
# 339 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("do"))))))
                            ((Procq.Symbol.nterm nat_or_var)))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta n _ loc -> 
# 111 "plugins/ltac/g_ltac.mlg"
                                                        CAst.make ~loc (TacDo (n,ta)) 
# 352 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("try"))))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta _ loc -> 
# 110 "plugins/ltac/g_ltac.mlg"
                                         CAst.make ~loc (TacTry ta) 
# 363 "plugins/ltac/g_ltac.ml"
)]);
                          (Some ("2"), Some (Gramlib.Gramext.RightA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ltac_expr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("||")))))
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun ta1 _ ta0 loc -> 
# 129 "plugins/ltac/g_ltac.mlg"
                                                    CAst.make ~loc (TacOrelse (ta0,ta1)) 
# 376 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("tryif"))))))
                               ((Procq.Symbol.nterm ltac_expr)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("then")))))
                             ((Procq.Symbol.nterm ltac_expr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("else")))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun tae _ tat _ ta _ loc -> 
# 128 "plugins/ltac/g_ltac.mlg"
                                            CAst.make ~loc (TacIfThenCatch (ta,tat,tae)) 
# 395 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ltac_expr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                           ((Procq.Symbol.nterm ltac_expr)))
                          (fun ta1 _ ta0 loc -> 
# 125 "plugins/ltac/g_ltac.mlg"
                                                   CAst.make ~loc (TacOr (ta0,ta1)) 
# 407 "plugins/ltac/g_ltac.ml"
)]);
                          (Some ("1"), Some (Gramlib.Gramext.RightA),
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm reference)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm tactic_arg))))
                           (fun la r loc -> 
# 153 "plugins/ltac/g_ltac.mlg"
          CAst.make ~loc @@ TacArg (TacCall (CAst.make ~loc (r,la))) 
# 418 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm tactic_value)))
                          (fun a loc -> 
# 151 "plugins/ltac/g_ltac.mlg"
                              CAst.make ~loc (TacArg a) 
# 426 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm simple_tactic)))
                          (fun st loc -> 
# 150 "plugins/ltac/g_ltac.mlg"
                                st 
# 434 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm failkw)))
                            ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                   (fun
                                                                   loc -> 
                                                                   
# 148 "plugins/ltac/g_ltac.mlg"
                                                       fail_default_value 
# 447 "plugins/ltac/g_ltac.ml"
);
                                                 Procq.Rules.make (Procq.Rule.next_norec
                                                                   (Procq.Rule.stop)
                                                                   ((Procq.Symbol.nterm nat_or_var)))
                                                                  (fun n
                                                                  loc -> 
                                                                  
# 148 "plugins/ltac/g_ltac.mlg"
                                            n 
# 457 "plugins/ltac/g_ltac.ml"
)])))
                           ((Procq.Symbol.list0 (Procq.Symbol.nterm message_token))))
                          (fun l n g loc -> 
# 149 "plugins/ltac/g_ltac.mlg"
                                       CAst.make ~loc (TacFail (g,n,l)) 
# 463 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("idtac"))))))
                           ((Procq.Symbol.list0 (Procq.Symbol.nterm message_token))))
                          (fun l _ loc -> 
# 147 "plugins/ltac/g_ltac.mlg"
                                                    CAst.make ~loc (TacId l) 
# 474 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("solve"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                            ((Procq.Symbol.list0sep ((Procq.Symbol.nterm ltac_expr)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                          (fun _ l _ _ loc -> 
# 146 "plugins/ltac/g_ltac.mlg"
            CAst.make ~loc (TacSolve l) 
# 489 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("first"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                            ((Procq.Symbol.list0sep ((Procq.Symbol.nterm ltac_expr)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                          (fun _ l _ _ loc -> 
# 144 "plugins/ltac/g_ltac.mlg"
            CAst.make ~loc (TacFirst l) 
# 504 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm match_key)))
                              ((Procq.Symbol.nterm ltac_expr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.nterm match_list)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("end")))))
                          (fun _ mrl _ c b loc -> 
# 142 "plugins/ltac/g_ltac.mlg"
            CAst.make ~loc (TacMatch (b,c,mrl)) 
# 520 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm match_key)))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("reverse"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("goal"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.nterm match_context_list)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("end")))))
                          (fun _ mrl _ _ _ b loc -> 
# 140 "plugins/ltac/g_ltac.mlg"
            CAst.make ~loc (TacMatchGoal (b,true,mrl)) 
# 540 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm match_key)))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("goal"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.nterm match_context_list)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("end")))))
                          (fun _ mrl _ _ b loc -> 
# 137 "plugins/ltac/g_ltac.mlg"
            CAst.make ~loc (TacMatchGoal (b,false,mrl)) 
# 557 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                              ((Procq.Symbol.rules [Procq.Rules.make 
                                                   (Procq.Rule.stop) (fun
                                                   loc -> 
# 133 "plugins/ltac/g_ltac.mlg"
                                                       false 
# 571 "plugins/ltac/g_ltac.ml"
);
                                                   Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                    ("rec"))))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 133 "plugins/ltac/g_ltac.mlg"
                                         true 
# 583 "plugins/ltac/g_ltac.ml"
)])))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm let_clause)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                           ((Procq.Symbol.nterml ltac_expr ("5"))))
                          (fun body _ llc isrec _ loc -> 
# 135 "plugins/ltac/g_ltac.mlg"
                                          CAst.make ~loc (TacLetIn (isrec,llc,body)) 
# 591 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("fun")))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm input_fun)))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                           ((Procq.Symbol.nterml ltac_expr ("5"))))
                          (fun body _ it _ loc -> 
# 132 "plugins/ltac/g_ltac.mlg"
            CAst.make ~loc (TacFun (it,body)) 
# 605 "plugins/ltac/g_ltac.ml"
)]);
                          (Some ("0"), None,
                          [Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm tactic_atom)))
                           (fun a loc -> 
# 162 "plugins/ltac/g_ltac.mlg"
                             CAst.make ~loc (TacArg a) 
# 614 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (">")))))
                            ((Procq.Symbol.nterm for_each_goal)))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                          (fun _ tg _ _ loc -> 
# 156 "plugins/ltac/g_ltac.mlg"
                                              
          let (tf,tail) = tg in
          begin match tail with
          | Some (t,tl) -> CAst.make ~loc (TacExtendTac (Array.of_list tf,t,tl))
          | None -> CAst.make ~loc (TacDispatch tf)
          end 
# 633 "plugins/ltac/g_ltac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                            ((Procq.Symbol.nterm ltac_expr)))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ a _ loc -> 
# 155 "plugins/ltac/g_ltac.mlg"
                                     a 
# 645 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty failkw) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:4")
  failkw
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("gfail"))))))
                            (fun _ loc -> 
# 165 "plugins/ltac/g_ltac.mlg"
                                                        TacGlobal 
# 660 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("fail"))))))
                           (fun _ loc -> 
# 165 "plugins/ltac/g_ltac.mlg"
                        TacLocal 
# 669 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tactic_arg) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:5")
  tactic_arg
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("()")))))
                            (fun _ loc -> 
# 172 "plugins/ltac/g_ltac.mlg"
                  TacGeneric (None, genarg_of_unit ()) 
# 683 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm Constr.constr)))
                           (fun c loc -> 
# 170 "plugins/ltac/g_ltac.mlg"
                               (match c with { CAst.v = CRef (r,None) } -> Reference r | c -> ConstrMayEval (ConstrTerm c)) 
# 691 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm tactic_value)))
                           (fun a loc -> 
# 169 "plugins/ltac/g_ltac.mlg"
                              a 
# 699 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tactic_value) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:6")
  tactic_value
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("numgoals"))))))
                            (fun _ loc -> 
# 179 "plugins/ltac/g_ltac.mlg"
                              TacNumgoals 
# 714 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("type_term"))))))
                            ((Procq.Symbol.nterm uconstr)))
                           (fun c _ loc -> 
# 178 "plugins/ltac/g_ltac.mlg"
                                          TacPretype c 
# 725 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("fresh"))))))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm fresh_id))))
                           (fun l _ loc -> 
# 177 "plugins/ltac/g_ltac.mlg"
                                               TacFreshId l 
# 736 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm constr_eval)))
                           (fun c loc -> 
# 176 "plugins/ltac/g_ltac.mlg"
                             ConstrMayEval c 
# 744 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fresh_id) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:7")
  fresh_id
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm qualid)))
                            (fun qid loc -> 
# 186 "plugins/ltac/g_ltac.mlg"
                            Locus.ArgVar (CAst.make ~loc @@ Libnames.qualid_basename qid) 
# 758 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PSTRING (None)))))
                           (fun s loc -> 
# 185 "plugins/ltac/g_ltac.mlg"
                        Locus.ArgArg s (*| id = ident -> Locus.ArgVar (!@loc,id)*) 
# 766 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constr_eval) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:8")
  constr_eval
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("type"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("of"))))))
                             ((Procq.Symbol.nterm Constr.constr)))
                            (fun c _ _ loc -> 
# 194 "plugins/ltac/g_ltac.mlg"
            ConstrTypeOf c 
# 786 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("context"))))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm Constr.lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ c _ id _ loc -> 
# 192 "plugins/ltac/g_ltac.mlg"
            ConstrContext (id,c) 
# 803 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("eval"))))))
                              ((Procq.Symbol.nterm red_expr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterm Constr.constr)))
                           (fun c _ rtc _ loc -> 
# 190 "plugins/ltac/g_ltac.mlg"
            ConstrEval (rtc,c) 
# 818 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tactic_atom) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:9")
  tactic_atom
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("()")))))
                            (fun _ loc -> 
# 199 "plugins/ltac/g_ltac.mlg"
                  TacGeneric (None, genarg_of_unit ()) 
# 832 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm reference)))
                           (fun r loc -> 
# 198 "plugins/ltac/g_ltac.mlg"
                           TacCall (CAst.make ~loc (r,[])) 
# 840 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm integer)))
                           (fun n loc -> 
# 197 "plugins/ltac/g_ltac.mlg"
                         TacGeneric (None, genarg_of_int n) 
# 848 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_key) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:10")
  match_key
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("multimatch"))))))
                            (fun _ loc -> 
# 204 "plugins/ltac/g_ltac.mlg"
                                General 
# 863 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("lazymatch"))))))
                           (fun _ loc -> 
# 203 "plugins/ltac/g_ltac.mlg"
                               Select 
# 872 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("match")))))
                           (fun _ loc -> 
# 202 "plugins/ltac/g_ltac.mlg"
                     Once 
# 880 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty input_fun) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:11")
  input_fun
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            (fun l loc -> 
# 208 "plugins/ltac/g_ltac.mlg"
                       Name.Name l 
# 894 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                           (fun _ loc -> 
# 207 "plugins/ltac/g_ltac.mlg"
                 Name.Anonymous 
# 902 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty let_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:12")
  let_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm identref)))
                               ((Procq.Symbol.list1 ((Procq.Symbol.nterm input_fun)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm ltac_expr)))
                            (fun te _ args idr loc -> 
# 216 "plugins/ltac/g_ltac.mlg"
           (CAst.map (fun id -> Name id) idr, arg_of_expr (CAst.make ~loc (TacFun (args,te)))) 
# 922 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.rules [Procq.Rules.make 
                                                   (Procq.Rule.next_norec
                                                    (Procq.Rule.stop)
                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                                                   (fun _ loc -> 
# 213 "plugins/ltac/g_ltac.mlg"
                       CAst.make ~loc Anonymous 
# 935 "plugins/ltac/g_ltac.ml"
)])))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun te _ na loc -> 
# 214 "plugins/ltac/g_ltac.mlg"
           (na, arg_of_expr te) 
# 942 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm identref)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun te _ idr loc -> 
# 212 "plugins/ltac/g_ltac.mlg"
           (CAst.map (fun id -> Name id) idr, arg_of_expr te) 
# 954 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_pattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:13")
  match_pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm Constr.cpattern)))
                            (fun pc loc -> 
# 222 "plugins/ltac/g_ltac.mlg"
                                  Term pc 
# 968 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("context"))))))
                               ((Procq.Symbol.opt (Procq.Symbol.nterm Constr.ident))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.nterm Constr.cpattern)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ pc _ oid _ loc -> 
# 221 "plugins/ltac/g_ltac.mlg"
          Subterm (oid, pc) 
# 985 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_hyp) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:14")
  match_hyp
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm name)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm match_pattern)))
                            (fun mpv _ na loc -> 
# 228 "plugins/ltac/g_ltac.mlg"
          let t, ty =
            match mpv with
            | Term t -> (match t with
              | { CAst.v = CCast (t, Some DEFAULTcast, ty) } -> Term t, Some (Term ty)
              | _ -> mpv, None)
            | _ -> mpv, None
          in Def (na, t, Option.default (Term (CAst.make @@ CHole (None))) ty) 
# 1009 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.nterm name)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                               ((Procq.Symbol.nterm match_pattern)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm match_pattern)))
                           (fun mpt _ _ mpv _ _ na loc -> 
# 226 "plugins/ltac/g_ltac.mlg"
                                                                                      Def (na, mpv, mpt) 
# 1029 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm name)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm match_pattern)))
                           (fun mp _ na loc -> 
# 225 "plugins/ltac/g_ltac.mlg"
                                                 Hyp (na, mp) 
# 1041 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_context_rule) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:15")
  match_context_rule
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                             ((Procq.Symbol.nterm ltac_expr)))
                            (fun te _ _ loc -> 
# 242 "plugins/ltac/g_ltac.mlg"
                                       All te 
# 1059 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                                 ((Procq.Symbol.list0sep ((Procq.Symbol.nterm match_hyp)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                               ((Procq.Symbol.nterm match_pattern)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun te _ _ mp _ largs _ loc -> 
# 241 "plugins/ltac/g_ltac.mlg"
                                       Pat (largs, mp, te) 
# 1079 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.list0sep ((Procq.Symbol.nterm match_hyp)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                              ((Procq.Symbol.nterm match_pattern)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun te _ mp _ largs loc -> 
# 239 "plugins/ltac/g_ltac.mlg"
                                  Pat (largs, mp, te) 
# 1095 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_context_list) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:16")
  match_context_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm match_context_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            (fun mrl _ loc -> 
# 246 "plugins/ltac/g_ltac.mlg"
                                                         mrl 
# 1111 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm match_context_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun mrl loc -> 
# 245 "plugins/ltac/g_ltac.mlg"
                                                    mrl 
# 1119 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_rule) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:17")
  match_rule
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                             ((Procq.Symbol.nterm ltac_expr)))
                            (fun te _ _ loc -> 
# 250 "plugins/ltac/g_ltac.mlg"
                                       All te 
# 1137 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm match_pattern)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun te _ mp loc -> 
# 249 "plugins/ltac/g_ltac.mlg"
                                                      Pat ([],mp,te) 
# 1149 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty match_list) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:18")
  match_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm match_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            (fun mrl _ loc -> 
# 254 "plugins/ltac/g_ltac.mlg"
                                                 mrl 
# 1165 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm match_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun mrl loc -> 
# 253 "plugins/ltac/g_ltac.mlg"
                                            mrl 
# 1173 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty message_token) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:19")
  message_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm natural)))
                            (fun n loc -> 
# 259 "plugins/ltac/g_ltac.mlg"
                         MsgInt n 
# 1187 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PSTRING (None)))))
                           (fun s loc -> 
# 258 "plugins/ltac/g_ltac.mlg"
                        MsgString s 
# 1195 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm identref)))
                           (fun id loc -> 
# 257 "plugins/ltac/g_ltac.mlg"
                           MsgIdent id 
# 1203 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ltac_def_kind) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:20")
  ltac_def_kind
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("::=")))))
                            (fun _ loc -> 
# 264 "plugins/ltac/g_ltac.mlg"
                   true 
# 1217 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                           (fun _ loc -> 
# 263 "plugins/ltac/g_ltac.mlg"
                  false 
# 1225 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tacdef_body) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:21")
  tacdef_body
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm Constr.global)))
                              ((Procq.Symbol.nterm ltac_def_kind)))
                             ((Procq.Symbol.nterm ltac_expr)))
                            (fun body redef name loc -> 
# 277 "plugins/ltac/g_ltac.mlg"
          if redef then Tacexpr.TacticRedefinition (name, body)
          else
            let id = reference_to_id name in
            Tacexpr.TacticDefinition (id, body) 
# 1246 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm Constr.global)))
                              ((Procq.Symbol.list1 ((Procq.Symbol.nterm input_fun)))))
                             ((Procq.Symbol.nterm ltac_def_kind)))
                            ((Procq.Symbol.nterm ltac_expr)))
                           (fun body redef it name loc -> 
# 271 "plugins/ltac/g_ltac.mlg"
          if redef then Tacexpr.TacticRedefinition (name, CAst.make ~loc (TacFun (it, body)))
          else
            let id = reference_to_id name in
            Tacexpr.TacticDefinition (id, CAst.make ~loc (TacFun (it, body))) 
# 1263 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tactic) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:22")
  tactic
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ltac_expr)))
                            (fun tac loc -> 
# 284 "plugins/ltac/g_ltac.mlg"
                             tac 
# 1277 "plugins/ltac/g_ltac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty tactic_mode) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:23")
  tactic_mode
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.opt (Procq.Symbol.nterm toplevel_selector))))
                             ((Procq.Symbol.nterm subprf_with_selector)))
                            (fun p g loc -> 
# 288 "plugins/ltac/g_ltac.mlg"
                                                                 Vernacexpr.VernacSynPure (p g) 
# 1293 "plugins/ltac/g_ltac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm subprf)))
                           (fun p loc -> 
# 287 "plugins/ltac/g_ltac.mlg"
                        Vernacexpr.VernacSynPure p 
# 1301 "plugins/ltac/g_ltac.ml"
)])]))
  in let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_ltac.mlg:24")
  term
  (Procq.Reuse (Some
  ("0"), [Procq.Production.make
          (Procq.Rule.next
           (Procq.Rule.next
            (Procq.Rule.next
             (Procq.Rule.next
              (Procq.Rule.next (Procq.Rule.stop)
               ((Procq.Symbol.token (Tok.PIDENT (Some ("ltac"))))))
              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
             ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
            ((Procq.Symbol.nterm Pltac.ltac_expr)))
           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
          (fun _ tac _ _ _ loc -> 
# 293 "plugins/ltac/g_ltac.mlg"
          let arg = Genarg.in_gen (Genarg.rawwit Tacarg.wit_ltac_in_term) tac in
          CAst.make ~loc @@ CGenarg arg 
# 1322 "plugins/ltac/g_ltac.ml"
)]))
  in ()


# 298 "plugins/ltac/g_ltac.mlg"
 

open Stdarg
open Tacarg
open Vernacextend
open Libnames

let pr_ltac_selector s = Pp.(Goal_select.pr_goal_selector s ++ str ":")


# 1338 "plugins/ltac/g_ltac.ml"

let (wit_ltac_selector, ltac_selector) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~name:"ltac_selector" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_alias (toplevel_selector);
    Vernacextend.arg_printer = fun env sigma -> 
# 309 "plugins/ltac/g_ltac.mlg"
                                                  pr_ltac_selector 
# 1348 "plugins/ltac/g_ltac.ml"
;
    }
let _ = (wit_ltac_selector, ltac_selector)


# 313 "plugins/ltac/g_ltac.mlg"
 

let pr_ltac_info n = str "Info" ++ spc () ++ int n


# 1360 "plugins/ltac/g_ltac.ml"

let (wit_ltac_info, ltac_info) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~name:"ltac_info" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop)
         ((Procq.Symbol.token (Procq.terminal "Info"))))
        ((Procq.Symbol.nterm natural)))
       (fun n _ loc -> 
# 320 "plugins/ltac/g_ltac.mlg"
                             n 
# 1375 "plugins/ltac/g_ltac.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 319 "plugins/ltac/g_ltac.mlg"
                                              pr_ltac_info 
# 1380 "plugins/ltac/g_ltac.ml"
;
    }
let _ = (wit_ltac_info, ltac_info)


# 323 "plugins/ltac/g_ltac.mlg"
 

let pr_ltac_use_default b =
  if b then (* Bug: a space is inserted before "..." *) str ".." else mt ()


# 1393 "plugins/ltac/g_ltac.ml"

let (wit_ltac_use_default, ltac_use_default) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~name:"ltac_use_default" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop)
        ((Procq.Symbol.token (Procq.terminal "..."))))
       (fun _ loc -> 
# 332 "plugins/ltac/g_ltac.mlg"
                 true 
# 1406 "plugins/ltac/g_ltac.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "."))))
      (fun _ loc -> 
# 331 "plugins/ltac/g_ltac.mlg"
               false 
# 1414 "plugins/ltac/g_ltac.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 330 "plugins/ltac/g_ltac.mlg"
                                                     pr_ltac_use_default 
# 1419 "plugins/ltac/g_ltac.ml"
;
    }
let _ = (wit_ltac_use_default, ltac_use_default)


# 335 "plugins/ltac/g_ltac.mlg"
 

let rm_abstract tac =
  let (loc, tac2) = CAst.(tac.loc, tac.v) in
  match tac2 with
  | TacAbstract (t,_) -> t, true
  | TacSolve [ {CAst.loc; v=TacAbstract(t,_)} ] -> CAst.make ?loc (TacSolve [t]), true
  | _ -> tac, false

let is_explicit_terminator = function
  | {CAst.v=(TacSolve _)} -> true
  | _ -> false


# 1440 "plugins/ltac/g_ltac.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"VernacSolve"  ?entry:(Some ( tactic_mode )) 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_ltac_selector)),
          Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_ltac_info)),
          Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_tactic),
          Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac_use_default),
          Vernacextend.TyNil)))),
          (let coqpp_body g info t with_end_tac () =
            Vernactypes.vtmodifyproof (fun ~pstate -> (
# 352 "plugins/ltac/g_ltac.mlg"
                                  
    let g = Option.default (Goal_select.get_default_goal_selector ()) g in
    let global =
      let open Goal_select in
      match g with
      | SelectAll -> true
      | SelectList [NthSelector _] -> false
      | SelectList _ -> true
      | _ -> false in
    let t = Tacinterp.hide_interp { Tacinterp.global; ast = t; } in
    ComTactic.solve g ~info t ~with_end_tac
  
# 1465 "plugins/ltac/g_ltac.ml"
) ~pstate) in
            fun g info t with_end_tac ?loc ~atts () ->
            coqpp_body g info t with_end_tac
              (Attributes.unsupported_attributes atts)),
          Some (fun g info t with_end_tac  ~atts -> 
# 352 "plugins/ltac/g_ltac.mlg"
      classify_as_proofstep 
# 1473 "plugins/ltac/g_ltac.ml"
)))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"VernacSolveParallel"  ?entry:(Some ( tactic_mode )) 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("par",
           Vernacextend.TyTerminal
           (":",
            Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_ltac_info)),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_tactic),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac_use_default),
            Vernacextend.TyNil))))),
          (let coqpp_body info t with_end_tac () =
            Vernactypes.vtmodifyproof (fun ~pstate -> (
# 372 "plugins/ltac/g_ltac.mlg"
          
      let t, abstract = rm_abstract t in
      let t = Tacinterp.hide_interp { Tacinterp.global = true; ast = t; } in
      ComTactic.solve_parallel ~info t ~abstract ~with_end_tac
    
# 1495 "plugins/ltac/g_ltac.ml"
) ~pstate) in
            fun info t with_end_tac ?loc ~atts () ->
            coqpp_body info t with_end_tac
              (Attributes.unsupported_attributes atts)),
          Some (fun info t with_end_tac  ~atts -> 
# 368 "plugins/ltac/g_ltac.mlg"
     
      let solving_tac = is_explicit_terminator t in
      let pbr = if solving_tac then Some "par" else None in
      VtProofStep{ proof_block_detection = pbr }
    
# 1507 "plugins/ltac/g_ltac.ml"
)))]


# 379 "plugins/ltac/g_ltac.mlg"
 

let pr_ltac_tactic_level n = str "(at level " ++ int n ++ str ")"


# 1517 "plugins/ltac/g_ltac.ml"

let (wit_ltac_tactic_level, ltac_tactic_level) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~name:"ltac_tactic_level" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next
          (Procq.Rule.next
           (Procq.Rule.next (Procq.Rule.stop)
            ((Procq.Symbol.token (Procq.terminal "("))))
           ((Procq.Symbol.token (Procq.terminal "at"))))
          ((Procq.Symbol.token (Procq.terminal "level"))))
         ((Procq.Symbol.nterm natural)))
        ((Procq.Symbol.token (Procq.terminal ")"))))
       (fun _ n _ _ _ loc -> 
# 386 "plugins/ltac/g_ltac.mlg"
                                           n 
# 1538 "plugins/ltac/g_ltac.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 385 "plugins/ltac/g_ltac.mlg"
                                                      pr_ltac_tactic_level 
# 1543 "plugins/ltac/g_ltac.ml"
;
    }
let _ = (wit_ltac_tactic_level, ltac_tactic_level)

let (wit_ltac_production_sep, ltac_production_sep) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~name:"ltac_production_sep" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop)
         ((Procq.Symbol.token (Procq.terminal ","))))
        ((Procq.Symbol.nterm string)))
       (fun sep _ loc -> 
# 390 "plugins/ltac/g_ltac.mlg"
                           sep 
# 1561 "plugins/ltac/g_ltac.ml"
))]);
    Vernacextend.arg_printer = fun env sigma ->
    fun _ -> Pp.str "missing printer";
    }
let _ = (wit_ltac_production_sep, ltac_production_sep)


# 393 "plugins/ltac/g_ltac.mlg"
 

let pr_ltac_production_item = function
| Tacentries.TacTerm s -> quote (str s)
| Tacentries.TacNonTerm (_, ((arg, None), None)) -> str arg
| Tacentries.TacNonTerm (_, ((arg, Some _), None)) -> assert false
| Tacentries.TacNonTerm (_, ((arg, sep), Some id)) ->
  let sep = match sep with
  | None -> mt ()
  | Some sep -> str "," ++ spc () ++ quote (str sep)
  in
  str arg ++ str "(" ++ Id.print id ++ sep ++ str ")"

let check_non_empty_string ?loc s =
  if String.is_empty s then CErrors.user_err ?loc (str "Invalid empty string.")


# 1587 "plugins/ltac/g_ltac.ml"

let (wit_ltac_production_item, ltac_production_item) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~name:"ltac_production_item" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm ident)))
       (fun nt loc -> 
# 416 "plugins/ltac/g_ltac.mlg"
    Tacentries.TacNonTerm (Loc.tag ~loc ((Id.to_string nt, None), None)) 
# 1599 "plugins/ltac/g_ltac.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next
          (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm ident)))
          ((Procq.Symbol.token (Procq.terminal "("))))
         ((Procq.Symbol.nterm ident)))
        ((Procq.Symbol.opt (Procq.Symbol.nterm ltac_production_sep))))
       ((Procq.Symbol.token (Procq.terminal ")"))))
      (fun _ sep p _ nt loc -> 
# 414 "plugins/ltac/g_ltac.mlg"
    Tacentries.TacNonTerm (Loc.tag ~loc ((Id.to_string nt, sep), Some p)) 
# 1614 "plugins/ltac/g_ltac.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm string)))
      (fun s loc -> 
# 412 "plugins/ltac/g_ltac.mlg"
                     check_non_empty_string ~loc s; Tacentries.TacTerm s 
# 1621 "plugins/ltac/g_ltac.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 411 "plugins/ltac/g_ltac.mlg"
                                                         pr_ltac_production_item 
# 1626 "plugins/ltac/g_ltac.ml"
;
    }
let _ = (wit_ltac_production_item, ltac_production_item)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"VernacTacticNotation"  ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Tactic",
           Vernacextend.TyTerminal
           ("Notation",
            Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_ltac_tactic_level)),
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_ltac_production_item)),
            Vernacextend.TyTerminal
            (":=",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_tactic),
             Vernacextend.TyNil)))))),
          (let coqpp_body n r e (deprecation, locality) =
            (let tacobj = 
# 422 "plugins/ltac/g_ltac.mlg"
                                              
    let n = Option.default 0 n in
    let local = Locality.make_module_locality locality in
    Tacentries.add_tactic_notation_syntax local n ?deprecation r
  
# 1652 "plugins/ltac/g_ltac.ml"
 in Vernactypes.vtdefault (fun () -> 
# 427 "plugins/ltac/g_ltac.mlg"
   
    Tacentries.add_tactic_notation ?deprecation tacobj e
  
# 1658 "plugins/ltac/g_ltac.ml"
)) in
            fun n r e ?loc ~atts () ->
            coqpp_body n r e
              (Attributes.parse Attributes.Notations.(
# 420 "plugins/ltac/g_ltac.mlg"
      deprecation
# 1665 "plugins/ltac/g_ltac.ml"
 ++ 
# 420 "plugins/ltac/g_ltac.mlg"
                   locality
# 1669 "plugins/ltac/g_ltac.ml"
) atts)),
          Some (fun n r e  ~atts -> 
# 422 "plugins/ltac/g_ltac.mlg"
    VtSideff ([], VtNow) 
# 1674 "plugins/ltac/g_ltac.ml"
)))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"VernacPrintLtac" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Ltac",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNil))),
          (let coqpp_body r () = Vernactypes.vtdefault (fun () -> 
# 434 "plugins/ltac/g_ltac.mlg"
    Feedback.msg_notice (Tacentries.print_ltac r) 
# 1689 "plugins/ltac/g_ltac.ml"
) in
            fun r ?loc ~atts () ->
            coqpp_body r (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"VernacLocateLtac" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Locate",
           Vernacextend.TyTerminal
           ("Ltac",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNil))),
          (let coqpp_body r () = Vernactypes.vtdefault (fun () -> 
# 439 "plugins/ltac/g_ltac.mlg"
    Tacentries.print_located_tactic r 
# 1707 "plugins/ltac/g_ltac.ml"
) in
            fun r ?loc ~atts () ->
            coqpp_body r (Attributes.unsupported_attributes atts)),
          None))]


# 442 "plugins/ltac/g_ltac.mlg"
 

let pr_ltac_ref = Libnames.pr_qualid

let pr_tacdef_body env sigma tacdef_body =
  let id, redef, body =
    match tacdef_body with
    | TacticDefinition ({CAst.v=id}, body) -> Id.print id, false, body
    | TacticRedefinition (id, body) -> pr_ltac_ref id, true, body
  in
  let idl, body =
    match body with
      | {CAst.v=(Tacexpr.TacFun (idl,b))} -> idl,b
      | _ -> [], body in
  id ++
    prlist (function Name.Anonymous -> str " _"
      | Name.Name id -> spc () ++ Id.print id) idl
  ++ (if redef then str" ::=" else str" :=") ++ brk(1,1)
  ++ Pptactic.pr_raw_tactic env sigma body


# 1736 "plugins/ltac/g_ltac.ml"

let (wit_ltac_tacdef_body, ltac_tacdef_body) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~name:"ltac_tacdef_body" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_alias (tacdef_body);
    Vernacextend.arg_printer = fun env sigma -> 
# 465 "plugins/ltac/g_ltac.mlg"
             pr_tacdef_body env sigma 
# 1746 "plugins/ltac/g_ltac.ml"
;
    }
let _ = (wit_ltac_tacdef_body, ltac_tacdef_body)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"VernacDeclareTacticDefinition"  ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Ltac",
           Vernacextend.TyNonTerminal (Extend.TUlist1sep (Extend.TUentry (Genarg.get_arg_tag wit_ltac_tacdef_body), "with"),
           Vernacextend.TyNil)),
          (let coqpp_body l raw_attributes =
            Vernactypes.vtdefault (fun () -> 
# 474 "plugins/ltac/g_ltac.mlg"
        
         Tacentries.register_ltac raw_attributes l;
  
# 1764 "plugins/ltac/g_ltac.ml"
) in fun l ?loc ~atts () ->
            coqpp_body l (Attributes.parse 
# 470 "plugins/ltac/g_ltac.mlg"
      raw_attributes
# 1769 "plugins/ltac/g_ltac.ml"
 atts)),
          Some (fun l  ~atts -> 
# 470 "plugins/ltac/g_ltac.mlg"
                                                                              
    VtSideff (List.map (function
      | TacticDefinition ({CAst.v=r},_) -> r
      | TacticRedefinition (qid,_) -> qualid_basename qid) l, VtLater)
  
# 1778 "plugins/ltac/g_ltac.ml"
)))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"VernacPrintLtacs" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Ltac",
            Vernacextend.TyTerminal ("Signatures", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 480 "plugins/ltac/g_ltac.mlg"
                                       Tacentries.print_ltacs () 
# 1792 "plugins/ltac/g_ltac.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

