/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.Operator;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.And;
import org.mvel2.ast.BinaryOperation;
import org.mvel2.ast.BooleanNode;
import org.mvel2.ast.Contains;
import org.mvel2.ast.Convertable;
import org.mvel2.ast.DeclTypedVarNode;
import org.mvel2.ast.Function;
import org.mvel2.ast.Instance;
import org.mvel2.ast.IntAdd;
import org.mvel2.ast.IntDiv;
import org.mvel2.ast.IntMult;
import org.mvel2.ast.IntOptimized;
import org.mvel2.ast.IntSub;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.Or;
import org.mvel2.ast.RegExMatchNode;
import org.mvel2.ast.Soundslike;
import org.mvel2.ast.Strsim;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.BlankLiteral;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ClassImportResolverFactory;
import org.mvel2.util.ASTBinaryTree;
import org.mvel2.util.ASTIterator;
import org.mvel2.util.ASTLinkedList;
import org.mvel2.util.ParseTools;

public class CompilerTools {
    public static ASTLinkedList finalizePayload(ASTLinkedList astLinkedList, boolean secondPassOptimization, ParserContext pCtx) {
        ASTNode tkOp2;
        ASTNode tkOp;
        ASTNode tk;
        ASTLinkedList optimizedAst = new ASTLinkedList();
        while (astLinkedList.hasMoreNodes()) {
            tk = astLinkedList.nextNode();
            if (tk.getFields() == -1) {
                optimizedAst.addTokenNode(tk);
                continue;
            }
            if (astLinkedList.hasMoreNodes()) {
                tkOp = astLinkedList.nextNode();
                if (tkOp.getFields() == -1) {
                    optimizedAst.addTokenNode(tk, tkOp);
                    continue;
                }
                if (tkOp.isOperator() && tkOp.getOperator() < 21) {
                    int op2;
                    BinaryOperation bo;
                    int op = tkOp.getOperator();
                    if (op == -1) {
                        throw new CompileException("illegal use of operator: " + tkOp.getName(), tkOp.getExpr(), tk.getStart());
                    }
                    ASTNode tk2 = astLinkedList.nextNode();
                    if (tk.getEgressType() == Integer.class && tk2.getEgressType() == Integer.class) {
                        bo = CompilerTools.boOptimize(op, tk, tk2, pCtx);
                    } else {
                        bo = null;
                        boolean inv = tkOp.isOperator(1);
                        boolean reduc = tk.isLiteral() && CompilerTools.isReductionOpportunity(tkOp, tk2);
                        boolean p_inv = false;
                        while (reduc) {
                            ASTNode oper = astLinkedList.nextNode();
                            ASTNode rightNode = astLinkedList.nextNode();
                            if (rightNode == null) break;
                            Object val = new BinaryOperation(oper.getOperator(), inv ? new LiteralNode(CompilerTools.signNumber(tk2.getLiteralValue()), pCtx) : tk2, rightNode, pCtx).getReducedValueAccelerated(null, null, null);
                            if (!astLinkedList.hasMoreNodes() && BlankLiteral.INSTANCE.equals(val)) {
                                optimizedAst.addTokenNode(tk);
                                continue;
                            }
                            boolean bl = reduc = astLinkedList.hasMoreNodes() && CompilerTools.reducacbleOperator(astLinkedList.peekNode().getOperator()) && astLinkedList.peekNext().isLiteral();
                            if (inv) {
                                p_inv = true;
                            }
                            inv = false;
                            if (!reduc) {
                                bo = new BinaryOperation(tkOp.getOperator(), tk, new LiteralNode(p_inv ? CompilerTools.signNumber(val) : val, pCtx), pCtx);
                                continue;
                            }
                            tk2 = new LiteralNode(val, pCtx);
                        }
                        if (bo == null) {
                            bo = new BinaryOperation(op, tk, tk2, pCtx);
                        }
                    }
                    tkOp2 = null;
                    while (astLinkedList.hasMoreNodes() && (tkOp2 = astLinkedList.nextNode()).isOperator() && tkOp2.getFields() != -1 && (op2 = tkOp2.getOperator().intValue()) != -1 && op2 < 21) {
                        if (Operator.PTABLE[op2] > Operator.PTABLE[op]) {
                            BinaryOperation newRightBo = CompilerTools.boOptimize(op2, bo.getRightMost(), astLinkedList.nextNode(), pCtx);
                            if (CompilerTools.isIntOptimizationviolation(bo, newRightBo)) {
                                bo = new BinaryOperation(bo.getOperation(), bo.getLeft(), newRightBo, pCtx);
                            } else {
                                bo.setRightMost(newRightBo);
                            }
                        } else if (bo.getOperation() != op2 && Operator.PTABLE[op] == Operator.PTABLE[op2]) {
                            if (Operator.PTABLE[bo.getOperation()] == Operator.PTABLE[op2]) {
                                bo = CompilerTools.boOptimize(op2, bo, astLinkedList.nextNode(), pCtx);
                            } else {
                                tk2 = astLinkedList.nextNode();
                                if (CompilerTools.isIntOptimizationviolation(bo, tk2)) {
                                    bo = new BinaryOperation(bo.getOperation(), bo.getLeft(), bo.getRight(), pCtx);
                                }
                                bo.setRight(new BinaryOperation(op2, bo.getRight(), tk2, pCtx));
                            }
                        } else if (Operator.PTABLE[bo.getOperation()] >= Operator.PTABLE[op2]) {
                            bo = new BinaryOperation(op2, bo, astLinkedList.nextNode(), pCtx);
                        } else {
                            tk2 = astLinkedList.nextNode();
                            if (CompilerTools.isIntOptimizationviolation(bo, tk2)) {
                                bo = new BinaryOperation(bo.getOperation(), bo.getLeft(), bo.getRight(), pCtx);
                            }
                            bo.setRight(new BinaryOperation(op2, bo.getRight(), tk2, pCtx));
                        }
                        op = op2;
                        tkOp = tkOp2;
                    }
                    if (tkOp2 != null && tkOp2 != tkOp) {
                        CompilerTools.optimizeOperator(tkOp2.getOperator(), bo, tkOp2, astLinkedList, optimizedAst, pCtx);
                        continue;
                    }
                    optimizedAst.addTokenNode(bo);
                    continue;
                }
                if (tkOp.isOperator()) {
                    CompilerTools.optimizeOperator(tkOp.getOperator(), tk, tkOp, astLinkedList, optimizedAst, pCtx);
                    continue;
                }
                if (!tkOp.isAssignment() && !tkOp.isOperator() && tk.getLiteralValue() instanceof Class) {
                    optimizedAst.addTokenNode(new DeclTypedVarNode(tkOp.getName(), tkOp.getExpr(), tkOp.getStart(), tk.getOffset(), (Class)tk.getLiteralValue(), 0, pCtx));
                    continue;
                }
                if (tkOp.isAssignment() && tk.getLiteralValue() instanceof Class) {
                    tk.discard();
                    optimizedAst.addTokenNode(tkOp);
                    continue;
                }
                if (astLinkedList.hasMoreNodes() && tkOp.getLiteralValue() instanceof Class && astLinkedList.peekNode().isAssignment()) {
                    tkOp.discard();
                    optimizedAst.addTokenNode(tk, astLinkedList.nextNode());
                    continue;
                }
                astLinkedList.back();
                optimizedAst.addTokenNode(tk);
                continue;
            }
            optimizedAst.addTokenNode(tk);
        }
        if (secondPassOptimization) {
            astLinkedList = optimizedAst;
            astLinkedList.reset();
            optimizedAst = new ASTLinkedList();
            while (astLinkedList.hasMoreNodes()) {
                tk = astLinkedList.nextNode();
                if (tk.getFields() == -1) {
                    optimizedAst.addTokenNode(tk);
                    continue;
                }
                if (astLinkedList.hasMoreNodes()) {
                    tkOp = astLinkedList.nextNode();
                    if (tkOp.getFields() == -1) {
                        optimizedAst.addTokenNode(tk, tkOp);
                        continue;
                    }
                    if (tkOp.isOperator() && (tkOp.getOperator() == 21 || tkOp.getOperator() == 22)) {
                        tkOp2 = null;
                        BooleanNode bool = tkOp.getOperator() == 21 ? new And(tk, astLinkedList.nextNode(), pCtx.isStrongTyping(), pCtx) : new Or(tk, astLinkedList.nextNode(), pCtx.isStrongTyping(), pCtx);
                        while (astLinkedList.hasMoreNodes() && (tkOp2 = astLinkedList.nextNode()).isOperator() && (tkOp2.isOperator(21) || tkOp2.isOperator(22))) {
                            tkOp = tkOp2;
                            if (tkOp.getOperator() == 21) {
                                bool.setRightMost(new And(bool.getRightMost(), astLinkedList.nextNode(), pCtx.isStrongTyping(), pCtx));
                                continue;
                            }
                            bool = new Or(bool, astLinkedList.nextNode(), pCtx.isStrongTyping(), pCtx);
                        }
                        optimizedAst.addTokenNode(bool);
                        if (tkOp2 == null || tkOp2 == tkOp) continue;
                        optimizedAst.addTokenNode(tkOp2);
                        continue;
                    }
                    optimizedAst.addTokenNode(tk, tkOp);
                    continue;
                }
                optimizedAst.addTokenNode(tk);
            }
        }
        return optimizedAst;
    }

    private static BinaryOperation boOptimize(int op, ASTNode tk, ASTNode tk2, ParserContext pCtx) {
        if (tk.getEgressType() == Integer.class && tk2.getEgressType() == Integer.class) {
            switch (op) {
                case 0: {
                    return new IntAdd(tk, tk2, pCtx);
                }
                case 1: {
                    return new IntSub(tk, tk2, pCtx);
                }
                case 2: {
                    return new IntMult(tk, tk2, pCtx);
                }
                case 3: {
                    return new IntDiv(tk, tk2, pCtx);
                }
            }
            return new BinaryOperation(op, tk, tk2, pCtx);
        }
        return new BinaryOperation(op, tk, tk2, pCtx);
    }

    private static boolean isReductionOpportunity(ASTNode oper, ASTNode node) {
        ASTNode n = node;
        return n != null && n.isLiteral() && (n = n.nextASTNode) != null && CompilerTools.reducacbleOperator(n.getOperator()) && Operator.PTABLE[oper.getOperator()] <= Operator.PTABLE[n.getOperator()] && (n = n.nextASTNode) != null && n.isLiteral() && n.getLiteralValue() instanceof Number;
    }

    private static boolean reducacbleOperator(int oper) {
        switch (oper) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    private static void optimizeOperator(int operator, ASTNode tk, ASTNode tkOp, ASTLinkedList astLinkedList, ASTLinkedList optimizedAst, ParserContext pCtx) {
        switch (operator) {
            case 24: {
                optimizedAst.addTokenNode(new RegExMatchNode(tk, astLinkedList.nextNode(), pCtx));
                break;
            }
            case 26: {
                optimizedAst.addTokenNode(new Contains(tk, astLinkedList.nextNode(), pCtx));
                break;
            }
            case 25: {
                optimizedAst.addTokenNode(new Instance(tk, astLinkedList.nextNode(), pCtx));
                break;
            }
            case 36: {
                optimizedAst.addTokenNode(new Convertable(tk, astLinkedList.nextNode(), pCtx));
                break;
            }
            case 28: {
                optimizedAst.addTokenNode(new Strsim(tk, astLinkedList.nextNode(), pCtx));
                break;
            }
            case 27: {
                optimizedAst.addTokenNode(new Soundslike(tk, astLinkedList.nextNode(), pCtx));
                break;
            }
            case 29: {
                if (pCtx.isStrongTyping() && tk.getEgressType() != Boolean.class && tk.getEgressType() != Boolean.TYPE) {
                    throw new RuntimeException("Condition of ternary operator is not of type boolean. Found " + tk.getEgressType());
                }
            }
            default: {
                optimizedAst.addTokenNode(tk, tkOp);
            }
        }
    }

    private static boolean isIntOptimizationviolation(BooleanNode bn, ASTNode bn2) {
        return bn instanceof IntOptimized && bn2.getEgressType() != Integer.class;
    }

    public static Class getReturnType(ASTIterator input, boolean strongTyping) {
        ASTNode begin = input.firstNode();
        if (begin == null) {
            return Object.class;
        }
        if (input.size() == 1) {
            return begin.getEgressType();
        }
        return ASTBinaryTree.buildTree(input).getReturnType(strongTyping);
    }

    public static Map<String, Function> extractAllDeclaredFunctions(CompiledExpression compile) {
        LinkedHashMap<String, Function> allFunctions2 = new LinkedHashMap<String, Function>();
        ASTLinkedList instructions = new ASTLinkedList(compile.getFirstNode());
        while (instructions.hasMoreNodes()) {
            ASTNode n = instructions.nextNode();
            if (!(n instanceof Function)) continue;
            allFunctions2.put(n.getName(), (Function)n);
        }
        return allFunctions2;
    }

    public static void expectType(ParserContext pCtx, Accessor expression, Class type2, boolean compileMode) {
        Class retType = expression.getKnownEgressType();
        if (compileMode ? !(retType != null && ParseTools.boxPrimitive(type2).isAssignableFrom(ParseTools.boxPrimitive(retType)) || Object.class.equals((Object)retType) && !pCtx.isStrictTypeEnforcement()) : retType == null || !Object.class.equals((Object)retType) && !ParseTools.boxPrimitive(type2).isAssignableFrom(ParseTools.boxPrimitive(retType))) {
            throw new CompileException("was expecting type: " + type2.getName() + "; but found type: " + (retType != null ? retType.getName() : "<Unknown>"), new char[0], 0);
        }
    }

    public static void expectType(ParserContext pCtx, ASTNode node, Class type2, boolean compileMode) {
        Class<?> retType = ParseTools.boxPrimitive(node.getEgressType());
        if (compileMode ? (retType == null || !ParseTools.boxPrimitive(type2).isAssignableFrom(retType)) && !Object.class.equals(retType) && pCtx.isStrictTypeEnforcement() : retType == null || !Object.class.equals(retType) && !ParseTools.boxPrimitive(type2).isAssignableFrom(retType)) {
            throw new CompileException("was expecting type: " + type2.getName() + "; but found type: " + (retType != null ? retType.getName() : "<Unknown>"), new char[0], 0);
        }
    }

    public static Class getReturnTypeFromOp(int operation, Class left, Class right) {
        switch (operation) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 36: {
                return Boolean.class;
            }
            case 0: {
                if (left == String.class) {
                    return String.class;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (left == Object.class || right == Object.class) {
                    return Object.class;
                }
                return ParseTools.__resolveType(ParseTools.boxPrimitive(left)) < ParseTools.__resolveType(ParseTools.boxPrimitive(right)) ? right : left;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return Integer.class;
            }
            case 20: {
                return String.class;
            }
        }
        return null;
    }

    public static Accessor extractAccessor(ASTNode n) {
        if (n instanceof LiteralNode) {
            return new ExecutableLiteral(n.getLiteralValue());
        }
        return new ExecutableAccessor(n, n.getEgressType());
    }

    public static Map<String, Object> getInjectedImports(VariableResolverFactory factory) {
        if (factory == null) {
            return null;
        }
        do {
            if (!(factory instanceof ClassImportResolverFactory)) continue;
            return ((ClassImportResolverFactory)factory).getImportedClasses();
        } while ((factory = factory.getNextFactory()) != null);
        return null;
    }

    public static Number signNumber(Object number) {
        if (number instanceof Integer) {
            return -((Integer)number).intValue();
        }
        if (number instanceof Double) {
            return -((Double)number).doubleValue();
        }
        if (number instanceof Float) {
            return Float.valueOf(-((Float)number).floatValue());
        }
        if (number instanceof Short) {
            return (int)(-((Short)number).shortValue());
        }
        throw new CompileException("expected a numeric type but found: " + number.getClass().getName(), new char[0], 0);
    }
}

