/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Properties;
import com.zeroc.IceInternal.MetricsAdminI;
import com.zeroc.IceMX.Metrics;
import com.zeroc.IceMX.MetricsFailures;
import com.zeroc.IceMX.MetricsHelper;
import com.zeroc.IceMX.Observer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MetricsMap<T extends Metrics> {
    private final Map<String, String> _properties;
    private final List<String> _groupByAttributes;
    private final List<String> _groupBySeparators;
    private final int _retain;
    private final Map<String, Pattern> _accept;
    private final Map<String, Pattern> _reject;
    private final Class<T> _class;
    private final Map<String, Entry> _objects = new HashMap<String, Entry>();
    private final Map<String, SubMapCloneFactory<?>> _subMaps;
    private Deque<Entry> _detachedQueue;

    MetricsMap(String mapPrefix, Class<T> cl, Properties props, Map<String, SubMapFactory<?>> subMaps) {
        MetricsAdminI.validateProperties(mapPrefix, props);
        this._properties = props.getPropertiesForPrefix(mapPrefix);
        this._retain = props.getPropertyAsIntWithDefault(mapPrefix + "RetainDetached", 10);
        this._accept = this.parseRule(props, mapPrefix + "Accept");
        this._reject = this.parseRule(props, mapPrefix + "Reject");
        this._groupByAttributes = new ArrayList<String>();
        this._groupBySeparators = new ArrayList<String>();
        this._class = cl;
        String groupBy = props.getPropertyWithDefault(mapPrefix + "GroupBy", "id");
        if (!groupBy.isEmpty()) {
            boolean attribute;
            String v = "";
            boolean bl = attribute = Character.isLetter(groupBy.charAt(0)) || Character.isDigit(groupBy.charAt(0));
            if (!attribute) {
                this._groupByAttributes.add("");
            }
            for (char p : groupBy.toCharArray()) {
                boolean isAlphaNum;
                boolean bl2 = isAlphaNum = Character.isLetter(p) || Character.isDigit(p) || p == '.';
                if (attribute && !isAlphaNum) {
                    this._groupByAttributes.add(v);
                    v = "" + p;
                    attribute = false;
                    continue;
                }
                if (!attribute && isAlphaNum) {
                    this._groupBySeparators.add(v);
                    v = "" + p;
                    attribute = true;
                    continue;
                }
                v = v + p;
            }
            if (attribute) {
                this._groupByAttributes.add(v);
            } else {
                this._groupBySeparators.add(v);
            }
        }
        if (subMaps != null && !subMaps.isEmpty()) {
            this._subMaps = new HashMap();
            ArrayList<String> subMapNames = new ArrayList<String>();
            for (Map.Entry<String, SubMapFactory<?>> e : subMaps.entrySet()) {
                subMapNames.add(e.getKey());
                String subMapsPrefix = mapPrefix + "Map.";
                String subMapPrefix = subMapsPrefix + e.getKey() + '.';
                if (props.getPropertiesForPrefix(subMapPrefix).isEmpty()) {
                    if (!props.getPropertiesForPrefix(subMapsPrefix).isEmpty()) continue;
                    subMapPrefix = mapPrefix;
                }
                this._subMaps.put(e.getKey(), e.getValue().createCloneFactory(subMapPrefix, props));
            }
        } else {
            this._subMaps = null;
        }
    }

    MetricsMap(MetricsMap<T> map) {
        this._properties = map._properties;
        this._groupByAttributes = map._groupByAttributes;
        this._groupBySeparators = map._groupBySeparators;
        this._retain = map._retain;
        this._accept = map._accept;
        this._reject = map._reject;
        this._class = map._class;
        this._subMaps = map._subMaps;
    }

    Map<String, String> getProperties() {
        return this._properties;
    }

    synchronized Metrics[] getMetrics() {
        Metrics[] metrics = new Metrics[this._objects.size()];
        int i = 0;
        for (Entry e : this._objects.values()) {
            metrics[i++] = e.clone();
        }
        return metrics;
    }

    synchronized MetricsFailures[] getFailures() {
        ArrayList<MetricsFailures> failures = new ArrayList<MetricsFailures>();
        for (Entry e : this._objects.values()) {
            MetricsFailures f = e.getFailures();
            if (f == null) continue;
            failures.add(f);
        }
        return failures.toArray(new MetricsFailures[failures.size()]);
    }

    synchronized MetricsFailures getFailures(String id) {
        Entry e = this._objects.get(id);
        if (e != null) {
            return e.getFailures();
        }
        return null;
    }

    public <S extends Metrics> SubMap<S> createSubMap(String subMapName, Class<S> cl) {
        if (this._subMaps == null) {
            return null;
        }
        SubMapCloneFactory<?> factory = this._subMaps.get(subMapName);
        if (factory != null) {
            return factory.create();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getMatching(MetricsHelper<T> helper, Entry previous) {
        String key;
        for (Map.Entry<String, Pattern> e : this._accept.entrySet()) {
            if (this.match(e.getKey(), e.getValue(), helper, false)) continue;
            return null;
        }
        for (Map.Entry<String, Pattern> e : this._reject.entrySet()) {
            if (!this.match(e.getKey(), e.getValue(), helper, true)) continue;
            return null;
        }
        try {
            if (this._groupByAttributes.size() == 1) {
                key = helper.resolve(this._groupByAttributes.get(0));
            } else {
                StringBuilder os = new StringBuilder();
                Iterator<String> q = this._groupBySeparators.iterator();
                for (String p : this._groupByAttributes) {
                    os.append(helper.resolve(p));
                    if (!q.hasNext()) continue;
                    os.append(q.next());
                }
                key = os.toString();
            }
        }
        catch (Exception ex) {
            return null;
        }
        MetricsMap metricsMap = this;
        synchronized (metricsMap) {
            Entry e;
            block15: {
                if (previous != null && ((Entry)previous)._object.id.equals(key)) {
                    assert (this._objects.get(key) == previous);
                    return previous;
                }
                e = this._objects.get(key);
                if (e == null) {
                    try {
                        Metrics t = (Metrics)this._class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        t.id = key;
                        e = new Entry(this, t);
                        this._objects.put(key, e);
                    }
                    catch (Exception ex) {
                        if ($assertionsDisabled) break block15;
                        throw new AssertionError();
                    }
                }
            }
            e.attach(helper);
            return e;
        }
    }

    private void detached(Entry entry) {
        if (this._retain == 0) {
            return;
        }
        if (this._detachedQueue == null) {
            this._detachedQueue = new LinkedList<Entry>();
        }
        assert (this._detachedQueue.size() <= this._retain);
        Iterator<Entry> p = this._detachedQueue.iterator();
        while (p.hasNext()) {
            Entry e = p.next();
            if (e != entry && e.isDetached()) continue;
            p.remove();
        }
        if (this._detachedQueue.size() == this._retain) {
            this._objects.remove(((Entry)this._detachedQueue.pollFirst())._object.id);
        }
        this._detachedQueue.add(entry);
    }

    private Map<String, Pattern> parseRule(Properties properties, String name) {
        HashMap<String, Pattern> pats = new HashMap<String, Pattern>();
        Map<String, String> rules = properties.getPropertiesForPrefix(name + '.');
        for (Map.Entry<String, String> e : rules.entrySet()) {
            pats.put(e.getKey().substring(name.length() + 1), Pattern.compile(e.getValue()));
        }
        return pats;
    }

    private boolean match(String attribute, Pattern regex, MetricsHelper<T> helper, boolean reject) {
        String value;
        try {
            value = helper.resolve(attribute);
        }
        catch (Exception ex) {
            return !reject;
        }
        return regex.matcher(value).matches();
    }

    static class SubMapFactory<S extends Metrics> {
        private final Class<S> _class;
        private final Field _field;

        SubMapFactory(Class<S> cl, Field field) {
            this._class = cl;
            this._field = field;
        }

        SubMapCloneFactory<S> createCloneFactory(String subMapPrefix, Properties properties) {
            return new SubMapCloneFactory<S>(new MetricsMap<S>(subMapPrefix, this._class, properties, null), this._field);
        }
    }

    static class SubMapCloneFactory<S extends Metrics> {
        private final MetricsMap<S> _map;
        private final Field _field;

        public SubMapCloneFactory(MetricsMap<S> map, Field field) {
            this._map = map;
            this._field = field;
        }

        public SubMap<S> create() {
            return new SubMap<S>(new MetricsMap<S>(this._map), this._field);
        }
    }

    static class SubMap<S extends Metrics> {
        private final MetricsMap<S> _map;
        private final Field _field;

        public SubMap(MetricsMap<S> map, Field field) {
            this._map = map;
            this._field = field;
        }

        public Entry getMatching(MetricsHelper<S> helper) {
            return this._map.getMatching(helper, null);
        }

        public void addSubMapToMetrics(Metrics metrics) {
            block2: {
                try {
                    this._field.set(metrics, this._map.getMetrics());
                }
                catch (Exception ex) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }
    }

    public static class Entry {
        private T _object;
        private Map<String, Integer> _failures;
        private Map<String, SubMap<?>> _subMaps;
        final /* synthetic */ MetricsMap this$0;

        Entry(T obj) {
            this.this$0 = this$0;
            this._object = obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(String exceptionName) {
            MetricsMap metricsMap = this.this$0;
            synchronized (metricsMap) {
                Integer count;
                ++((Metrics)this._object).failures;
                if (this._failures == null) {
                    this._failures = new HashMap<String, Integer>();
                }
                this._failures.put(exceptionName, (count = this._failures.get(exceptionName)) == null ? 1 : count + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <S extends Metrics> Entry getMatching(String mapName, MetricsHelper<S> helper, Class<S> cl) {
            SubMap<Object> m;
            MetricsMap metricsMap = this.this$0;
            synchronized (metricsMap) {
                SubMap<?> subMap = m = this._subMaps != null ? this._subMaps.get(mapName) : null;
                if (m == null) {
                    m = this.this$0.createSubMap(mapName, cl);
                    if (m == null) {
                        return null;
                    }
                    if (this._subMaps == null) {
                        this._subMaps = new HashMap();
                    }
                    this._subMaps.put(mapName, m);
                }
            }
            return m.getMatching(helper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach(long lifetime) {
            MetricsMap metricsMap = this.this$0;
            synchronized (metricsMap) {
                ((Metrics)this._object).totalLifetime += lifetime;
                if (--((Metrics)this._object).current == 0) {
                    this.this$0.detached(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Observer.MetricsUpdate<T> func) {
            MetricsMap metricsMap = this.this$0;
            synchronized (metricsMap) {
                func.update(this._object);
            }
        }

        public MetricsMap<?> getMap() {
            return this.this$0;
        }

        private MetricsFailures getFailures() {
            if (this._failures == null) {
                return null;
            }
            MetricsFailures f = new MetricsFailures();
            f.id = ((Metrics)this._object).id;
            f.failures = new HashMap<String, Integer>(this._failures);
            return f;
        }

        private void attach(MetricsHelper<T> helper) {
            ++((Metrics)this._object).total;
            ++((Metrics)this._object).current;
            helper.initMetrics(this._object);
        }

        private boolean isDetached() {
            return ((Metrics)this._object).current == 0;
        }

        public Metrics clone() {
            Metrics metrics = ((Metrics)this._object).clone();
            if (this._subMaps != null) {
                for (SubMap<?> s : this._subMaps.values()) {
                    s.addSubMapToMetrics(metrics);
                }
            }
            return metrics;
        }
    }
}

