/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceMX;

import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.EndpointInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MetricsHelper<T> {
    private AttributeResolver _attributes;

    protected MetricsHelper(AttributeResolver attributes) {
        this._attributes = attributes;
    }

    public String resolve(String attribute) {
        return this._attributes.resolve(this, attribute);
    }

    public void initMetrics(T metrics) {
    }

    protected String defaultResolve(String attribute) {
        return null;
    }

    public static class AttributeResolver {
        private Map<String, Resolver> _attributes = new HashMap<String, Resolver>();

        protected AttributeResolver() {
        }

        public String resolve(MetricsHelper<?> helper, String attribute) {
            Resolver resolver = this._attributes.get(attribute);
            if (resolver == null) {
                if (attribute.equals("none")) {
                    return "";
                }
                String v = helper.defaultResolve(attribute);
                if (v != null) {
                    return v;
                }
                throw new IllegalArgumentException(attribute);
            }
            return resolver.resolveImpl(helper);
        }

        public void add(String name, final Method method) {
            this._attributes.put(name, new Resolver(){

                @Override
                public Object resolve(Object obj) throws Exception {
                    return method.invoke(obj, new Object[0]);
                }
            });
        }

        public void add(final String name, final Field field) {
            this._attributes.put(name, new Resolver(){

                @Override
                public Object resolve(Object obj) throws Exception {
                    return this.getField(name, field, obj);
                }
            });
        }

        public void add(final String name, final Method method, final Field field) {
            this._attributes.put(name, new Resolver(){

                @Override
                public Object resolve(Object obj) throws Exception {
                    return this.getField(name, field, method.invoke(obj, new Object[0]));
                }
            });
        }

        public void add(final String name, final Method method, final Method subMethod) {
            this._attributes.put(name, new Resolver(){

                @Override
                public Object resolve(Object obj) throws Exception {
                    Object o = method.invoke(obj, new Object[0]);
                    if (o != null) {
                        return subMethod.invoke(o, new Object[0]);
                    }
                    throw new IllegalArgumentException(name);
                }
            });
        }

        private Object getField(String name, Field field, Object o) throws IllegalArgumentException, IllegalAccessException {
            while (o != null) {
                try {
                    return field.get(o);
                }
                catch (IllegalArgumentException ex) {
                    if (o instanceof EndpointInfo) {
                        o = ((EndpointInfo)o).underlying;
                        continue;
                    }
                    if (o instanceof ConnectionInfo) {
                        o = ((ConnectionInfo)o).underlying;
                        continue;
                    }
                    throw ex;
                }
            }
            throw new IllegalArgumentException(name);
        }

        private abstract class Resolver {
            private Resolver() {
            }

            abstract Object resolve(Object var1) throws Exception;

            String resolveImpl(Object obj) {
                try {
                    Object result = this.resolve(obj);
                    if (result != null) {
                        return result.toString();
                    }
                    return "";
                }
                catch (IllegalArgumentException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    assert (false);
                    return null;
                }
            }
        }
    }
}

