"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefinition = void 0;
const vscode_languageserver_1 = require("vscode-languageserver");
const vscode_uri_1 = require("vscode-uri");
const yaml_1 = require("yaml");
const misc_1 = require("../utils/misc");
const yaml_2 = require("../utils/yaml");
async function getDefinition(document, position, docsLibrary) {
    const yamlDocs = (0, yaml_2.parseAllDocuments)(document.getText());
    const path = (0, yaml_2.getPathAt)(document, position, yamlDocs);
    if (path) {
        const node = path[path.length - 1];
        if ((0, yaml_1.isScalar)(node) &&
            new yaml_2.AncestryBuilder(path).parentOfKey().get() // ensure we look at a key, not value of a Pair
        ) {
            if ((0, yaml_2.isTaskParam)(path)) {
                const [module] = await docsLibrary.findModule(node.value, path, document.uri);
                if (module) {
                    const range = (0, yaml_2.getOrigRange)(node);
                    return [
                        {
                            targetUri: vscode_uri_1.URI.file(module.source).toString(),
                            originSelectionRange: range
                                ? (0, misc_1.toLspRange)(range, document)
                                : undefined,
                            targetRange: vscode_languageserver_1.Range.create(module.sourceLineRange[0], 0, module.sourceLineRange[1], 0),
                            targetSelectionRange: vscode_languageserver_1.Range.create(module.sourceLineRange[0], 0, module.sourceLineRange[1], 0),
                        },
                    ];
                }
            }
        }
    }
    return null;
}
exports.getDefinition = getDefinition;
