"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUnsupportedError = exports.withInterpreter = exports.insert = exports.isObject = exports.hasOwnProperty = exports.toLspRange = exports.asyncExec = exports.fileExists = void 0;
const child_process = __importStar(require("child_process"));
const fs_1 = require("fs");
const util_1 = require("util");
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const path = __importStar(require("path"));
async function fileExists(filePath) {
    return !!(await fs_1.promises.stat(filePath).catch(() => false));
}
exports.fileExists = fileExists;
exports.asyncExec = (0, util_1.promisify)(child_process.exec);
function toLspRange(range, textDocument) {
    const start = textDocument.positionAt(range[0]);
    const end = textDocument.positionAt(range[1]);
    return vscode_languageserver_types_1.Range.create(start, end);
}
exports.toLspRange = toLspRange;
function hasOwnProperty(obj, prop) {
    return isObject(obj) && Object.prototype.hasOwnProperty.call(obj, prop);
}
exports.hasOwnProperty = hasOwnProperty;
/**
 * Checks whether `obj` is a non-null object.
 */
function isObject(obj) {
    return obj && typeof obj === "object";
}
exports.isObject = isObject;
function insert(str, index, val) {
    return `${str.substring(0, index)}${val}${str.substring(index)}`;
}
exports.insert = insert;
/**
 * Adjusts the command and environment in case the interpreter path is provided.
 */
function withInterpreter(executable, args, interpreterPath, activationScript) {
    let command = `${executable} ${args}`; // base case
    const newEnv = Object.assign({}, process.env, {
        NO_COLOR: "1", // ensure none of the output produce color characters
        ANSIBLE_FORCE_COLOR: "0", // ensure output is parseable (no ANSI)
        PYTHONBREAKPOINT: "0", // We want to be sure that python debugger is never
        // triggered, even if we mistakenly left a breakpoint() there while
        // debugging ansible- lint, or another tool we call.
    });
    if (activationScript) {
        command = `bash -c 'source ${activationScript} && ${executable} ${args}'`;
        return [command, undefined];
    }
    if (interpreterPath) {
        const virtualEnv = path.resolve(interpreterPath, "../..");
        const pathEntry = path.join(virtualEnv, "bin");
        if (path.isAbsolute(executable)) {
            // if the user provided a path to the executable, we directly execute the app.
            command = `${executable} ${args}`;
        }
        // emulating virtual environment activation script
        newEnv["VIRTUAL_ENV"] = virtualEnv;
        newEnv["PATH"] = `${pathEntry}:${process.env.PATH}`;
        delete newEnv.PYTHONHOME;
    }
    return [command, newEnv];
}
exports.withInterpreter = withInterpreter;
/**
 * Returns errors messages when LS is run on unsupported platform, or undefined
 * when all is fine.
 */
function getUnsupportedError() {
    // win32 applies to x64 arch too, is the platform name
    if (process.platform === "win32") {
        return "Ansible Language Server can only run inside WSL on Windows. Refer to vscode documentation for more details.";
    }
}
exports.getUnsupportedError = getUnsupportedError;
