﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codecommit/CodeCommit_EXPORTS.h>
#include <aws/codecommit/model/BatchGetRepositoriesErrorCodeEnum.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CodeCommit {
namespace Model {

/**
 * <p>Returns information about errors in a BatchGetRepositories
 * operation.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositoriesError">AWS
 * API Reference</a></p>
 */
class BatchGetRepositoriesError {
 public:
  AWS_CODECOMMIT_API BatchGetRepositoriesError() = default;
  AWS_CODECOMMIT_API BatchGetRepositoriesError(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODECOMMIT_API BatchGetRepositoriesError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODECOMMIT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of a repository that either could not be found or was not in a valid
   * state.</p>
   */
  inline const Aws::String& GetRepositoryId() const { return m_repositoryId; }
  inline bool RepositoryIdHasBeenSet() const { return m_repositoryIdHasBeenSet; }
  template <typename RepositoryIdT = Aws::String>
  void SetRepositoryId(RepositoryIdT&& value) {
    m_repositoryIdHasBeenSet = true;
    m_repositoryId = std::forward<RepositoryIdT>(value);
  }
  template <typename RepositoryIdT = Aws::String>
  BatchGetRepositoriesError& WithRepositoryId(RepositoryIdT&& value) {
    SetRepositoryId(std::forward<RepositoryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of a repository that either could not be found or was not in a valid
   * state.</p>
   */
  inline const Aws::String& GetRepositoryName() const { return m_repositoryName; }
  inline bool RepositoryNameHasBeenSet() const { return m_repositoryNameHasBeenSet; }
  template <typename RepositoryNameT = Aws::String>
  void SetRepositoryName(RepositoryNameT&& value) {
    m_repositoryNameHasBeenSet = true;
    m_repositoryName = std::forward<RepositoryNameT>(value);
  }
  template <typename RepositoryNameT = Aws::String>
  BatchGetRepositoriesError& WithRepositoryName(RepositoryNameT&& value) {
    SetRepositoryName(std::forward<RepositoryNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An error code that specifies the type of failure.</p>
   */
  inline BatchGetRepositoriesErrorCodeEnum GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  inline void SetErrorCode(BatchGetRepositoriesErrorCodeEnum value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = value;
  }
  inline BatchGetRepositoriesError& WithErrorCode(BatchGetRepositoriesErrorCodeEnum value) {
    SetErrorCode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An error message that provides detail about why the repository either was not
   * found or was not in a valid state.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  BatchGetRepositoriesError& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_repositoryId;
  bool m_repositoryIdHasBeenSet = false;

  Aws::String m_repositoryName;
  bool m_repositoryNameHasBeenSet = false;

  BatchGetRepositoriesErrorCodeEnum m_errorCode{BatchGetRepositoriesErrorCodeEnum::NOT_SET};
  bool m_errorCodeHasBeenSet = false;

  Aws::String m_errorMessage;
  bool m_errorMessageHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeCommit
}  // namespace Aws
