﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/dynamodbstreams/DynamoDBStreams_EXPORTS.h>
#include <aws/dynamodbstreams/model/Record.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DynamoDBStreams {
namespace Model {
/**
 * <p>Represents the output of a <code>GetRecords</code> operation.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/GetRecordsOutput">AWS
 * API Reference</a></p>
 */
class GetRecordsResult {
 public:
  AWS_DYNAMODBSTREAMS_API GetRecordsResult() = default;
  AWS_DYNAMODBSTREAMS_API GetRecordsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DYNAMODBSTREAMS_API GetRecordsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The stream records from the shard, which were retrieved using the shard
   * iterator.</p>
   */
  inline const Aws::Vector<Record>& GetRecords() const { return m_records; }
  template <typename RecordsT = Aws::Vector<Record>>
  void SetRecords(RecordsT&& value) {
    m_recordsHasBeenSet = true;
    m_records = std::forward<RecordsT>(value);
  }
  template <typename RecordsT = Aws::Vector<Record>>
  GetRecordsResult& WithRecords(RecordsT&& value) {
    SetRecords(std::forward<RecordsT>(value));
    return *this;
  }
  template <typename RecordsT = Record>
  GetRecordsResult& AddRecords(RecordsT&& value) {
    m_recordsHasBeenSet = true;
    m_records.emplace_back(std::forward<RecordsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The next position in the shard from which to start sequentially reading
   * stream records. If set to <code>null</code>, the shard has been closed and the
   * requested iterator will not return any more data.</p>
   */
  inline const Aws::String& GetNextShardIterator() const { return m_nextShardIterator; }
  template <typename NextShardIteratorT = Aws::String>
  void SetNextShardIterator(NextShardIteratorT&& value) {
    m_nextShardIteratorHasBeenSet = true;
    m_nextShardIterator = std::forward<NextShardIteratorT>(value);
  }
  template <typename NextShardIteratorT = Aws::String>
  GetRecordsResult& WithNextShardIterator(NextShardIteratorT&& value) {
    SetNextShardIterator(std::forward<NextShardIteratorT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetRecordsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Record> m_records;
  bool m_recordsHasBeenSet = false;

  Aws::String m_nextShardIterator;
  bool m_nextShardIteratorHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DynamoDBStreams
}  // namespace Aws
