﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/S3SourceAdditionalOptions.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>Specifies the data store in the governed Glue Data Catalog.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GovernedCatalogSource">AWS
 * API Reference</a></p>
 */
class GovernedCatalogSource {
 public:
  AWS_GLUE_API GovernedCatalogSource() = default;
  AWS_GLUE_API GovernedCatalogSource(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API GovernedCatalogSource& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the data store.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GovernedCatalogSource& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The database to read from.</p>
   */
  inline const Aws::String& GetDatabase() const { return m_database; }
  inline bool DatabaseHasBeenSet() const { return m_databaseHasBeenSet; }
  template <typename DatabaseT = Aws::String>
  void SetDatabase(DatabaseT&& value) {
    m_databaseHasBeenSet = true;
    m_database = std::forward<DatabaseT>(value);
  }
  template <typename DatabaseT = Aws::String>
  GovernedCatalogSource& WithDatabase(DatabaseT&& value) {
    SetDatabase(std::forward<DatabaseT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The database table to read from.</p>
   */
  inline const Aws::String& GetTable() const { return m_table; }
  inline bool TableHasBeenSet() const { return m_tableHasBeenSet; }
  template <typename TableT = Aws::String>
  void SetTable(TableT&& value) {
    m_tableHasBeenSet = true;
    m_table = std::forward<TableT>(value);
  }
  template <typename TableT = Aws::String>
  GovernedCatalogSource& WithTable(TableT&& value) {
    SetTable(std::forward<TableT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Partitions satisfying this predicate are deleted. Files within the retention
   * period in these partitions are not deleted. Set to <code>""</code> – empty by
   * default.</p>
   */
  inline const Aws::String& GetPartitionPredicate() const { return m_partitionPredicate; }
  inline bool PartitionPredicateHasBeenSet() const { return m_partitionPredicateHasBeenSet; }
  template <typename PartitionPredicateT = Aws::String>
  void SetPartitionPredicate(PartitionPredicateT&& value) {
    m_partitionPredicateHasBeenSet = true;
    m_partitionPredicate = std::forward<PartitionPredicateT>(value);
  }
  template <typename PartitionPredicateT = Aws::String>
  GovernedCatalogSource& WithPartitionPredicate(PartitionPredicateT&& value) {
    SetPartitionPredicate(std::forward<PartitionPredicateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies additional connection options.</p>
   */
  inline const S3SourceAdditionalOptions& GetAdditionalOptions() const { return m_additionalOptions; }
  inline bool AdditionalOptionsHasBeenSet() const { return m_additionalOptionsHasBeenSet; }
  template <typename AdditionalOptionsT = S3SourceAdditionalOptions>
  void SetAdditionalOptions(AdditionalOptionsT&& value) {
    m_additionalOptionsHasBeenSet = true;
    m_additionalOptions = std::forward<AdditionalOptionsT>(value);
  }
  template <typename AdditionalOptionsT = S3SourceAdditionalOptions>
  GovernedCatalogSource& WithAdditionalOptions(AdditionalOptionsT&& value) {
    SetAdditionalOptions(std::forward<AdditionalOptionsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_database;
  bool m_databaseHasBeenSet = false;

  Aws::String m_table;
  bool m_tableHasBeenSet = false;

  Aws::String m_partitionPredicate;
  bool m_partitionPredicateHasBeenSet = false;

  S3SourceAdditionalOptions m_additionalOptions;
  bool m_additionalOptionsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
