﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/inspector2/model/CodeRepositoryProviderType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Inspector2 {
namespace Model {

/**
 * <p>Contains details about a code repository associated with a
 * finding.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CodeRepositoryDetails">AWS
 * API Reference</a></p>
 */
class CodeRepositoryDetails {
 public:
  AWS_INSPECTOR2_API CodeRepositoryDetails() = default;
  AWS_INSPECTOR2_API CodeRepositoryDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_INSPECTOR2_API CodeRepositoryDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the project in the code repository.</p>
   */
  inline const Aws::String& GetProjectName() const { return m_projectName; }
  inline bool ProjectNameHasBeenSet() const { return m_projectNameHasBeenSet; }
  template <typename ProjectNameT = Aws::String>
  void SetProjectName(ProjectNameT&& value) {
    m_projectNameHasBeenSet = true;
    m_projectName = std::forward<ProjectNameT>(value);
  }
  template <typename ProjectNameT = Aws::String>
  CodeRepositoryDetails& WithProjectName(ProjectNameT&& value) {
    SetProjectName(std::forward<ProjectNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the code security integration associated
   * with the repository.</p>
   */
  inline const Aws::String& GetIntegrationArn() const { return m_integrationArn; }
  inline bool IntegrationArnHasBeenSet() const { return m_integrationArnHasBeenSet; }
  template <typename IntegrationArnT = Aws::String>
  void SetIntegrationArn(IntegrationArnT&& value) {
    m_integrationArnHasBeenSet = true;
    m_integrationArn = std::forward<IntegrationArnT>(value);
  }
  template <typename IntegrationArnT = Aws::String>
  CodeRepositoryDetails& WithIntegrationArn(IntegrationArnT&& value) {
    SetIntegrationArn(std::forward<IntegrationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of repository provider (such as GitHub, GitLab, etc.).</p>
   */
  inline CodeRepositoryProviderType GetProviderType() const { return m_providerType; }
  inline bool ProviderTypeHasBeenSet() const { return m_providerTypeHasBeenSet; }
  inline void SetProviderType(CodeRepositoryProviderType value) {
    m_providerTypeHasBeenSet = true;
    m_providerType = value;
  }
  inline CodeRepositoryDetails& WithProviderType(CodeRepositoryProviderType value) {
    SetProviderType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_projectName;
  bool m_projectNameHasBeenSet = false;

  Aws::String m_integrationArn;
  bool m_integrationArnHasBeenSet = false;

  CodeRepositoryProviderType m_providerType{CodeRepositoryProviderType::NOT_SET};
  bool m_providerTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Inspector2
}  // namespace Aws
