﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class CreateEdgeDeploymentPlanResult {
 public:
  AWS_SAGEMAKER_API CreateEdgeDeploymentPlanResult() = default;
  AWS_SAGEMAKER_API CreateEdgeDeploymentPlanResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API CreateEdgeDeploymentPlanResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the edge deployment plan.</p>
   */
  inline const Aws::String& GetEdgeDeploymentPlanArn() const { return m_edgeDeploymentPlanArn; }
  template <typename EdgeDeploymentPlanArnT = Aws::String>
  void SetEdgeDeploymentPlanArn(EdgeDeploymentPlanArnT&& value) {
    m_edgeDeploymentPlanArnHasBeenSet = true;
    m_edgeDeploymentPlanArn = std::forward<EdgeDeploymentPlanArnT>(value);
  }
  template <typename EdgeDeploymentPlanArnT = Aws::String>
  CreateEdgeDeploymentPlanResult& WithEdgeDeploymentPlanArn(EdgeDeploymentPlanArnT&& value) {
    SetEdgeDeploymentPlanArn(std::forward<EdgeDeploymentPlanArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateEdgeDeploymentPlanResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_edgeDeploymentPlanArn;
  bool m_edgeDeploymentPlanArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
