﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/workdocs/WorkDocs_EXPORTS.h>
#include <aws/workdocs/model/ResourceStateType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkDocs {
namespace Model {

/**
 * <p>Describes a folder.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/FolderMetadata">AWS
 * API Reference</a></p>
 */
class FolderMetadata {
 public:
  AWS_WORKDOCS_API FolderMetadata() = default;
  AWS_WORKDOCS_API FolderMetadata(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKDOCS_API FolderMetadata& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKDOCS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the folder.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  FolderMetadata& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the folder.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  FolderMetadata& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the creator.</p>
   */
  inline const Aws::String& GetCreatorId() const { return m_creatorId; }
  inline bool CreatorIdHasBeenSet() const { return m_creatorIdHasBeenSet; }
  template <typename CreatorIdT = Aws::String>
  void SetCreatorId(CreatorIdT&& value) {
    m_creatorIdHasBeenSet = true;
    m_creatorId = std::forward<CreatorIdT>(value);
  }
  template <typename CreatorIdT = Aws::String>
  FolderMetadata& WithCreatorId(CreatorIdT&& value) {
    SetCreatorId(std::forward<CreatorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the parent folder.</p>
   */
  inline const Aws::String& GetParentFolderId() const { return m_parentFolderId; }
  inline bool ParentFolderIdHasBeenSet() const { return m_parentFolderIdHasBeenSet; }
  template <typename ParentFolderIdT = Aws::String>
  void SetParentFolderId(ParentFolderIdT&& value) {
    m_parentFolderIdHasBeenSet = true;
    m_parentFolderId = std::forward<ParentFolderIdT>(value);
  }
  template <typename ParentFolderIdT = Aws::String>
  FolderMetadata& WithParentFolderId(ParentFolderIdT&& value) {
    SetParentFolderId(std::forward<ParentFolderIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the folder was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTimestamp() const { return m_createdTimestamp; }
  inline bool CreatedTimestampHasBeenSet() const { return m_createdTimestampHasBeenSet; }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  void SetCreatedTimestamp(CreatedTimestampT&& value) {
    m_createdTimestampHasBeenSet = true;
    m_createdTimestamp = std::forward<CreatedTimestampT>(value);
  }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  FolderMetadata& WithCreatedTimestamp(CreatedTimestampT&& value) {
    SetCreatedTimestamp(std::forward<CreatedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the folder was updated.</p>
   */
  inline const Aws::Utils::DateTime& GetModifiedTimestamp() const { return m_modifiedTimestamp; }
  inline bool ModifiedTimestampHasBeenSet() const { return m_modifiedTimestampHasBeenSet; }
  template <typename ModifiedTimestampT = Aws::Utils::DateTime>
  void SetModifiedTimestamp(ModifiedTimestampT&& value) {
    m_modifiedTimestampHasBeenSet = true;
    m_modifiedTimestamp = std::forward<ModifiedTimestampT>(value);
  }
  template <typename ModifiedTimestampT = Aws::Utils::DateTime>
  FolderMetadata& WithModifiedTimestamp(ModifiedTimestampT&& value) {
    SetModifiedTimestamp(std::forward<ModifiedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource state of the folder.</p>
   */
  inline ResourceStateType GetResourceState() const { return m_resourceState; }
  inline bool ResourceStateHasBeenSet() const { return m_resourceStateHasBeenSet; }
  inline void SetResourceState(ResourceStateType value) {
    m_resourceStateHasBeenSet = true;
    m_resourceState = value;
  }
  inline FolderMetadata& WithResourceState(ResourceStateType value) {
    SetResourceState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier created from the subfolders and documents of the
   * folder.</p>
   */
  inline const Aws::String& GetSignature() const { return m_signature; }
  inline bool SignatureHasBeenSet() const { return m_signatureHasBeenSet; }
  template <typename SignatureT = Aws::String>
  void SetSignature(SignatureT&& value) {
    m_signatureHasBeenSet = true;
    m_signature = std::forward<SignatureT>(value);
  }
  template <typename SignatureT = Aws::String>
  FolderMetadata& WithSignature(SignatureT&& value) {
    SetSignature(std::forward<SignatureT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>List of labels on the folder.</p>
   */
  inline const Aws::Vector<Aws::String>& GetLabels() const { return m_labels; }
  inline bool LabelsHasBeenSet() const { return m_labelsHasBeenSet; }
  template <typename LabelsT = Aws::Vector<Aws::String>>
  void SetLabels(LabelsT&& value) {
    m_labelsHasBeenSet = true;
    m_labels = std::forward<LabelsT>(value);
  }
  template <typename LabelsT = Aws::Vector<Aws::String>>
  FolderMetadata& WithLabels(LabelsT&& value) {
    SetLabels(std::forward<LabelsT>(value));
    return *this;
  }
  template <typename LabelsT = Aws::String>
  FolderMetadata& AddLabels(LabelsT&& value) {
    m_labelsHasBeenSet = true;
    m_labels.emplace_back(std::forward<LabelsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The size of the folder metadata.</p>
   */
  inline long long GetSize() const { return m_size; }
  inline bool SizeHasBeenSet() const { return m_sizeHasBeenSet; }
  inline void SetSize(long long value) {
    m_sizeHasBeenSet = true;
    m_size = value;
  }
  inline FolderMetadata& WithSize(long long value) {
    SetSize(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The size of the latest version of the folder metadata.</p>
   */
  inline long long GetLatestVersionSize() const { return m_latestVersionSize; }
  inline bool LatestVersionSizeHasBeenSet() const { return m_latestVersionSizeHasBeenSet; }
  inline void SetLatestVersionSize(long long value) {
    m_latestVersionSizeHasBeenSet = true;
    m_latestVersionSize = value;
  }
  inline FolderMetadata& WithLatestVersionSize(long long value) {
    SetLatestVersionSize(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_creatorId;
  bool m_creatorIdHasBeenSet = false;

  Aws::String m_parentFolderId;
  bool m_parentFolderIdHasBeenSet = false;

  Aws::Utils::DateTime m_createdTimestamp{};
  bool m_createdTimestampHasBeenSet = false;

  Aws::Utils::DateTime m_modifiedTimestamp{};
  bool m_modifiedTimestampHasBeenSet = false;

  ResourceStateType m_resourceState{ResourceStateType::NOT_SET};
  bool m_resourceStateHasBeenSet = false;

  Aws::String m_signature;
  bool m_signatureHasBeenSet = false;

  Aws::Vector<Aws::String> m_labels;
  bool m_labelsHasBeenSet = false;

  long long m_size{0};
  bool m_sizeHasBeenSet = false;

  long long m_latestVersionSize{0};
  bool m_latestVersionSizeHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkDocs
}  // namespace Aws
