﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workmail/WorkMail_EXPORTS.h>
#include <aws/workmail/model/ImpersonationRoleType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkMail {
namespace Model {

/**
 * <p>An impersonation role for the given WorkMail organization.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ImpersonationRole">AWS
 * API Reference</a></p>
 */
class ImpersonationRole {
 public:
  AWS_WORKMAIL_API ImpersonationRole() = default;
  AWS_WORKMAIL_API ImpersonationRole(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKMAIL_API ImpersonationRole& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKMAIL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the impersonation role.</p>
   */
  inline const Aws::String& GetImpersonationRoleId() const { return m_impersonationRoleId; }
  inline bool ImpersonationRoleIdHasBeenSet() const { return m_impersonationRoleIdHasBeenSet; }
  template <typename ImpersonationRoleIdT = Aws::String>
  void SetImpersonationRoleId(ImpersonationRoleIdT&& value) {
    m_impersonationRoleIdHasBeenSet = true;
    m_impersonationRoleId = std::forward<ImpersonationRoleIdT>(value);
  }
  template <typename ImpersonationRoleIdT = Aws::String>
  ImpersonationRole& WithImpersonationRoleId(ImpersonationRoleIdT&& value) {
    SetImpersonationRoleId(std::forward<ImpersonationRoleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The impersonation role name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ImpersonationRole& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The impersonation role type.</p>
   */
  inline ImpersonationRoleType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(ImpersonationRoleType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline ImpersonationRole& WithType(ImpersonationRoleType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date when the impersonation role was created.</p>
   */
  inline const Aws::Utils::DateTime& GetDateCreated() const { return m_dateCreated; }
  inline bool DateCreatedHasBeenSet() const { return m_dateCreatedHasBeenSet; }
  template <typename DateCreatedT = Aws::Utils::DateTime>
  void SetDateCreated(DateCreatedT&& value) {
    m_dateCreatedHasBeenSet = true;
    m_dateCreated = std::forward<DateCreatedT>(value);
  }
  template <typename DateCreatedT = Aws::Utils::DateTime>
  ImpersonationRole& WithDateCreated(DateCreatedT&& value) {
    SetDateCreated(std::forward<DateCreatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date when the impersonation role was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetDateModified() const { return m_dateModified; }
  inline bool DateModifiedHasBeenSet() const { return m_dateModifiedHasBeenSet; }
  template <typename DateModifiedT = Aws::Utils::DateTime>
  void SetDateModified(DateModifiedT&& value) {
    m_dateModifiedHasBeenSet = true;
    m_dateModified = std::forward<DateModifiedT>(value);
  }
  template <typename DateModifiedT = Aws::Utils::DateTime>
  ImpersonationRole& WithDateModified(DateModifiedT&& value) {
    SetDateModified(std::forward<DateModifiedT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_impersonationRoleId;
  bool m_impersonationRoleIdHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  ImpersonationRoleType m_type{ImpersonationRoleType::NOT_SET};
  bool m_typeHasBeenSet = false;

  Aws::Utils::DateTime m_dateCreated{};
  bool m_dateCreatedHasBeenSet = false;

  Aws::Utils::DateTime m_dateModified{};
  bool m_dateModifiedHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkMail
}  // namespace Aws
