# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._log_analytics_management_client_enums import *


class AssociatedWorkspace(msrest.serialization.Model):
    """The list of Log Analytics workspaces associated with the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar workspace_id: The id of the assigned workspace.
    :vartype workspace_id: str
    :ivar workspace_name: The name id the assigned workspace.
    :vartype workspace_name: str
    :ivar resource_id: The ResourceId id the assigned workspace.
    :vartype resource_id: str
    :ivar associate_date: The time of workspace association.
    :vartype associate_date: str
    """

    _validation = {
        'workspace_id': {'readonly': True},
        'workspace_name': {'readonly': True},
        'resource_id': {'readonly': True},
        'associate_date': {'readonly': True},
    }

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'workspace_name': {'key': 'workspaceName', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'associate_date': {'key': 'associateDate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AssociatedWorkspace, self).__init__(**kwargs)
        self.workspace_id = None
        self.workspace_name = None
        self.resource_id = None
        self.associate_date = None


class AvailableServiceTier(msrest.serialization.Model):
    """Service Tier details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_tier: The name of the Service Tier. Possible values include: "Free", "Standard",
     "Premium", "PerNode", "PerGB2018", "Standalone", "CapacityReservation".
    :vartype service_tier: str or ~azure.mgmt.loganalytics.models.SkuNameEnum
    :ivar enabled: True if the Service Tier is enabled for the workspace.
    :vartype enabled: bool
    :ivar minimum_retention: The minimum retention for the Service Tier, in days.
    :vartype minimum_retention: long
    :ivar maximum_retention: The maximum retention for the Service Tier, in days.
    :vartype maximum_retention: long
    :ivar default_retention: The default retention for the Service Tier, in days.
    :vartype default_retention: long
    :ivar capacity_reservation_level: The capacity reservation level in GB per day. Returned for
     the Capacity Reservation Service Tier.
    :vartype capacity_reservation_level: long
    :ivar last_sku_update: Time when the sku was last updated for the workspace. Returned for the
     Capacity Reservation Service Tier.
    :vartype last_sku_update: str
    """

    _validation = {
        'service_tier': {'readonly': True},
        'enabled': {'readonly': True},
        'minimum_retention': {'readonly': True},
        'maximum_retention': {'readonly': True},
        'default_retention': {'readonly': True},
        'capacity_reservation_level': {'readonly': True},
        'last_sku_update': {'readonly': True},
    }

    _attribute_map = {
        'service_tier': {'key': 'serviceTier', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'minimum_retention': {'key': 'minimumRetention', 'type': 'long'},
        'maximum_retention': {'key': 'maximumRetention', 'type': 'long'},
        'default_retention': {'key': 'defaultRetention', 'type': 'long'},
        'capacity_reservation_level': {'key': 'capacityReservationLevel', 'type': 'long'},
        'last_sku_update': {'key': 'lastSkuUpdate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AvailableServiceTier, self).__init__(**kwargs)
        self.service_tier = None
        self.enabled = None
        self.minimum_retention = None
        self.maximum_retention = None
        self.default_retention = None
        self.capacity_reservation_level = None
        self.last_sku_update = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for an Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class AzureResourceProperties(msrest.serialization.Model):
    """An Azure resource QueryPack-Query object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.loganalytics.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AzureResourceProperties, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class CapacityReservationProperties(msrest.serialization.Model):
    """The Capacity Reservation properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_sku_update: The last time Sku was updated.
    :vartype last_sku_update: str
    :ivar min_capacity: Minimum CapacityReservation value in GB.
    :vartype min_capacity: long
    """

    _validation = {
        'last_sku_update': {'readonly': True},
        'min_capacity': {'readonly': True},
    }

    _attribute_map = {
        'last_sku_update': {'key': 'lastSkuUpdate', 'type': 'str'},
        'min_capacity': {'key': 'minCapacity', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CapacityReservationProperties, self).__init__(**kwargs)
        self.last_sku_update = None
        self.min_capacity = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Cluster(TrackedResource):
    """The top level Log Analytics cluster resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.loganalytics.models.Identity
    :ivar sku: The sku properties.
    :vartype sku: ~azure.mgmt.loganalytics.models.ClusterSku
    :ivar cluster_id: The ID associated with the cluster.
    :vartype cluster_id: str
    :ivar provisioning_state: The provisioning state of the cluster. Possible values include:
     "Creating", "Succeeded", "Failed", "Canceled", "Deleting", "ProvisioningAccount", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.loganalytics.models.ClusterEntityStatus
    :ivar is_double_encryption_enabled: Configures whether cluster will use double encryption. This
     Property can not be modified after cluster creation. Default value is 'true'.
    :vartype is_double_encryption_enabled: bool
    :ivar is_availability_zones_enabled: Sets whether the cluster will support availability zones.
     This can be set as true only in regions where Azure Data Explorer support Availability Zones.
     This Property can not be modified after cluster creation. Default value is 'true' if region
     supports Availability Zones.
    :vartype is_availability_zones_enabled: bool
    :ivar billing_type: The cluster's billing type. Possible values include: "Cluster",
     "Workspaces".
    :vartype billing_type: str or ~azure.mgmt.loganalytics.models.BillingType
    :ivar key_vault_properties: The associated key properties.
    :vartype key_vault_properties: ~azure.mgmt.loganalytics.models.KeyVaultProperties
    :ivar last_modified_date: The last time the cluster was updated.
    :vartype last_modified_date: str
    :ivar created_date: The cluster creation time.
    :vartype created_date: str
    :ivar associated_workspaces: The list of Log Analytics workspaces associated with the cluster.
    :vartype associated_workspaces: list[~azure.mgmt.loganalytics.models.AssociatedWorkspace]
    :ivar capacity_reservation_properties: Additional properties for capacity reservation.
    :vartype capacity_reservation_properties:
     ~azure.mgmt.loganalytics.models.CapacityReservationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'cluster_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'last_modified_date': {'readonly': True},
        'created_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'ClusterSku'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_double_encryption_enabled': {'key': 'properties.isDoubleEncryptionEnabled', 'type': 'bool'},
        'is_availability_zones_enabled': {'key': 'properties.isAvailabilityZonesEnabled', 'type': 'bool'},
        'billing_type': {'key': 'properties.billingType', 'type': 'str'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'KeyVaultProperties'},
        'last_modified_date': {'key': 'properties.lastModifiedDate', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'associated_workspaces': {'key': 'properties.associatedWorkspaces', 'type': '[AssociatedWorkspace]'},
        'capacity_reservation_properties': {'key': 'properties.capacityReservationProperties', 'type': 'CapacityReservationProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        sku: Optional["ClusterSku"] = None,
        is_double_encryption_enabled: Optional[bool] = None,
        is_availability_zones_enabled: Optional[bool] = None,
        billing_type: Optional[Union[str, "BillingType"]] = None,
        key_vault_properties: Optional["KeyVaultProperties"] = None,
        associated_workspaces: Optional[List["AssociatedWorkspace"]] = None,
        capacity_reservation_properties: Optional["CapacityReservationProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.loganalytics.models.Identity
        :keyword sku: The sku properties.
        :paramtype sku: ~azure.mgmt.loganalytics.models.ClusterSku
        :keyword is_double_encryption_enabled: Configures whether cluster will use double encryption.
         This Property can not be modified after cluster creation. Default value is 'true'.
        :paramtype is_double_encryption_enabled: bool
        :keyword is_availability_zones_enabled: Sets whether the cluster will support availability
         zones. This can be set as true only in regions where Azure Data Explorer support Availability
         Zones. This Property can not be modified after cluster creation. Default value is 'true' if
         region supports Availability Zones.
        :paramtype is_availability_zones_enabled: bool
        :keyword billing_type: The cluster's billing type. Possible values include: "Cluster",
         "Workspaces".
        :paramtype billing_type: str or ~azure.mgmt.loganalytics.models.BillingType
        :keyword key_vault_properties: The associated key properties.
        :paramtype key_vault_properties: ~azure.mgmt.loganalytics.models.KeyVaultProperties
        :keyword associated_workspaces: The list of Log Analytics workspaces associated with the
         cluster.
        :paramtype associated_workspaces: list[~azure.mgmt.loganalytics.models.AssociatedWorkspace]
        :keyword capacity_reservation_properties: Additional properties for capacity reservation.
        :paramtype capacity_reservation_properties:
         ~azure.mgmt.loganalytics.models.CapacityReservationProperties
        """
        super(Cluster, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.cluster_id = None
        self.provisioning_state = None
        self.is_double_encryption_enabled = is_double_encryption_enabled
        self.is_availability_zones_enabled = is_availability_zones_enabled
        self.billing_type = billing_type
        self.key_vault_properties = key_vault_properties
        self.last_modified_date = None
        self.created_date = None
        self.associated_workspaces = associated_workspaces
        self.capacity_reservation_properties = capacity_reservation_properties


class ClusterListResult(msrest.serialization.Model):
    """The list clusters operation response.

    :ivar next_link: The link used to get the next page of recommendations.
    :vartype next_link: str
    :ivar value: A list of Log Analytics clusters.
    :vartype value: list[~azure.mgmt.loganalytics.models.Cluster]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Cluster]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["Cluster"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of recommendations.
        :paramtype next_link: str
        :keyword value: A list of Log Analytics clusters.
        :paramtype value: list[~azure.mgmt.loganalytics.models.Cluster]
        """
        super(ClusterListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ClusterPatch(msrest.serialization.Model):
    """The top level Log Analytics cluster resource container.

    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.loganalytics.models.Identity
    :ivar sku: The sku properties.
    :vartype sku: ~azure.mgmt.loganalytics.models.ClusterSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar key_vault_properties: The associated key properties.
    :vartype key_vault_properties: ~azure.mgmt.loganalytics.models.KeyVaultProperties
    :ivar billing_type: The cluster's billing type. Possible values include: "Cluster",
     "Workspaces".
    :vartype billing_type: str or ~azure.mgmt.loganalytics.models.BillingType
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'ClusterSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'KeyVaultProperties'},
        'billing_type': {'key': 'properties.billingType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["Identity"] = None,
        sku: Optional["ClusterSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        key_vault_properties: Optional["KeyVaultProperties"] = None,
        billing_type: Optional[Union[str, "BillingType"]] = None,
        **kwargs
    ):
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.loganalytics.models.Identity
        :keyword sku: The sku properties.
        :paramtype sku: ~azure.mgmt.loganalytics.models.ClusterSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword key_vault_properties: The associated key properties.
        :paramtype key_vault_properties: ~azure.mgmt.loganalytics.models.KeyVaultProperties
        :keyword billing_type: The cluster's billing type. Possible values include: "Cluster",
         "Workspaces".
        :paramtype billing_type: str or ~azure.mgmt.loganalytics.models.BillingType
        """
        super(ClusterPatch, self).__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.tags = tags
        self.key_vault_properties = key_vault_properties
        self.billing_type = billing_type


class ClusterSku(msrest.serialization.Model):
    """The cluster sku definition.

    :ivar capacity: The capacity value. Possible values include: 500, 1000, 2000, 5000.
    :vartype capacity: int or ~azure.mgmt.loganalytics.models.Capacity
    :ivar name: The name of the SKU. Possible values include: "CapacityReservation".
    :vartype name: str or ~azure.mgmt.loganalytics.models.ClusterSkuNameEnum
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        capacity: Optional[Union[int, "Capacity"]] = None,
        name: Optional[Union[str, "ClusterSkuNameEnum"]] = None,
        **kwargs
    ):
        """
        :keyword capacity: The capacity value. Possible values include: 500, 1000, 2000, 5000.
        :paramtype capacity: int or ~azure.mgmt.loganalytics.models.Capacity
        :keyword name: The name of the SKU. Possible values include: "CapacityReservation".
        :paramtype name: str or ~azure.mgmt.loganalytics.models.ClusterSkuNameEnum
        """
        super(ClusterSku, self).__init__(**kwargs)
        self.capacity = capacity
        self.name = name


class Column(msrest.serialization.Model):
    """Table column.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Column name.
    :vartype name: str
    :ivar type: Column data type. Possible values include: "string", "int", "long", "real",
     "boolean", "dateTime", "guid", "dynamic".
    :vartype type: str or ~azure.mgmt.loganalytics.models.ColumnTypeEnum
    :ivar data_type_hint: Column data type logical hint. Possible values include: "uri", "guid",
     "armPath", "ip".
    :vartype data_type_hint: str or ~azure.mgmt.loganalytics.models.ColumnDataTypeHintEnum
    :ivar display_name: Column display name.
    :vartype display_name: str
    :ivar description: Column description.
    :vartype description: str
    :ivar is_default_display: Is displayed by default.
    :vartype is_default_display: bool
    :ivar is_hidden: Is column hidden.
    :vartype is_hidden: bool
    """

    _validation = {
        'is_default_display': {'readonly': True},
        'is_hidden': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_type_hint': {'key': 'dataTypeHint', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_default_display': {'key': 'isDefaultDisplay', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "ColumnTypeEnum"]] = None,
        data_type_hint: Optional[Union[str, "ColumnDataTypeHintEnum"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Column name.
        :paramtype name: str
        :keyword type: Column data type. Possible values include: "string", "int", "long", "real",
         "boolean", "dateTime", "guid", "dynamic".
        :paramtype type: str or ~azure.mgmt.loganalytics.models.ColumnTypeEnum
        :keyword data_type_hint: Column data type logical hint. Possible values include: "uri", "guid",
         "armPath", "ip".
        :paramtype data_type_hint: str or ~azure.mgmt.loganalytics.models.ColumnDataTypeHintEnum
        :keyword display_name: Column display name.
        :paramtype display_name: str
        :keyword description: Column description.
        :paramtype description: str
        """
        super(Column, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.data_type_hint = data_type_hint
        self.display_name = display_name
        self.description = description
        self.is_default_display = None
        self.is_hidden = None


class CoreSummary(msrest.serialization.Model):
    """The core summary of a search.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The status of a core summary.
    :vartype status: str
    :ivar number_of_documents: Required. The number of documents of a core summary.
    :vartype number_of_documents: long
    """

    _validation = {
        'number_of_documents': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'number_of_documents': {'key': 'numberOfDocuments', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        number_of_documents: int,
        status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: The status of a core summary.
        :paramtype status: str
        :keyword number_of_documents: Required. The number of documents of a core summary.
        :paramtype number_of_documents: long
        """
        super(CoreSummary, self).__init__(**kwargs)
        self.status = status
        self.number_of_documents = number_of_documents


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class DataExport(ProxyResource):
    """The top level data export resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar data_export_id: The data export rule ID.
    :vartype data_export_id: str
    :ivar table_names: An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
    :vartype table_names: list[str]
    :ivar enable: Active when enabled.
    :vartype enable: bool
    :ivar created_date: The latest data export rule modification time.
    :vartype created_date: str
    :ivar last_modified_date: Date and time when the export was last modified.
    :vartype last_modified_date: str
    :ivar resource_id: The destination resource ID. This can be copied from the Properties entry of
     the destination resource in Azure.
    :vartype resource_id: str
    :ivar type_properties_destination_type: The type of the destination resource. Possible values
     include: "StorageAccount", "EventHub".
    :vartype type_properties_destination_type: str or ~azure.mgmt.loganalytics.models.Type
    :ivar event_hub_name: Optional. Allows to define an Event Hub name. Not applicable when
     destination is Storage Account.
    :vartype event_hub_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'type_properties_destination_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_export_id': {'key': 'properties.dataExportId', 'type': 'str'},
        'table_names': {'key': 'properties.tableNames', 'type': '[str]'},
        'enable': {'key': 'properties.enable', 'type': 'bool'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'last_modified_date': {'key': 'properties.lastModifiedDate', 'type': 'str'},
        'resource_id': {'key': 'properties.destination.resourceId', 'type': 'str'},
        'type_properties_destination_type': {'key': 'properties.destination.type', 'type': 'str'},
        'event_hub_name': {'key': 'properties.destination.metaData.eventHubName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_export_id: Optional[str] = None,
        table_names: Optional[List[str]] = None,
        enable: Optional[bool] = None,
        created_date: Optional[str] = None,
        last_modified_date: Optional[str] = None,
        resource_id: Optional[str] = None,
        event_hub_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_export_id: The data export rule ID.
        :paramtype data_export_id: str
        :keyword table_names: An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
        :paramtype table_names: list[str]
        :keyword enable: Active when enabled.
        :paramtype enable: bool
        :keyword created_date: The latest data export rule modification time.
        :paramtype created_date: str
        :keyword last_modified_date: Date and time when the export was last modified.
        :paramtype last_modified_date: str
        :keyword resource_id: The destination resource ID. This can be copied from the Properties entry
         of the destination resource in Azure.
        :paramtype resource_id: str
        :keyword event_hub_name: Optional. Allows to define an Event Hub name. Not applicable when
         destination is Storage Account.
        :paramtype event_hub_name: str
        """
        super(DataExport, self).__init__(**kwargs)
        self.data_export_id = data_export_id
        self.table_names = table_names
        self.enable = enable
        self.created_date = created_date
        self.last_modified_date = last_modified_date
        self.resource_id = resource_id
        self.type_properties_destination_type = None
        self.event_hub_name = event_hub_name


class DataExportListResult(msrest.serialization.Model):
    """Result of the request to list data exports.

    :ivar value: List of data export instances within a workspace..
    :vartype value: list[~azure.mgmt.loganalytics.models.DataExport]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataExport]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataExport"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of data export instances within a workspace..
        :paramtype value: list[~azure.mgmt.loganalytics.models.DataExport]
        """
        super(DataExportListResult, self).__init__(**kwargs)
        self.value = value


class DataSource(ProxyResource):
    """Datasources under OMS Workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: Required. The data source properties in raw json format, each kind of data
     source have it's own schema.
    :vartype properties: any
    :ivar etag: The ETag of the data source.
    :vartype etag: str
    :ivar kind: Required. The kind of the DataSource. Possible values include: "WindowsEvent",
     "WindowsPerformanceCounter", "IISLogs", "LinuxSyslog", "LinuxSyslogCollection",
     "LinuxPerformanceObject", "LinuxPerformanceCollection", "CustomLog", "CustomLogCollection",
     "AzureAuditLog", "AzureActivityLog", "GenericDataSource", "ChangeTrackingCustomPath",
     "ChangeTrackingPath", "ChangeTrackingServices", "ChangeTrackingDataTypeConfiguration",
     "ChangeTrackingDefaultRegistry", "ChangeTrackingRegistry", "ChangeTrackingLinuxPath",
     "LinuxChangeTrackingPath", "ChangeTrackingContentLocation", "WindowsTelemetry", "Office365",
     "SecurityWindowsBaselineConfiguration", "SecurityCenterSecurityWindowsBaselineConfiguration",
     "SecurityEventCollectionConfiguration", "SecurityInsightsSecurityEventCollectionConfiguration",
     "ImportComputerGroup", "NetworkMonitoring", "Itsm", "DnsAnalytics", "ApplicationInsights",
     "SqlDataClassification".
    :vartype kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        properties: Any,
        kind: Union[str, "DataSourceKind"],
        etag: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword properties: Required. The data source properties in raw json format, each kind of data
         source have it's own schema.
        :paramtype properties: any
        :keyword etag: The ETag of the data source.
        :paramtype etag: str
        :keyword kind: Required. The kind of the DataSource. Possible values include: "WindowsEvent",
         "WindowsPerformanceCounter", "IISLogs", "LinuxSyslog", "LinuxSyslogCollection",
         "LinuxPerformanceObject", "LinuxPerformanceCollection", "CustomLog", "CustomLogCollection",
         "AzureAuditLog", "AzureActivityLog", "GenericDataSource", "ChangeTrackingCustomPath",
         "ChangeTrackingPath", "ChangeTrackingServices", "ChangeTrackingDataTypeConfiguration",
         "ChangeTrackingDefaultRegistry", "ChangeTrackingRegistry", "ChangeTrackingLinuxPath",
         "LinuxChangeTrackingPath", "ChangeTrackingContentLocation", "WindowsTelemetry", "Office365",
         "SecurityWindowsBaselineConfiguration", "SecurityCenterSecurityWindowsBaselineConfiguration",
         "SecurityEventCollectionConfiguration", "SecurityInsightsSecurityEventCollectionConfiguration",
         "ImportComputerGroup", "NetworkMonitoring", "Itsm", "DnsAnalytics", "ApplicationInsights",
         "SqlDataClassification".
        :paramtype kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(DataSource, self).__init__(**kwargs)
        self.properties = properties
        self.etag = etag
        self.kind = kind
        self.tags = tags


class DataSourceFilter(msrest.serialization.Model):
    """DataSource filter. Right now, only filter by kind is supported.

    :ivar kind: The kind of the DataSource. Possible values include: "WindowsEvent",
     "WindowsPerformanceCounter", "IISLogs", "LinuxSyslog", "LinuxSyslogCollection",
     "LinuxPerformanceObject", "LinuxPerformanceCollection", "CustomLog", "CustomLogCollection",
     "AzureAuditLog", "AzureActivityLog", "GenericDataSource", "ChangeTrackingCustomPath",
     "ChangeTrackingPath", "ChangeTrackingServices", "ChangeTrackingDataTypeConfiguration",
     "ChangeTrackingDefaultRegistry", "ChangeTrackingRegistry", "ChangeTrackingLinuxPath",
     "LinuxChangeTrackingPath", "ChangeTrackingContentLocation", "WindowsTelemetry", "Office365",
     "SecurityWindowsBaselineConfiguration", "SecurityCenterSecurityWindowsBaselineConfiguration",
     "SecurityEventCollectionConfiguration", "SecurityInsightsSecurityEventCollectionConfiguration",
     "ImportComputerGroup", "NetworkMonitoring", "Itsm", "DnsAnalytics", "ApplicationInsights",
     "SqlDataClassification".
    :vartype kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "DataSourceKind"]] = None,
        **kwargs
    ):
        """
        :keyword kind: The kind of the DataSource. Possible values include: "WindowsEvent",
         "WindowsPerformanceCounter", "IISLogs", "LinuxSyslog", "LinuxSyslogCollection",
         "LinuxPerformanceObject", "LinuxPerformanceCollection", "CustomLog", "CustomLogCollection",
         "AzureAuditLog", "AzureActivityLog", "GenericDataSource", "ChangeTrackingCustomPath",
         "ChangeTrackingPath", "ChangeTrackingServices", "ChangeTrackingDataTypeConfiguration",
         "ChangeTrackingDefaultRegistry", "ChangeTrackingRegistry", "ChangeTrackingLinuxPath",
         "LinuxChangeTrackingPath", "ChangeTrackingContentLocation", "WindowsTelemetry", "Office365",
         "SecurityWindowsBaselineConfiguration", "SecurityCenterSecurityWindowsBaselineConfiguration",
         "SecurityEventCollectionConfiguration", "SecurityInsightsSecurityEventCollectionConfiguration",
         "ImportComputerGroup", "NetworkMonitoring", "Itsm", "DnsAnalytics", "ApplicationInsights",
         "SqlDataClassification".
        :paramtype kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
        """
        super(DataSourceFilter, self).__init__(**kwargs)
        self.kind = kind


class DataSourceListResult(msrest.serialization.Model):
    """The list data source by workspace operation response.

    :ivar value: A list of datasources.
    :vartype value: list[~azure.mgmt.loganalytics.models.DataSource]
    :ivar next_link: The link (url) to the next page of datasources.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataSource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataSource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of datasources.
        :paramtype value: list[~azure.mgmt.loganalytics.models.DataSource]
        :keyword next_link: The link (url) to the next page of datasources.
        :paramtype next_link: str
        """
        super(DataSourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.loganalytics.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.loganalytics.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.loganalytics.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.loganalytics.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: Required. Type of managed service identity. Possible values include: "user",
     "application", "managedIdentity", "key", "SystemAssigned", "UserAssigned", "None".
    :vartype type: str or ~azure.mgmt.loganalytics.models.IdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.loganalytics.models.UserIdentityProperties]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "IdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserIdentityProperties"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. Type of managed service identity. Possible values include: "user",
         "application", "managedIdentity", "key", "SystemAssigned", "UserAssigned", "None".
        :paramtype type: str or ~azure.mgmt.loganalytics.models.IdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.loganalytics.models.UserIdentityProperties]
        """
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class IntelligencePack(msrest.serialization.Model):
    """Intelligence Pack containing a string name and boolean indicating if it's enabled.

    :ivar name: The name of the intelligence pack.
    :vartype name: str
    :ivar enabled: The enabled boolean for the intelligence pack.
    :vartype enabled: bool
    :ivar display_name: The display name of the intelligence pack.
    :vartype display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        enabled: Optional[bool] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the intelligence pack.
        :paramtype name: str
        :keyword enabled: The enabled boolean for the intelligence pack.
        :paramtype enabled: bool
        :keyword display_name: The display name of the intelligence pack.
        :paramtype display_name: str
        """
        super(IntelligencePack, self).__init__(**kwargs)
        self.name = name
        self.enabled = enabled
        self.display_name = display_name


class KeyVaultProperties(msrest.serialization.Model):
    """The key vault properties.

    :ivar key_vault_uri: The Key Vault uri which holds they key associated with the Log Analytics
     cluster.
    :vartype key_vault_uri: str
    :ivar key_name: The name of the key associated with the Log Analytics cluster.
    :vartype key_name: str
    :ivar key_version: The version of the key associated with the Log Analytics cluster.
    :vartype key_version: str
    :ivar key_rsa_size: Selected key minimum required size.
    :vartype key_rsa_size: int
    """

    _attribute_map = {
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'key_rsa_size': {'key': 'keyRsaSize', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        key_vault_uri: Optional[str] = None,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_rsa_size: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword key_vault_uri: The Key Vault uri which holds they key associated with the Log
         Analytics cluster.
        :paramtype key_vault_uri: str
        :keyword key_name: The name of the key associated with the Log Analytics cluster.
        :paramtype key_name: str
        :keyword key_version: The version of the key associated with the Log Analytics cluster.
        :paramtype key_version: str
        :keyword key_rsa_size: Selected key minimum required size.
        :paramtype key_rsa_size: int
        """
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_vault_uri = key_vault_uri
        self.key_name = key_name
        self.key_version = key_version
        self.key_rsa_size = key_rsa_size


class LinkedService(ProxyResource):
    """The top level Linked service resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar resource_id: The resource id of the resource that will be linked to the workspace. This
     should be used for linking resources which require read access.
    :vartype resource_id: str
    :ivar write_access_resource_id: The resource id of the resource that will be linked to the
     workspace. This should be used for linking resources which require write access.
    :vartype write_access_resource_id: str
    :ivar provisioning_state: The provisioning state of the linked service. Possible values
     include: "Succeeded", "Deleting", "ProvisioningAccount", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.loganalytics.models.LinkedServiceEntityStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'write_access_resource_id': {'key': 'properties.writeAccessResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        resource_id: Optional[str] = None,
        write_access_resource_id: Optional[str] = None,
        provisioning_state: Optional[Union[str, "LinkedServiceEntityStatus"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword resource_id: The resource id of the resource that will be linked to the workspace.
         This should be used for linking resources which require read access.
        :paramtype resource_id: str
        :keyword write_access_resource_id: The resource id of the resource that will be linked to the
         workspace. This should be used for linking resources which require write access.
        :paramtype write_access_resource_id: str
        :keyword provisioning_state: The provisioning state of the linked service. Possible values
         include: "Succeeded", "Deleting", "ProvisioningAccount", "Updating".
        :paramtype provisioning_state: str or ~azure.mgmt.loganalytics.models.LinkedServiceEntityStatus
        """
        super(LinkedService, self).__init__(**kwargs)
        self.tags = tags
        self.resource_id = resource_id
        self.write_access_resource_id = write_access_resource_id
        self.provisioning_state = provisioning_state


class LinkedServiceListResult(msrest.serialization.Model):
    """The list linked service operation response.

    :ivar value: The list of linked service instances.
    :vartype value: list[~azure.mgmt.loganalytics.models.LinkedService]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LinkedService]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LinkedService"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of linked service instances.
        :paramtype value: list[~azure.mgmt.loganalytics.models.LinkedService]
        """
        super(LinkedServiceListResult, self).__init__(**kwargs)
        self.value = value


class LinkedStorageAccountsListResult(msrest.serialization.Model):
    """The list linked storage accounts service operation response.

    :ivar value: A list of linked storage accounts instances.
    :vartype value: list[~azure.mgmt.loganalytics.models.LinkedStorageAccountsResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LinkedStorageAccountsResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LinkedStorageAccountsResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of linked storage accounts instances.
        :paramtype value: list[~azure.mgmt.loganalytics.models.LinkedStorageAccountsResource]
        """
        super(LinkedStorageAccountsListResult, self).__init__(**kwargs)
        self.value = value


class LinkedStorageAccountsResource(ProxyResource):
    """Linked storage accounts top level resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar data_source_type: Linked storage accounts type. Possible values include: "CustomLogs",
     "AzureWatson", "Query", "Alerts".
    :vartype data_source_type: str or ~azure.mgmt.loganalytics.models.DataSourceType
    :ivar storage_account_ids: Linked storage accounts resources ids.
    :vartype storage_account_ids: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'data_source_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_source_type': {'key': 'properties.dataSourceType', 'type': 'str'},
        'storage_account_ids': {'key': 'properties.storageAccountIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        storage_account_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword storage_account_ids: Linked storage accounts resources ids.
        :paramtype storage_account_ids: list[str]
        """
        super(LinkedStorageAccountsResource, self).__init__(**kwargs)
        self.data_source_type = None
        self.storage_account_ids = storage_account_ids


class QueryPacksResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(QueryPacksResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class LogAnalyticsQueryPack(QueryPacksResource):
    """An Log Analytics QueryPack definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar query_pack_id: The unique ID of your application. This field cannot be changed.
    :vartype query_pack_id: str
    :ivar time_created: Creation Date for the Log Analytics QueryPack, in ISO 8601 format.
    :vartype time_created: ~datetime.datetime
    :ivar time_modified: Last modified date of the Log Analytics QueryPack, in ISO 8601 format.
    :vartype time_modified: ~datetime.datetime
    :ivar provisioning_state: Current state of this QueryPack: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'query_pack_id': {'readonly': True},
        'time_created': {'readonly': True},
        'time_modified': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'query_pack_id': {'key': 'properties.queryPackId', 'type': 'str'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'time_modified': {'key': 'properties.timeModified', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(LogAnalyticsQueryPack, self).__init__(location=location, tags=tags, **kwargs)
        self.query_pack_id = None
        self.time_created = None
        self.time_modified = None
        self.provisioning_state = None


class LogAnalyticsQueryPackListResult(msrest.serialization.Model):
    """Describes the list of Log Analytics QueryPack resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of Log Analytics QueryPack definitions.
    :vartype value: list[~azure.mgmt.loganalytics.models.LogAnalyticsQueryPack]
    :ivar next_link: The URI to get the next set of Log Analytics QueryPack definitions if too many
     QueryPacks where returned in the result set.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LogAnalyticsQueryPack]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["LogAnalyticsQueryPack"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. List of Log Analytics QueryPack definitions.
        :paramtype value: list[~azure.mgmt.loganalytics.models.LogAnalyticsQueryPack]
        :keyword next_link: The URI to get the next set of Log Analytics QueryPack definitions if too
         many QueryPacks where returned in the result set.
        :paramtype next_link: str
        """
        super(LogAnalyticsQueryPackListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogAnalyticsQueryPackQuery(AzureResourceProperties):
    """A Log Analytics QueryPack-Query definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.loganalytics.models.SystemData
    :ivar id_properties_id: The unique ID of your application. This field cannot be changed.
    :vartype id_properties_id: str
    :ivar display_name: Unique display name for your query within the Query Pack.
    :vartype display_name: str
    :ivar time_created: Creation Date for the Log Analytics Query, in ISO 8601 format.
    :vartype time_created: ~datetime.datetime
    :ivar time_modified: Last modified date of the Log Analytics Query, in ISO 8601 format.
    :vartype time_modified: ~datetime.datetime
    :ivar author: Object Id of user creating the query.
    :vartype author: str
    :ivar description: Description of the query.
    :vartype description: str
    :ivar body: Body of the query.
    :vartype body: str
    :ivar related: The related metadata items for the function.
    :vartype related: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQueryPropertiesRelated
    :ivar tags: A set of tags. Tags associated with the query.
    :vartype tags: dict[str, list[str]]
    :ivar properties: Additional properties that can be set for the query.
    :vartype properties: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'id_properties_id': {'readonly': True},
        'time_created': {'readonly': True},
        'time_modified': {'readonly': True},
        'author': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'time_modified': {'key': 'properties.timeModified', 'type': 'iso-8601'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'body': {'key': 'properties.body', 'type': 'str'},
        'related': {'key': 'properties.related', 'type': 'LogAnalyticsQueryPackQueryPropertiesRelated'},
        'tags': {'key': 'properties.tags', 'type': '{[str]}'},
        'properties': {'key': 'properties.properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        body: Optional[str] = None,
        related: Optional["LogAnalyticsQueryPackQueryPropertiesRelated"] = None,
        tags: Optional[Dict[str, List[str]]] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword display_name: Unique display name for your query within the Query Pack.
        :paramtype display_name: str
        :keyword description: Description of the query.
        :paramtype description: str
        :keyword body: Body of the query.
        :paramtype body: str
        :keyword related: The related metadata items for the function.
        :paramtype related: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQueryPropertiesRelated
        :keyword tags: A set of tags. Tags associated with the query.
        :paramtype tags: dict[str, list[str]]
        :keyword properties: Additional properties that can be set for the query.
        :paramtype properties: any
        """
        super(LogAnalyticsQueryPackQuery, self).__init__(**kwargs)
        self.id_properties_id = None
        self.display_name = display_name
        self.time_created = None
        self.time_modified = None
        self.author = None
        self.description = description
        self.body = body
        self.related = related
        self.tags = tags
        self.properties = properties


class LogAnalyticsQueryPackQueryListResult(msrest.serialization.Model):
    """Describes the list of Log Analytics QueryPack-Query resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of Log Analytics QueryPack Query definitions.
    :vartype value: list[~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery]
    :ivar next_link: The URI to get the next set of Log Analytics QueryPack definitions if too many
     QueryPack-Queries where returned in the result set.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LogAnalyticsQueryPackQuery]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["LogAnalyticsQueryPackQuery"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. List of Log Analytics QueryPack Query definitions.
        :paramtype value: list[~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery]
        :keyword next_link: The URI to get the next set of Log Analytics QueryPack definitions if too
         many QueryPack-Queries where returned in the result set.
        :paramtype next_link: str
        """
        super(LogAnalyticsQueryPackQueryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogAnalyticsQueryPackQueryPropertiesRelated(msrest.serialization.Model):
    """The related metadata items for the function.

    :ivar categories: The related categories for the function.
    :vartype categories: list[str]
    :ivar resource_types: The related resource types for the function.
    :vartype resource_types: list[str]
    :ivar solutions: The related Log Analytics solutions for the function.
    :vartype solutions: list[str]
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[str]'},
        'resource_types': {'key': 'resourceTypes', 'type': '[str]'},
        'solutions': {'key': 'solutions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        categories: Optional[List[str]] = None,
        resource_types: Optional[List[str]] = None,
        solutions: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword categories: The related categories for the function.
        :paramtype categories: list[str]
        :keyword resource_types: The related resource types for the function.
        :paramtype resource_types: list[str]
        :keyword solutions: The related Log Analytics solutions for the function.
        :paramtype solutions: list[str]
        """
        super(LogAnalyticsQueryPackQueryPropertiesRelated, self).__init__(**kwargs)
        self.categories = categories
        self.resource_types = resource_types
        self.solutions = solutions


class LogAnalyticsQueryPackQuerySearchProperties(msrest.serialization.Model):
    """Properties that define an Log Analytics QueryPack-Query search properties.

    :ivar related: The related metadata items for the function.
    :vartype related:
     ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuerySearchPropertiesRelated
    :ivar tags: A set of tags. Tags associated with the query.
    :vartype tags: dict[str, list[str]]
    """

    _attribute_map = {
        'related': {'key': 'related', 'type': 'LogAnalyticsQueryPackQuerySearchPropertiesRelated'},
        'tags': {'key': 'tags', 'type': '{[str]}'},
    }

    def __init__(
        self,
        *,
        related: Optional["LogAnalyticsQueryPackQuerySearchPropertiesRelated"] = None,
        tags: Optional[Dict[str, List[str]]] = None,
        **kwargs
    ):
        """
        :keyword related: The related metadata items for the function.
        :paramtype related:
         ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuerySearchPropertiesRelated
        :keyword tags: A set of tags. Tags associated with the query.
        :paramtype tags: dict[str, list[str]]
        """
        super(LogAnalyticsQueryPackQuerySearchProperties, self).__init__(**kwargs)
        self.related = related
        self.tags = tags


class LogAnalyticsQueryPackQuerySearchPropertiesRelated(msrest.serialization.Model):
    """The related metadata items for the function.

    :ivar categories: The related categories for the function.
    :vartype categories: list[str]
    :ivar resource_types: The related resource types for the function.
    :vartype resource_types: list[str]
    :ivar solutions: The related Log Analytics solutions for the function.
    :vartype solutions: list[str]
    """

    _attribute_map = {
        'categories': {'key': 'categories', 'type': '[str]'},
        'resource_types': {'key': 'resourceTypes', 'type': '[str]'},
        'solutions': {'key': 'solutions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        categories: Optional[List[str]] = None,
        resource_types: Optional[List[str]] = None,
        solutions: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword categories: The related categories for the function.
        :paramtype categories: list[str]
        :keyword resource_types: The related resource types for the function.
        :paramtype resource_types: list[str]
        :keyword solutions: The related Log Analytics solutions for the function.
        :paramtype solutions: list[str]
        """
        super(LogAnalyticsQueryPackQuerySearchPropertiesRelated, self).__init__(**kwargs)
        self.categories = categories
        self.resource_types = resource_types
        self.solutions = solutions


class ManagementGroup(msrest.serialization.Model):
    """A management group that is connected to a workspace.

    :ivar server_count: The number of servers connected to the management group.
    :vartype server_count: int
    :ivar is_gateway: Gets or sets a value indicating whether the management group is a gateway.
    :vartype is_gateway: bool
    :ivar name: The name of the management group.
    :vartype name: str
    :ivar id: The unique ID of the management group.
    :vartype id: str
    :ivar created: The datetime that the management group was created.
    :vartype created: ~datetime.datetime
    :ivar data_received: The last datetime that the management group received data.
    :vartype data_received: ~datetime.datetime
    :ivar version: The version of System Center that is managing the management group.
    :vartype version: str
    :ivar sku: The SKU of System Center that is managing the management group.
    :vartype sku: str
    """

    _attribute_map = {
        'server_count': {'key': 'properties.serverCount', 'type': 'int'},
        'is_gateway': {'key': 'properties.isGateway', 'type': 'bool'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'id': {'key': 'properties.id', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'data_received': {'key': 'properties.dataReceived', 'type': 'iso-8601'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_count: Optional[int] = None,
        is_gateway: Optional[bool] = None,
        name: Optional[str] = None,
        id: Optional[str] = None,
        created: Optional[datetime.datetime] = None,
        data_received: Optional[datetime.datetime] = None,
        version: Optional[str] = None,
        sku: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword server_count: The number of servers connected to the management group.
        :paramtype server_count: int
        :keyword is_gateway: Gets or sets a value indicating whether the management group is a gateway.
        :paramtype is_gateway: bool
        :keyword name: The name of the management group.
        :paramtype name: str
        :keyword id: The unique ID of the management group.
        :paramtype id: str
        :keyword created: The datetime that the management group was created.
        :paramtype created: ~datetime.datetime
        :keyword data_received: The last datetime that the management group received data.
        :paramtype data_received: ~datetime.datetime
        :keyword version: The version of System Center that is managing the management group.
        :paramtype version: str
        :keyword sku: The SKU of System Center that is managing the management group.
        :paramtype sku: str
        """
        super(ManagementGroup, self).__init__(**kwargs)
        self.server_count = server_count
        self.is_gateway = is_gateway
        self.name = name
        self.id = id
        self.created = created
        self.data_received = data_received
        self.version = version
        self.sku = sku


class MetricName(msrest.serialization.Model):
    """The name of a metric.

    :ivar value: The system name of the metric.
    :vartype value: str
    :ivar localized_value: The localized name of the metric.
    :vartype localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The system name of the metric.
        :paramtype value: str
        :keyword localized_value: The localized name of the metric.
        :paramtype localized_value: str
        """
        super(MetricName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class Operation(msrest.serialization.Model):
    """Supported operation of OperationalInsights resource provider.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.loganalytics.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.loganalytics.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft OperationsManagement.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft OperationsManagement.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of operation.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list solution operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of solution operations supported by the OperationsManagement resource
     provider.
    :vartype value: list[~azure.mgmt.loganalytics.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of solution operations supported by the OperationsManagement resource
         provider.
        :paramtype value: list[~azure.mgmt.loganalytics.models.Operation]
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class OperationStatus(msrest.serialization.Model):
    """The status of operation.

    :ivar id: The operation Id.
    :vartype id: str
    :ivar name: The operation name.
    :vartype name: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: str
    :ivar end_time: The end time of the operation.
    :vartype end_time: str
    :ivar status: The status of the operation.
    :vartype status: str
    :ivar error: The error detail of the operation if any.
    :vartype error: ~azure.mgmt.loganalytics.models.ErrorResponse
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        status: Optional[str] = None,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        """
        :keyword id: The operation Id.
        :paramtype id: str
        :keyword name: The operation name.
        :paramtype name: str
        :keyword start_time: The start time of the operation.
        :paramtype start_time: str
        :keyword end_time: The end time of the operation.
        :paramtype end_time: str
        :keyword status: The status of the operation.
        :paramtype status: str
        :keyword error: The error detail of the operation if any.
        :paramtype error: ~azure.mgmt.loganalytics.models.ErrorResponse
        """
        super(OperationStatus, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.error = error


class PrivateLinkScopedResource(msrest.serialization.Model):
    """The private link scope resource reference.

    :ivar resource_id: The full resource Id of the private link scope resource.
    :vartype resource_id: str
    :ivar scope_id: The private link scope unique Identifier.
    :vartype scope_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'scope_id': {'key': 'scopeId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        scope_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id: The full resource Id of the private link scope resource.
        :paramtype resource_id: str
        :keyword scope_id: The private link scope unique Identifier.
        :paramtype scope_id: str
        """
        super(PrivateLinkScopedResource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.scope_id = scope_id


class RestoredLogs(msrest.serialization.Model):
    """Restore parameters.

    :ivar start_restore_time: The timestamp to start the restore from (UTC).
    :vartype start_restore_time: ~datetime.datetime
    :ivar end_restore_time: The timestamp to end the restore by (UTC).
    :vartype end_restore_time: ~datetime.datetime
    :ivar source_table: The table to restore data from.
    :vartype source_table: str
    """

    _attribute_map = {
        'start_restore_time': {'key': 'startRestoreTime', 'type': 'iso-8601'},
        'end_restore_time': {'key': 'endRestoreTime', 'type': 'iso-8601'},
        'source_table': {'key': 'sourceTable', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_restore_time: Optional[datetime.datetime] = None,
        end_restore_time: Optional[datetime.datetime] = None,
        source_table: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword start_restore_time: The timestamp to start the restore from (UTC).
        :paramtype start_restore_time: ~datetime.datetime
        :keyword end_restore_time: The timestamp to end the restore by (UTC).
        :paramtype end_restore_time: ~datetime.datetime
        :keyword source_table: The table to restore data from.
        :paramtype source_table: str
        """
        super(RestoredLogs, self).__init__(**kwargs)
        self.start_restore_time = start_restore_time
        self.end_restore_time = end_restore_time
        self.source_table = source_table


class ResultStatistics(msrest.serialization.Model):
    """Search job execution statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar progress: Search job completion percentage.
    :vartype progress: float
    :ivar ingested_records: The number of rows that were returned by the search job.
    :vartype ingested_records: int
    """

    _validation = {
        'progress': {'readonly': True, 'multiple': 0.01},
        'ingested_records': {'readonly': True},
    }

    _attribute_map = {
        'progress': {'key': 'progress', 'type': 'float'},
        'ingested_records': {'key': 'ingestedRecords', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResultStatistics, self).__init__(**kwargs)
        self.progress = None
        self.ingested_records = None


class SavedSearch(ProxyResource):
    """Value object for saved search results.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: The ETag of the saved search. To override an existing saved search, use "*" or
     specify the current Etag.
    :vartype etag: str
    :ivar category: Required. The category of the saved search. This helps the user to find a saved
     search faster.
    :vartype category: str
    :ivar display_name: Required. Saved search display name.
    :vartype display_name: str
    :ivar query: Required. The query expression for the saved search.
    :vartype query: str
    :ivar function_alias: The function alias if query serves as a function.
    :vartype function_alias: str
    :ivar function_parameters: The optional function parameters if query serves as a function.
     Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2
     = default_value2'. For more examples and proper syntax please refer to
     https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
    :vartype function_parameters: str
    :ivar version: The version number of the query language. The current version is 2 and is the
     default.
    :vartype version: long
    :ivar tags: A set of tags. The tags attached to the saved search.
    :vartype tags: list[~azure.mgmt.loganalytics.models.Tag]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category': {'required': True},
        'display_name': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'function_alias': {'key': 'properties.functionAlias', 'type': 'str'},
        'function_parameters': {'key': 'properties.functionParameters', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'long'},
        'tags': {'key': 'properties.tags', 'type': '[Tag]'},
    }

    def __init__(
        self,
        *,
        category: str,
        display_name: str,
        query: str,
        etag: Optional[str] = None,
        function_alias: Optional[str] = None,
        function_parameters: Optional[str] = None,
        version: Optional[int] = None,
        tags: Optional[List["Tag"]] = None,
        **kwargs
    ):
        """
        :keyword etag: The ETag of the saved search. To override an existing saved search, use "*" or
         specify the current Etag.
        :paramtype etag: str
        :keyword category: Required. The category of the saved search. This helps the user to find a
         saved search faster.
        :paramtype category: str
        :keyword display_name: Required. Saved search display name.
        :paramtype display_name: str
        :keyword query: Required. The query expression for the saved search.
        :paramtype query: str
        :keyword function_alias: The function alias if query serves as a function.
        :paramtype function_alias: str
        :keyword function_parameters: The optional function parameters if query serves as a function.
         Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2
         = default_value2'. For more examples and proper syntax please refer to
         https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
        :paramtype function_parameters: str
        :keyword version: The version number of the query language. The current version is 2 and is the
         default.
        :paramtype version: long
        :keyword tags: A set of tags. The tags attached to the saved search.
        :paramtype tags: list[~azure.mgmt.loganalytics.models.Tag]
        """
        super(SavedSearch, self).__init__(**kwargs)
        self.etag = etag
        self.category = category
        self.display_name = display_name
        self.query = query
        self.function_alias = function_alias
        self.function_parameters = function_parameters
        self.version = version
        self.tags = tags


class SavedSearchesListResult(msrest.serialization.Model):
    """The saved search list operation response.

    :ivar value: The array of result values.
    :vartype value: list[~azure.mgmt.loganalytics.models.SavedSearch]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SavedSearch]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SavedSearch"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of result values.
        :paramtype value: list[~azure.mgmt.loganalytics.models.SavedSearch]
        """
        super(SavedSearchesListResult, self).__init__(**kwargs)
        self.value = value


class Schema(msrest.serialization.Model):
    """Table's schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Table name.
    :vartype name: str
    :ivar display_name: Table display name.
    :vartype display_name: str
    :ivar description: Table description.
    :vartype description: str
    :ivar columns: A list of table custom columns.
    :vartype columns: list[~azure.mgmt.loganalytics.models.Column]
    :ivar standard_columns: A list of table standard columns.
    :vartype standard_columns: list[~azure.mgmt.loganalytics.models.Column]
    :ivar categories: Table category.
    :vartype categories: list[str]
    :ivar labels: Table labels.
    :vartype labels: list[str]
    :ivar source: Table's creator. Possible values include: "microsoft", "customer".
    :vartype source: str or ~azure.mgmt.loganalytics.models.SourceEnum
    :ivar table_type: Table's creator. Possible values include: "Microsoft", "CustomLog",
     "RestoredLogs", "SearchResults".
    :vartype table_type: str or ~azure.mgmt.loganalytics.models.TableTypeEnum
    :ivar table_sub_type: The subtype describes what APIs can be used to interact with the table,
     and what features are available against it. Possible values include: "Any", "Classic",
     "DataCollectionRuleBased".
    :vartype table_sub_type: str or ~azure.mgmt.loganalytics.models.TableSubTypeEnum
    :ivar solutions: List of solutions the table is affiliated with.
    :vartype solutions: list[str]
    :ivar search_results: Parameters of the search job that initiated this table.
    :vartype search_results: ~azure.mgmt.loganalytics.models.SearchResults
    :ivar restored_logs: Parameters of the restore operation that initiated this table.
    :vartype restored_logs: ~azure.mgmt.loganalytics.models.RestoredLogs
    """

    _validation = {
        'standard_columns': {'readonly': True},
        'categories': {'readonly': True},
        'labels': {'readonly': True},
        'source': {'readonly': True},
        'table_type': {'readonly': True},
        'table_sub_type': {'readonly': True},
        'solutions': {'readonly': True},
        'search_results': {'readonly': True},
        'restored_logs': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'columns': {'key': 'columns', 'type': '[Column]'},
        'standard_columns': {'key': 'standardColumns', 'type': '[Column]'},
        'categories': {'key': 'categories', 'type': '[str]'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'source': {'key': 'source', 'type': 'str'},
        'table_type': {'key': 'tableType', 'type': 'str'},
        'table_sub_type': {'key': 'tableSubType', 'type': 'str'},
        'solutions': {'key': 'solutions', 'type': '[str]'},
        'search_results': {'key': 'searchResults', 'type': 'SearchResults'},
        'restored_logs': {'key': 'restoredLogs', 'type': 'RestoredLogs'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        columns: Optional[List["Column"]] = None,
        **kwargs
    ):
        """
        :keyword name: Table name.
        :paramtype name: str
        :keyword display_name: Table display name.
        :paramtype display_name: str
        :keyword description: Table description.
        :paramtype description: str
        :keyword columns: A list of table custom columns.
        :paramtype columns: list[~azure.mgmt.loganalytics.models.Column]
        """
        super(Schema, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.description = description
        self.columns = columns
        self.standard_columns = None
        self.categories = None
        self.labels = None
        self.source = None
        self.table_type = None
        self.table_sub_type = None
        self.solutions = None
        self.search_results = None
        self.restored_logs = None


class SearchGetSchemaResponse(msrest.serialization.Model):
    """The get schema operation response.

    :ivar metadata: The metadata from search results.
    :vartype metadata: ~azure.mgmt.loganalytics.models.SearchMetadata
    :ivar value: The array of result values.
    :vartype value: list[~azure.mgmt.loganalytics.models.SearchSchemaValue]
    """

    _attribute_map = {
        'metadata': {'key': 'metadata', 'type': 'SearchMetadata'},
        'value': {'key': 'value', 'type': '[SearchSchemaValue]'},
    }

    def __init__(
        self,
        *,
        metadata: Optional["SearchMetadata"] = None,
        value: Optional[List["SearchSchemaValue"]] = None,
        **kwargs
    ):
        """
        :keyword metadata: The metadata from search results.
        :paramtype metadata: ~azure.mgmt.loganalytics.models.SearchMetadata
        :keyword value: The array of result values.
        :paramtype value: list[~azure.mgmt.loganalytics.models.SearchSchemaValue]
        """
        super(SearchGetSchemaResponse, self).__init__(**kwargs)
        self.metadata = metadata
        self.value = value


class SearchMetadata(msrest.serialization.Model):
    """Metadata for search results.

    :ivar search_id: The request id of the search.
    :vartype search_id: str
    :ivar result_type: The search result type.
    :vartype result_type: str
    :ivar total: The total number of search results.
    :vartype total: long
    :ivar top: The number of top search results.
    :vartype top: long
    :ivar id: The id of the search results request.
    :vartype id: str
    :ivar core_summaries: The core summaries.
    :vartype core_summaries: list[~azure.mgmt.loganalytics.models.CoreSummary]
    :ivar status: The status of the search results.
    :vartype status: str
    :ivar start_time: The start time for the search.
    :vartype start_time: ~datetime.datetime
    :ivar last_updated: The time of last update.
    :vartype last_updated: ~datetime.datetime
    :ivar e_tag: The ETag of the search results.
    :vartype e_tag: str
    :ivar sort: How the results are sorted.
    :vartype sort: list[~azure.mgmt.loganalytics.models.SearchSort]
    :ivar request_time: The request time.
    :vartype request_time: long
    :ivar aggregated_value_field: The aggregated value field.
    :vartype aggregated_value_field: str
    :ivar aggregated_grouping_fields: The aggregated grouping fields.
    :vartype aggregated_grouping_fields: str
    :ivar sum: The sum of all aggregates returned in the result set.
    :vartype sum: long
    :ivar max: The max of all aggregates returned in the result set.
    :vartype max: long
    :ivar schema: The schema.
    :vartype schema: ~azure.mgmt.loganalytics.models.SearchMetadataSchema
    """

    _attribute_map = {
        'search_id': {'key': 'requestId', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'total': {'key': 'total', 'type': 'long'},
        'top': {'key': 'top', 'type': 'long'},
        'id': {'key': 'id', 'type': 'str'},
        'core_summaries': {'key': 'coreSummaries', 'type': '[CoreSummary]'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'sort': {'key': 'sort', 'type': '[SearchSort]'},
        'request_time': {'key': 'requestTime', 'type': 'long'},
        'aggregated_value_field': {'key': 'aggregatedValueField', 'type': 'str'},
        'aggregated_grouping_fields': {'key': 'aggregatedGroupingFields', 'type': 'str'},
        'sum': {'key': 'sum', 'type': 'long'},
        'max': {'key': 'max', 'type': 'long'},
        'schema': {'key': 'schema', 'type': 'SearchMetadataSchema'},
    }

    def __init__(
        self,
        *,
        search_id: Optional[str] = None,
        result_type: Optional[str] = None,
        total: Optional[int] = None,
        top: Optional[int] = None,
        id: Optional[str] = None,
        core_summaries: Optional[List["CoreSummary"]] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        last_updated: Optional[datetime.datetime] = None,
        e_tag: Optional[str] = None,
        sort: Optional[List["SearchSort"]] = None,
        request_time: Optional[int] = None,
        aggregated_value_field: Optional[str] = None,
        aggregated_grouping_fields: Optional[str] = None,
        sum: Optional[int] = None,
        max: Optional[int] = None,
        schema: Optional["SearchMetadataSchema"] = None,
        **kwargs
    ):
        """
        :keyword search_id: The request id of the search.
        :paramtype search_id: str
        :keyword result_type: The search result type.
        :paramtype result_type: str
        :keyword total: The total number of search results.
        :paramtype total: long
        :keyword top: The number of top search results.
        :paramtype top: long
        :keyword id: The id of the search results request.
        :paramtype id: str
        :keyword core_summaries: The core summaries.
        :paramtype core_summaries: list[~azure.mgmt.loganalytics.models.CoreSummary]
        :keyword status: The status of the search results.
        :paramtype status: str
        :keyword start_time: The start time for the search.
        :paramtype start_time: ~datetime.datetime
        :keyword last_updated: The time of last update.
        :paramtype last_updated: ~datetime.datetime
        :keyword e_tag: The ETag of the search results.
        :paramtype e_tag: str
        :keyword sort: How the results are sorted.
        :paramtype sort: list[~azure.mgmt.loganalytics.models.SearchSort]
        :keyword request_time: The request time.
        :paramtype request_time: long
        :keyword aggregated_value_field: The aggregated value field.
        :paramtype aggregated_value_field: str
        :keyword aggregated_grouping_fields: The aggregated grouping fields.
        :paramtype aggregated_grouping_fields: str
        :keyword sum: The sum of all aggregates returned in the result set.
        :paramtype sum: long
        :keyword max: The max of all aggregates returned in the result set.
        :paramtype max: long
        :keyword schema: The schema.
        :paramtype schema: ~azure.mgmt.loganalytics.models.SearchMetadataSchema
        """
        super(SearchMetadata, self).__init__(**kwargs)
        self.search_id = search_id
        self.result_type = result_type
        self.total = total
        self.top = top
        self.id = id
        self.core_summaries = core_summaries
        self.status = status
        self.start_time = start_time
        self.last_updated = last_updated
        self.e_tag = e_tag
        self.sort = sort
        self.request_time = request_time
        self.aggregated_value_field = aggregated_value_field
        self.aggregated_grouping_fields = aggregated_grouping_fields
        self.sum = sum
        self.max = max
        self.schema = schema


class SearchMetadataSchema(msrest.serialization.Model):
    """Schema metadata for search.

    :ivar name: The name of the metadata schema.
    :vartype name: str
    :ivar version: The version of the metadata schema.
    :vartype version: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        version: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the metadata schema.
        :paramtype name: str
        :keyword version: The version of the metadata schema.
        :paramtype version: int
        """
        super(SearchMetadataSchema, self).__init__(**kwargs)
        self.name = name
        self.version = version


class SearchResults(msrest.serialization.Model):
    """Parameters of the search job that initiated this table.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar query: Search job query.
    :vartype query: str
    :ivar description: Search job Description.
    :vartype description: str
    :ivar limit: Limit the search job to return up to specified number of rows.
    :vartype limit: int
    :ivar start_search_time: The timestamp to start the search from (UTC).
    :vartype start_search_time: ~datetime.datetime
    :ivar end_search_time: The timestamp to end the search by (UTC).
    :vartype end_search_time: ~datetime.datetime
    :ivar source_table: The table used in the search job.
    :vartype source_table: str
    """

    _validation = {
        'source_table': {'readonly': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'int'},
        'start_search_time': {'key': 'startSearchTime', 'type': 'iso-8601'},
        'end_search_time': {'key': 'endSearchTime', 'type': 'iso-8601'},
        'source_table': {'key': 'sourceTable', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        description: Optional[str] = None,
        limit: Optional[int] = None,
        start_search_time: Optional[datetime.datetime] = None,
        end_search_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword query: Search job query.
        :paramtype query: str
        :keyword description: Search job Description.
        :paramtype description: str
        :keyword limit: Limit the search job to return up to specified number of rows.
        :paramtype limit: int
        :keyword start_search_time: The timestamp to start the search from (UTC).
        :paramtype start_search_time: ~datetime.datetime
        :keyword end_search_time: The timestamp to end the search by (UTC).
        :paramtype end_search_time: ~datetime.datetime
        """
        super(SearchResults, self).__init__(**kwargs)
        self.query = query
        self.description = description
        self.limit = limit
        self.start_search_time = start_search_time
        self.end_search_time = end_search_time
        self.source_table = None


class SearchSchemaValue(msrest.serialization.Model):
    """Value object for schema results.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the schema.
    :vartype name: str
    :ivar display_name: The display name of the schema.
    :vartype display_name: str
    :ivar type: The type.
    :vartype type: str
    :ivar indexed: Required. The boolean that indicates the field is searchable as free text.
    :vartype indexed: bool
    :ivar stored: Required. The boolean that indicates whether or not the field is stored.
    :vartype stored: bool
    :ivar facet: Required. The boolean that indicates whether or not the field is a facet.
    :vartype facet: bool
    :ivar owner_type: The array of workflows containing the field.
    :vartype owner_type: list[str]
    """

    _validation = {
        'indexed': {'required': True},
        'stored': {'required': True},
        'facet': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'indexed': {'key': 'indexed', 'type': 'bool'},
        'stored': {'key': 'stored', 'type': 'bool'},
        'facet': {'key': 'facet', 'type': 'bool'},
        'owner_type': {'key': 'ownerType', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        indexed: bool,
        stored: bool,
        facet: bool,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        owner_type: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the schema.
        :paramtype name: str
        :keyword display_name: The display name of the schema.
        :paramtype display_name: str
        :keyword type: The type.
        :paramtype type: str
        :keyword indexed: Required. The boolean that indicates the field is searchable as free text.
        :paramtype indexed: bool
        :keyword stored: Required. The boolean that indicates whether or not the field is stored.
        :paramtype stored: bool
        :keyword facet: Required. The boolean that indicates whether or not the field is a facet.
        :paramtype facet: bool
        :keyword owner_type: The array of workflows containing the field.
        :paramtype owner_type: list[str]
        """
        super(SearchSchemaValue, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.type = type
        self.indexed = indexed
        self.stored = stored
        self.facet = facet
        self.owner_type = owner_type


class SearchSort(msrest.serialization.Model):
    """The sort parameters for search.

    :ivar name: The name of the field the search query is sorted on.
    :vartype name: str
    :ivar order: The sort order of the search. Possible values include: "asc", "desc".
    :vartype order: str or ~azure.mgmt.loganalytics.models.SearchSortEnum
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        order: Optional[Union[str, "SearchSortEnum"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the field the search query is sorted on.
        :paramtype name: str
        :keyword order: The sort order of the search. Possible values include: "asc", "desc".
        :paramtype order: str or ~azure.mgmt.loganalytics.models.SearchSortEnum
        """
        super(SearchSort, self).__init__(**kwargs)
        self.name = name
        self.order = order


class SharedKeys(msrest.serialization.Model):
    """The shared keys for a workspace.

    :ivar primary_shared_key: The primary shared key of a workspace.
    :vartype primary_shared_key: str
    :ivar secondary_shared_key: The secondary shared key of a workspace.
    :vartype secondary_shared_key: str
    """

    _attribute_map = {
        'primary_shared_key': {'key': 'primarySharedKey', 'type': 'str'},
        'secondary_shared_key': {'key': 'secondarySharedKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_shared_key: Optional[str] = None,
        secondary_shared_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary_shared_key: The primary shared key of a workspace.
        :paramtype primary_shared_key: str
        :keyword secondary_shared_key: The secondary shared key of a workspace.
        :paramtype secondary_shared_key: str
        """
        super(SharedKeys, self).__init__(**kwargs)
        self.primary_shared_key = primary_shared_key
        self.secondary_shared_key = secondary_shared_key


class StorageAccount(msrest.serialization.Model):
    """Describes a storage account connection.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. The Azure Resource Manager ID of the storage account resource.
    :vartype id: str
    :ivar key: Required. The storage account key.
    :vartype key: str
    """

    _validation = {
        'id': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        key: str,
        **kwargs
    ):
        """
        :keyword id: Required. The Azure Resource Manager ID of the storage account resource.
        :paramtype id: str
        :keyword key: Required. The storage account key.
        :paramtype key: str
        """
        super(StorageAccount, self).__init__(**kwargs)
        self.id = id
        self.key = key


class StorageInsight(ProxyResource):
    """The top level storage insight resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar e_tag: The ETag of the storage insight.
    :vartype e_tag: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar containers: The names of the blob containers that the workspace should read.
    :vartype containers: list[str]
    :ivar tables: The names of the Azure tables that the workspace should read.
    :vartype tables: list[str]
    :ivar storage_account: The storage account connection details.
    :vartype storage_account: ~azure.mgmt.loganalytics.models.StorageAccount
    :ivar status: The status of the storage insight.
    :vartype status: ~azure.mgmt.loganalytics.models.StorageInsightStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'containers': {'key': 'properties.containers', 'type': '[str]'},
        'tables': {'key': 'properties.tables', 'type': '[str]'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccount'},
        'status': {'key': 'properties.status', 'type': 'StorageInsightStatus'},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        containers: Optional[List[str]] = None,
        tables: Optional[List[str]] = None,
        storage_account: Optional["StorageAccount"] = None,
        **kwargs
    ):
        """
        :keyword e_tag: The ETag of the storage insight.
        :paramtype e_tag: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword containers: The names of the blob containers that the workspace should read.
        :paramtype containers: list[str]
        :keyword tables: The names of the Azure tables that the workspace should read.
        :paramtype tables: list[str]
        :keyword storage_account: The storage account connection details.
        :paramtype storage_account: ~azure.mgmt.loganalytics.models.StorageAccount
        """
        super(StorageInsight, self).__init__(**kwargs)
        self.e_tag = e_tag
        self.tags = tags
        self.containers = containers
        self.tables = tables
        self.storage_account = storage_account
        self.status = None


class StorageInsightListResult(msrest.serialization.Model):
    """The list storage insights operation response.

    :ivar value: A list of storage insight items.
    :vartype value: list[~azure.mgmt.loganalytics.models.StorageInsight]
    :ivar odata_next_link: The link (url) to the next page of results.
    :vartype odata_next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageInsight]'},
        'odata_next_link': {'key': '@odata\\.nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["StorageInsight"]] = None,
        odata_next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of storage insight items.
        :paramtype value: list[~azure.mgmt.loganalytics.models.StorageInsight]
        :keyword odata_next_link: The link (url) to the next page of results.
        :paramtype odata_next_link: str
        """
        super(StorageInsightListResult, self).__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class StorageInsightStatus(msrest.serialization.Model):
    """The status of the storage insight.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. The state of the storage insight connection to the workspace. Possible
     values include: "OK", "ERROR".
    :vartype state: str or ~azure.mgmt.loganalytics.models.StorageInsightState
    :ivar description: Description of the state of the storage insight.
    :vartype description: str
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "StorageInsightState"],
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword state: Required. The state of the storage insight connection to the workspace.
         Possible values include: "OK", "ERROR".
        :paramtype state: str or ~azure.mgmt.loganalytics.models.StorageInsightState
        :keyword description: Description of the state of the storage insight.
        :paramtype description: str
        """
        super(StorageInsightStatus, self).__init__(**kwargs)
        self.state = state
        self.description = description


class SystemData(msrest.serialization.Model):
    """Read only system data.

    :ivar created_by: An identifier for the identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "user", "application", "managedIdentity", "key", "SystemAssigned", "UserAssigned", "None".
    :vartype created_by_type: str or ~azure.mgmt.loganalytics.models.IdentityType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: An identifier for the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "user", "application", "managedIdentity", "key", "SystemAssigned",
     "UserAssigned", "None".
    :vartype last_modified_by_type: str or ~azure.mgmt.loganalytics.models.IdentityType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: An identifier for the identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "user", "application", "managedIdentity", "key", "SystemAssigned", "UserAssigned",
         "None".
        :paramtype created_by_type: str or ~azure.mgmt.loganalytics.models.IdentityType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: An identifier for the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "user", "application", "managedIdentity", "key", "SystemAssigned",
         "UserAssigned", "None".
        :paramtype last_modified_by_type: str or ~azure.mgmt.loganalytics.models.IdentityType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class SystemDataAutoGenerated(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.loganalytics.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.loganalytics.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.loganalytics.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.loganalytics.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemDataAutoGenerated, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Table(ProxyResource):
    """Workspace data table definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.loganalytics.models.SystemDataAutoGenerated
    :ivar retention_in_days: The table retention in days, between 4 and 730. Setting this property
     to -1 will default to the workspace retention.
    :vartype retention_in_days: int
    :ivar total_retention_in_days: The table total retention in days, between 4 and 2555. Setting
     this property to -1 will default to table retention.
    :vartype total_retention_in_days: int
    :ivar archive_retention_in_days: The table data archive retention in days. Calculated as
     (totalRetentionInDays-retentionInDays).
    :vartype archive_retention_in_days: int
    :ivar search_results: Parameters of the search job that initiated this table.
    :vartype search_results: ~azure.mgmt.loganalytics.models.SearchResults
    :ivar restored_logs: Parameters of the restore operation that initiated this table.
    :vartype restored_logs: ~azure.mgmt.loganalytics.models.RestoredLogs
    :ivar result_statistics: Search job execution statistics.
    :vartype result_statistics: ~azure.mgmt.loganalytics.models.ResultStatistics
    :ivar plan: Instruct the system how to handle and charge the logs ingested to this table.
     Possible values include: "Basic", "Analytics".
    :vartype plan: str or ~azure.mgmt.loganalytics.models.TablePlanEnum
    :ivar last_plan_modified_date: The timestamp that table plan was last modified (UTC).
    :vartype last_plan_modified_date: str
    :ivar schema: Table schema.
    :vartype schema: ~azure.mgmt.loganalytics.models.Schema
    :ivar provisioning_state: Table's current provisioning state. If set to 'updating', indicates a
     resource lock due to ongoing operation, forbidding any update to the table until the ongoing
     operation is concluded. Possible values include: "Updating", "InProgress", "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.loganalytics.models.ProvisioningStateEnum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'retention_in_days': {'maximum': 730, 'minimum': 4},
        'total_retention_in_days': {'maximum': 2555, 'minimum': 4},
        'archive_retention_in_days': {'readonly': True},
        'last_plan_modified_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemDataAutoGenerated'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
        'total_retention_in_days': {'key': 'properties.totalRetentionInDays', 'type': 'int'},
        'archive_retention_in_days': {'key': 'properties.archiveRetentionInDays', 'type': 'int'},
        'search_results': {'key': 'properties.searchResults', 'type': 'SearchResults'},
        'restored_logs': {'key': 'properties.restoredLogs', 'type': 'RestoredLogs'},
        'result_statistics': {'key': 'properties.resultStatistics', 'type': 'ResultStatistics'},
        'plan': {'key': 'properties.plan', 'type': 'str'},
        'last_plan_modified_date': {'key': 'properties.lastPlanModifiedDate', 'type': 'str'},
        'schema': {'key': 'properties.schema', 'type': 'Schema'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        retention_in_days: Optional[int] = None,
        total_retention_in_days: Optional[int] = None,
        search_results: Optional["SearchResults"] = None,
        restored_logs: Optional["RestoredLogs"] = None,
        result_statistics: Optional["ResultStatistics"] = None,
        plan: Optional[Union[str, "TablePlanEnum"]] = None,
        schema: Optional["Schema"] = None,
        **kwargs
    ):
        """
        :keyword retention_in_days: The table retention in days, between 4 and 730. Setting this
         property to -1 will default to the workspace retention.
        :paramtype retention_in_days: int
        :keyword total_retention_in_days: The table total retention in days, between 4 and 2555.
         Setting this property to -1 will default to table retention.
        :paramtype total_retention_in_days: int
        :keyword search_results: Parameters of the search job that initiated this table.
        :paramtype search_results: ~azure.mgmt.loganalytics.models.SearchResults
        :keyword restored_logs: Parameters of the restore operation that initiated this table.
        :paramtype restored_logs: ~azure.mgmt.loganalytics.models.RestoredLogs
        :keyword result_statistics: Search job execution statistics.
        :paramtype result_statistics: ~azure.mgmt.loganalytics.models.ResultStatistics
        :keyword plan: Instruct the system how to handle and charge the logs ingested to this table.
         Possible values include: "Basic", "Analytics".
        :paramtype plan: str or ~azure.mgmt.loganalytics.models.TablePlanEnum
        :keyword schema: Table schema.
        :paramtype schema: ~azure.mgmt.loganalytics.models.Schema
        """
        super(Table, self).__init__(**kwargs)
        self.system_data = None
        self.retention_in_days = retention_in_days
        self.total_retention_in_days = total_retention_in_days
        self.archive_retention_in_days = None
        self.search_results = search_results
        self.restored_logs = restored_logs
        self.result_statistics = result_statistics
        self.plan = plan
        self.last_plan_modified_date = None
        self.schema = schema
        self.provisioning_state = None


class TablesListResult(msrest.serialization.Model):
    """The list tables operation response.

    :ivar value: A list of data tables.
    :vartype value: list[~azure.mgmt.loganalytics.models.Table]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Table]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Table"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of data tables.
        :paramtype value: list[~azure.mgmt.loganalytics.models.Table]
        """
        super(TablesListResult, self).__init__(**kwargs)
        self.value = value


class Tag(msrest.serialization.Model):
    """A tag of a saved search.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The tag name.
    :vartype name: str
    :ivar value: Required. The tag value.
    :vartype value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        """
        :keyword name: Required. The tag name.
        :paramtype name: str
        :keyword value: Required. The tag value.
        :paramtype value: str
        """
        super(Tag, self).__init__(**kwargs)
        self.name = name
        self.value = value


class TagsResource(msrest.serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a QueryPack instance.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(TagsResource, self).__init__(**kwargs)
        self.tags = tags


class UsageMetric(msrest.serialization.Model):
    """A metric describing the usage of a resource.

    :ivar name: The name of the metric.
    :vartype name: ~azure.mgmt.loganalytics.models.MetricName
    :ivar unit: The units used for the metric.
    :vartype unit: str
    :ivar current_value: The current value of the metric.
    :vartype current_value: float
    :ivar limit: The quota limit for the metric.
    :vartype limit: float
    :ivar next_reset_time: The time that the metric's value will reset.
    :vartype next_reset_time: ~datetime.datetime
    :ivar quota_period: The quota period that determines the length of time between value resets.
    :vartype quota_period: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'MetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional["MetricName"] = None,
        unit: Optional[str] = None,
        current_value: Optional[float] = None,
        limit: Optional[float] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        quota_period: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the metric.
        :paramtype name: ~azure.mgmt.loganalytics.models.MetricName
        :keyword unit: The units used for the metric.
        :paramtype unit: str
        :keyword current_value: The current value of the metric.
        :paramtype current_value: float
        :keyword limit: The quota limit for the metric.
        :paramtype limit: float
        :keyword next_reset_time: The time that the metric's value will reset.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword quota_period: The quota period that determines the length of time between value
         resets.
        :paramtype quota_period: str
        """
        super(UsageMetric, self).__init__(**kwargs)
        self.name = name
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.next_reset_time = next_reset_time
        self.quota_period = quota_period


class UserIdentityProperties(msrest.serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Workspace(TrackedResource):
    """The top level Workspace resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.loganalytics.models.SystemDataAutoGenerated
    :ivar e_tag: The ETag of the workspace.
    :vartype e_tag: str
    :ivar provisioning_state: The provisioning state of the workspace. Possible values include:
     "Creating", "Succeeded", "Failed", "Canceled", "Deleting", "ProvisioningAccount", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.loganalytics.models.WorkspaceEntityStatus
    :ivar customer_id: This is a read-only property. Represents the ID associated with the
     workspace.
    :vartype customer_id: str
    :ivar sku: The SKU of the workspace.
    :vartype sku: ~azure.mgmt.loganalytics.models.WorkspaceSku
    :ivar retention_in_days: The workspace data retention in days. Allowed values are per pricing
     plan. See pricing tiers documentation for details.
    :vartype retention_in_days: int
    :ivar workspace_capping: The daily volume cap for ingestion.
    :vartype workspace_capping: ~azure.mgmt.loganalytics.models.WorkspaceCapping
    :ivar created_date: Workspace creation date.
    :vartype created_date: str
    :ivar modified_date: Workspace modification date.
    :vartype modified_date: str
    :ivar public_network_access_for_ingestion: The network access type for accessing Log Analytics
     ingestion. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :vartype public_network_access_for_ingestion: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :ivar public_network_access_for_query: The network access type for accessing Log Analytics
     query. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :vartype public_network_access_for_query: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :ivar force_cmk_for_query: Indicates whether customer managed storage is mandatory for query
     management.
    :vartype force_cmk_for_query: bool
    :ivar private_link_scoped_resources: List of linked private link scope resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.loganalytics.models.PrivateLinkScopedResource]
    :ivar features: Workspace features.
    :vartype features: ~azure.mgmt.loganalytics.models.WorkspaceFeatures
    :ivar default_data_collection_rule_resource_id: The resource ID of the default Data Collection
     Rule to use for this workspace. Expected format is -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
    :vartype default_data_collection_rule_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'customer_id': {'readonly': True},
        'created_date': {'readonly': True},
        'modified_date': {'readonly': True},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemDataAutoGenerated'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'WorkspaceSku'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
        'workspace_capping': {'key': 'properties.workspaceCapping', 'type': 'WorkspaceCapping'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'modified_date': {'key': 'properties.modifiedDate', 'type': 'str'},
        'public_network_access_for_ingestion': {'key': 'properties.publicNetworkAccessForIngestion', 'type': 'str'},
        'public_network_access_for_query': {'key': 'properties.publicNetworkAccessForQuery', 'type': 'str'},
        'force_cmk_for_query': {'key': 'properties.forceCmkForQuery', 'type': 'bool'},
        'private_link_scoped_resources': {'key': 'properties.privateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'features': {'key': 'properties.features', 'type': 'WorkspaceFeatures'},
        'default_data_collection_rule_resource_id': {'key': 'properties.defaultDataCollectionRuleResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        sku: Optional["WorkspaceSku"] = None,
        retention_in_days: Optional[int] = None,
        workspace_capping: Optional["WorkspaceCapping"] = None,
        public_network_access_for_ingestion: Optional[Union[str, "PublicNetworkAccessType"]] = "Enabled",
        public_network_access_for_query: Optional[Union[str, "PublicNetworkAccessType"]] = "Enabled",
        force_cmk_for_query: Optional[bool] = None,
        features: Optional["WorkspaceFeatures"] = None,
        default_data_collection_rule_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword e_tag: The ETag of the workspace.
        :paramtype e_tag: str
        :keyword sku: The SKU of the workspace.
        :paramtype sku: ~azure.mgmt.loganalytics.models.WorkspaceSku
        :keyword retention_in_days: The workspace data retention in days. Allowed values are per
         pricing plan. See pricing tiers documentation for details.
        :paramtype retention_in_days: int
        :keyword workspace_capping: The daily volume cap for ingestion.
        :paramtype workspace_capping: ~azure.mgmt.loganalytics.models.WorkspaceCapping
        :keyword public_network_access_for_ingestion: The network access type for accessing Log
         Analytics ingestion. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
        :paramtype public_network_access_for_ingestion: str or
         ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
        :keyword public_network_access_for_query: The network access type for accessing Log Analytics
         query. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
        :paramtype public_network_access_for_query: str or
         ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
        :keyword force_cmk_for_query: Indicates whether customer managed storage is mandatory for query
         management.
        :paramtype force_cmk_for_query: bool
        :keyword features: Workspace features.
        :paramtype features: ~azure.mgmt.loganalytics.models.WorkspaceFeatures
        :keyword default_data_collection_rule_resource_id: The resource ID of the default Data
         Collection Rule to use for this workspace. Expected format is -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
        :paramtype default_data_collection_rule_resource_id: str
        """
        super(Workspace, self).__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.e_tag = e_tag
        self.provisioning_state = None
        self.customer_id = None
        self.sku = sku
        self.retention_in_days = retention_in_days
        self.workspace_capping = workspace_capping
        self.created_date = None
        self.modified_date = None
        self.public_network_access_for_ingestion = public_network_access_for_ingestion
        self.public_network_access_for_query = public_network_access_for_query
        self.force_cmk_for_query = force_cmk_for_query
        self.private_link_scoped_resources = None
        self.features = features
        self.default_data_collection_rule_resource_id = default_data_collection_rule_resource_id


class WorkspaceCapping(msrest.serialization.Model):
    """The daily volume cap for ingestion.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar daily_quota_gb: The workspace daily quota for ingestion.
    :vartype daily_quota_gb: float
    :ivar quota_next_reset_time: The time when the quota will be rest.
    :vartype quota_next_reset_time: str
    :ivar data_ingestion_status: The status of data ingestion for this workspace. Possible values
     include: "RespectQuota", "ForceOn", "ForceOff", "OverQuota", "SubscriptionSuspended",
     "ApproachingQuota".
    :vartype data_ingestion_status: str or ~azure.mgmt.loganalytics.models.DataIngestionStatus
    """

    _validation = {
        'quota_next_reset_time': {'readonly': True},
        'data_ingestion_status': {'readonly': True},
    }

    _attribute_map = {
        'daily_quota_gb': {'key': 'dailyQuotaGb', 'type': 'float'},
        'quota_next_reset_time': {'key': 'quotaNextResetTime', 'type': 'str'},
        'data_ingestion_status': {'key': 'dataIngestionStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        daily_quota_gb: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword daily_quota_gb: The workspace daily quota for ingestion.
        :paramtype daily_quota_gb: float
        """
        super(WorkspaceCapping, self).__init__(**kwargs)
        self.daily_quota_gb = daily_quota_gb
        self.quota_next_reset_time = None
        self.data_ingestion_status = None


class WorkspaceFeatures(msrest.serialization.Model):
    """Workspace features.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar enable_data_export: Flag that indicate if data should be exported.
    :vartype enable_data_export: bool
    :ivar immediate_purge_data_on30_days: Flag that describes if we want to remove the data after
     30 days.
    :vartype immediate_purge_data_on30_days: bool
    :ivar enable_log_access_using_only_resource_permissions: Flag that indicate which permission to
     use - resource or workspace or both.
    :vartype enable_log_access_using_only_resource_permissions: bool
    :ivar cluster_resource_id: Dedicated LA cluster resourceId that is linked to the workspaces.
    :vartype cluster_resource_id: str
    :ivar disable_local_auth: Disable Non-AAD based Auth.
    :vartype disable_local_auth: bool
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'enable_data_export': {'key': 'enableDataExport', 'type': 'bool'},
        'immediate_purge_data_on30_days': {'key': 'immediatePurgeDataOn30Days', 'type': 'bool'},
        'enable_log_access_using_only_resource_permissions': {'key': 'enableLogAccessUsingOnlyResourcePermissions', 'type': 'bool'},
        'cluster_resource_id': {'key': 'clusterResourceId', 'type': 'str'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        enable_data_export: Optional[bool] = None,
        immediate_purge_data_on30_days: Optional[bool] = None,
        enable_log_access_using_only_resource_permissions: Optional[bool] = None,
        cluster_resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword enable_data_export: Flag that indicate if data should be exported.
        :paramtype enable_data_export: bool
        :keyword immediate_purge_data_on30_days: Flag that describes if we want to remove the data
         after 30 days.
        :paramtype immediate_purge_data_on30_days: bool
        :keyword enable_log_access_using_only_resource_permissions: Flag that indicate which permission
         to use - resource or workspace or both.
        :paramtype enable_log_access_using_only_resource_permissions: bool
        :keyword cluster_resource_id: Dedicated LA cluster resourceId that is linked to the workspaces.
        :paramtype cluster_resource_id: str
        :keyword disable_local_auth: Disable Non-AAD based Auth.
        :paramtype disable_local_auth: bool
        """
        super(WorkspaceFeatures, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.enable_data_export = enable_data_export
        self.immediate_purge_data_on30_days = immediate_purge_data_on30_days
        self.enable_log_access_using_only_resource_permissions = enable_log_access_using_only_resource_permissions
        self.cluster_resource_id = cluster_resource_id
        self.disable_local_auth = disable_local_auth


class WorkspaceListManagementGroupsResult(msrest.serialization.Model):
    """The list workspace management groups operation response.

    :ivar value: Gets or sets a list of management groups attached to the workspace.
    :vartype value: list[~azure.mgmt.loganalytics.models.ManagementGroup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagementGroup]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagementGroup"]] = None,
        **kwargs
    ):
        """
        :keyword value: Gets or sets a list of management groups attached to the workspace.
        :paramtype value: list[~azure.mgmt.loganalytics.models.ManagementGroup]
        """
        super(WorkspaceListManagementGroupsResult, self).__init__(**kwargs)
        self.value = value


class WorkspaceListResult(msrest.serialization.Model):
    """The list workspaces operation response.

    :ivar value: A list of workspaces.
    :vartype value: list[~azure.mgmt.loganalytics.models.Workspace]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workspace]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Workspace"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of workspaces.
        :paramtype value: list[~azure.mgmt.loganalytics.models.Workspace]
        """
        super(WorkspaceListResult, self).__init__(**kwargs)
        self.value = value


class WorkspaceListUsagesResult(msrest.serialization.Model):
    """The list workspace usages operation response.

    :ivar value: Gets or sets a list of usage metrics for a workspace.
    :vartype value: list[~azure.mgmt.loganalytics.models.UsageMetric]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UsageMetric]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UsageMetric"]] = None,
        **kwargs
    ):
        """
        :keyword value: Gets or sets a list of usage metrics for a workspace.
        :paramtype value: list[~azure.mgmt.loganalytics.models.UsageMetric]
        """
        super(WorkspaceListUsagesResult, self).__init__(**kwargs)
        self.value = value


class WorkspacePatch(AzureEntityResource):
    """The top level Workspace resource container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar tags: A set of tags. Resource tags. Optional.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the workspace. Possible values include:
     "Creating", "Succeeded", "Failed", "Canceled", "Deleting", "ProvisioningAccount", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.loganalytics.models.WorkspaceEntityStatus
    :ivar customer_id: This is a read-only property. Represents the ID associated with the
     workspace.
    :vartype customer_id: str
    :ivar sku: The SKU of the workspace.
    :vartype sku: ~azure.mgmt.loganalytics.models.WorkspaceSku
    :ivar retention_in_days: The workspace data retention in days. Allowed values are per pricing
     plan. See pricing tiers documentation for details.
    :vartype retention_in_days: int
    :ivar workspace_capping: The daily volume cap for ingestion.
    :vartype workspace_capping: ~azure.mgmt.loganalytics.models.WorkspaceCapping
    :ivar created_date: Workspace creation date.
    :vartype created_date: str
    :ivar modified_date: Workspace modification date.
    :vartype modified_date: str
    :ivar public_network_access_for_ingestion: The network access type for accessing Log Analytics
     ingestion. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :vartype public_network_access_for_ingestion: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :ivar public_network_access_for_query: The network access type for accessing Log Analytics
     query. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :vartype public_network_access_for_query: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :ivar force_cmk_for_query: Indicates whether customer managed storage is mandatory for query
     management.
    :vartype force_cmk_for_query: bool
    :ivar private_link_scoped_resources: List of linked private link scope resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.loganalytics.models.PrivateLinkScopedResource]
    :ivar features: Workspace features.
    :vartype features: ~azure.mgmt.loganalytics.models.WorkspaceFeatures
    :ivar default_data_collection_rule_resource_id: The resource ID of the default Data Collection
     Rule to use for this workspace. Expected format is -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
    :vartype default_data_collection_rule_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'customer_id': {'readonly': True},
        'created_date': {'readonly': True},
        'modified_date': {'readonly': True},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'WorkspaceSku'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
        'workspace_capping': {'key': 'properties.workspaceCapping', 'type': 'WorkspaceCapping'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'modified_date': {'key': 'properties.modifiedDate', 'type': 'str'},
        'public_network_access_for_ingestion': {'key': 'properties.publicNetworkAccessForIngestion', 'type': 'str'},
        'public_network_access_for_query': {'key': 'properties.publicNetworkAccessForQuery', 'type': 'str'},
        'force_cmk_for_query': {'key': 'properties.forceCmkForQuery', 'type': 'bool'},
        'private_link_scoped_resources': {'key': 'properties.privateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'features': {'key': 'properties.features', 'type': 'WorkspaceFeatures'},
        'default_data_collection_rule_resource_id': {'key': 'properties.defaultDataCollectionRuleResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["WorkspaceSku"] = None,
        retention_in_days: Optional[int] = None,
        workspace_capping: Optional["WorkspaceCapping"] = None,
        public_network_access_for_ingestion: Optional[Union[str, "PublicNetworkAccessType"]] = "Enabled",
        public_network_access_for_query: Optional[Union[str, "PublicNetworkAccessType"]] = "Enabled",
        force_cmk_for_query: Optional[bool] = None,
        features: Optional["WorkspaceFeatures"] = None,
        default_data_collection_rule_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags. Optional.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU of the workspace.
        :paramtype sku: ~azure.mgmt.loganalytics.models.WorkspaceSku
        :keyword retention_in_days: The workspace data retention in days. Allowed values are per
         pricing plan. See pricing tiers documentation for details.
        :paramtype retention_in_days: int
        :keyword workspace_capping: The daily volume cap for ingestion.
        :paramtype workspace_capping: ~azure.mgmt.loganalytics.models.WorkspaceCapping
        :keyword public_network_access_for_ingestion: The network access type for accessing Log
         Analytics ingestion. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
        :paramtype public_network_access_for_ingestion: str or
         ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
        :keyword public_network_access_for_query: The network access type for accessing Log Analytics
         query. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
        :paramtype public_network_access_for_query: str or
         ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
        :keyword force_cmk_for_query: Indicates whether customer managed storage is mandatory for query
         management.
        :paramtype force_cmk_for_query: bool
        :keyword features: Workspace features.
        :paramtype features: ~azure.mgmt.loganalytics.models.WorkspaceFeatures
        :keyword default_data_collection_rule_resource_id: The resource ID of the default Data
         Collection Rule to use for this workspace. Expected format is -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
        :paramtype default_data_collection_rule_resource_id: str
        """
        super(WorkspacePatch, self).__init__(**kwargs)
        self.tags = tags
        self.provisioning_state = None
        self.customer_id = None
        self.sku = sku
        self.retention_in_days = retention_in_days
        self.workspace_capping = workspace_capping
        self.created_date = None
        self.modified_date = None
        self.public_network_access_for_ingestion = public_network_access_for_ingestion
        self.public_network_access_for_query = public_network_access_for_query
        self.force_cmk_for_query = force_cmk_for_query
        self.private_link_scoped_resources = None
        self.features = features
        self.default_data_collection_rule_resource_id = default_data_collection_rule_resource_id


class WorkspacePurgeBody(msrest.serialization.Model):
    """Describes the body of a purge request for an App Insights Workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar table: Required. Table from which to purge data.
    :vartype table: str
    :ivar filters: Required. The set of columns and filters (queries) to run over them to purge the
     resulting data.
    :vartype filters: list[~azure.mgmt.loganalytics.models.WorkspacePurgeBodyFilters]
    """

    _validation = {
        'table': {'required': True},
        'filters': {'required': True},
    }

    _attribute_map = {
        'table': {'key': 'table', 'type': 'str'},
        'filters': {'key': 'filters', 'type': '[WorkspacePurgeBodyFilters]'},
    }

    def __init__(
        self,
        *,
        table: str,
        filters: List["WorkspacePurgeBodyFilters"],
        **kwargs
    ):
        """
        :keyword table: Required. Table from which to purge data.
        :paramtype table: str
        :keyword filters: Required. The set of columns and filters (queries) to run over them to purge
         the resulting data.
        :paramtype filters: list[~azure.mgmt.loganalytics.models.WorkspacePurgeBodyFilters]
        """
        super(WorkspacePurgeBody, self).__init__(**kwargs)
        self.table = table
        self.filters = filters


class WorkspacePurgeBodyFilters(msrest.serialization.Model):
    """User-defined filters to return data which will be purged from the table.

    :ivar column: The column of the table over which the given query should run.
    :vartype column: str
    :ivar operator: A query operator to evaluate over the provided column and value(s). Supported
     operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as they would
     in a KQL query.
    :vartype operator: str
    :ivar value: the value for the operator to function over. This can be a number (e.g., > 100), a
     string (timestamp >= '2017-09-01') or array of values.
    :vartype value: any
    :ivar key: When filtering over custom dimensions, this key will be used as the name of the
     custom dimension.
    :vartype key: str
    """

    _attribute_map = {
        'column': {'key': 'column', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        column: Optional[str] = None,
        operator: Optional[str] = None,
        value: Optional[Any] = None,
        key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword column: The column of the table over which the given query should run.
        :paramtype column: str
        :keyword operator: A query operator to evaluate over the provided column and value(s).
         Supported operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as
         they would in a KQL query.
        :paramtype operator: str
        :keyword value: the value for the operator to function over. This can be a number (e.g., >
         100), a string (timestamp >= '2017-09-01') or array of values.
        :paramtype value: any
        :keyword key: When filtering over custom dimensions, this key will be used as the name of the
         custom dimension.
        :paramtype key: str
        """
        super(WorkspacePurgeBodyFilters, self).__init__(**kwargs)
        self.column = column
        self.operator = operator
        self.value = value
        self.key = key


class WorkspacePurgeResponse(msrest.serialization.Model):
    """Response containing operationId for a specific purge action.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Id to use when querying for status for a particular purge
     operation.
    :vartype operation_id: str
    """

    _validation = {
        'operation_id': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Id to use when querying for status for a particular purge
         operation.
        :paramtype operation_id: str
        """
        super(WorkspacePurgeResponse, self).__init__(**kwargs)
        self.operation_id = operation_id


class WorkspacePurgeStatusResponse(msrest.serialization.Model):
    """Response containing status for a specific purge operation.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Status of the operation represented by the requested Id. Possible
     values include: "pending", "completed".
    :vartype status: str or ~azure.mgmt.loganalytics.models.PurgeState
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PurgeState"],
        **kwargs
    ):
        """
        :keyword status: Required. Status of the operation represented by the requested Id. Possible
         values include: "pending", "completed".
        :paramtype status: str or ~azure.mgmt.loganalytics.models.PurgeState
        """
        super(WorkspacePurgeStatusResponse, self).__init__(**kwargs)
        self.status = status


class WorkspaceSku(msrest.serialization.Model):
    """The SKU (tier) of a workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the SKU. Possible values include: "Free", "Standard",
     "Premium", "PerNode", "PerGB2018", "Standalone", "CapacityReservation", "LACluster".
    :vartype name: str or ~azure.mgmt.loganalytics.models.WorkspaceSkuNameEnum
    :ivar capacity_reservation_level: The capacity reservation level in GB for this workspace, when
     CapacityReservation sku is selected. Possible values include: 100, 200, 300, 400, 500, 1000,
     2000, 5000.
    :vartype capacity_reservation_level: int or
     ~azure.mgmt.loganalytics.models.CapacityReservationLevel
    :ivar last_sku_update: The last time when the sku was updated.
    :vartype last_sku_update: str
    """

    _validation = {
        'name': {'required': True},
        'last_sku_update': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity_reservation_level': {'key': 'capacityReservationLevel', 'type': 'int'},
        'last_sku_update': {'key': 'lastSkuUpdate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "WorkspaceSkuNameEnum"],
        capacity_reservation_level: Optional[Union[int, "CapacityReservationLevel"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the SKU. Possible values include: "Free", "Standard",
         "Premium", "PerNode", "PerGB2018", "Standalone", "CapacityReservation", "LACluster".
        :paramtype name: str or ~azure.mgmt.loganalytics.models.WorkspaceSkuNameEnum
        :keyword capacity_reservation_level: The capacity reservation level in GB for this workspace,
         when CapacityReservation sku is selected. Possible values include: 100, 200, 300, 400, 500,
         1000, 2000, 5000.
        :paramtype capacity_reservation_level: int or
         ~azure.mgmt.loganalytics.models.CapacityReservationLevel
        """
        super(WorkspaceSku, self).__init__(**kwargs)
        self.name = name
        self.capacity_reservation_level = capacity_reservation_level
        self.last_sku_update = None
