# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ActionOnUnmanage(_serialization.Model):
    """Defines the behavior of resources that are no longer managed after the stack is updated or
    deleted.

    All required parameters must be populated in order to send to server.

    :ivar resources: Specifies an action for a newly unmanaged resource. Delete will attempt to
     delete the resource from Azure. Detach will leave the resource in it's current state. Required.
     Known values are: "delete" and "detach".
    :vartype resources: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDeleteDetachEnum
    :ivar resource_groups: Specifies an action for a newly unmanaged resource. Delete will attempt
     to delete the resource from Azure. Detach will leave the resource in it's current state. Known
     values are: "delete" and "detach".
    :vartype resource_groups: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDeleteDetachEnum
    :ivar management_groups: Specifies an action for a newly unmanaged resource. Delete will
     attempt to delete the resource from Azure. Detach will leave the resource in it's current
     state. Known values are: "delete" and "detach".
    :vartype management_groups: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDeleteDetachEnum
    """

    _validation = {
        "resources": {"required": True},
    }

    _attribute_map = {
        "resources": {"key": "resources", "type": "str"},
        "resource_groups": {"key": "resourceGroups", "type": "str"},
        "management_groups": {"key": "managementGroups", "type": "str"},
    }

    def __init__(
        self,
        *,
        resources: Union[str, "_models.DeploymentStacksDeleteDetachEnum"],
        resource_groups: Optional[Union[str, "_models.DeploymentStacksDeleteDetachEnum"]] = None,
        management_groups: Optional[Union[str, "_models.DeploymentStacksDeleteDetachEnum"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resources: Specifies an action for a newly unmanaged resource. Delete will attempt to
         delete the resource from Azure. Detach will leave the resource in it's current state. Required.
         Known values are: "delete" and "detach".
        :paramtype resources: str or
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDeleteDetachEnum
        :keyword resource_groups: Specifies an action for a newly unmanaged resource. Delete will
         attempt to delete the resource from Azure. Detach will leave the resource in it's current
         state. Known values are: "delete" and "detach".
        :paramtype resource_groups: str or
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDeleteDetachEnum
        :keyword management_groups: Specifies an action for a newly unmanaged resource. Delete will
         attempt to delete the resource from Azure. Detach will leave the resource in it's current
         state. Known values are: "delete" and "detach".
        :paramtype management_groups: str or
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDeleteDetachEnum
        """
        super().__init__(**kwargs)
        self.resources = resources
        self.resource_groups = resource_groups
        self.management_groups = management_groups


class AzureResourceBase(_serialization.Model):
    """Common properties for all Azure resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: String Id used to locate any resource on Azure.
    :vartype id: str
    :ivar name: Name of this resource.
    :vartype name: str
    :ivar type: Type of this resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class DenySettings(_serialization.Model):
    """Defines how resources deployed by the Deployment stack are locked.

    All required parameters must be populated in order to send to server.

    :ivar mode: denySettings Mode that defines denied actions. Required. Known values are:
     "denyDelete", "denyWriteAndDelete", and "none".
    :vartype mode: str or ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenySettingsMode
    :ivar excluded_principals: List of AAD principal IDs excluded from the lock. Up to 5 principals
     are permitted.
    :vartype excluded_principals: list[str]
    :ivar excluded_actions: List of role-based management operations that are excluded from the
     denySettings. Up to 200 actions are permitted. If the denySetting mode is set to
     'denyWriteAndDelete', then the following actions are automatically appended to
     'excludedActions': '*\\/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting
     mode is set to 'denyDelete', then the following actions are automatically appended to
     'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
    :vartype excluded_actions: list[str]
    :ivar apply_to_child_scopes: DenySettings will be applied to child resource scopes of every
     managed resource with a deny assignment.
    :vartype apply_to_child_scopes: bool
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "excluded_principals": {"key": "excludedPrincipals", "type": "[str]"},
        "excluded_actions": {"key": "excludedActions", "type": "[str]"},
        "apply_to_child_scopes": {"key": "applyToChildScopes", "type": "bool"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.DenySettingsMode"],
        excluded_principals: Optional[List[str]] = None,
        excluded_actions: Optional[List[str]] = None,
        apply_to_child_scopes: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: denySettings Mode that defines denied actions. Required. Known values are:
         "denyDelete", "denyWriteAndDelete", and "none".
        :paramtype mode: str or
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenySettingsMode
        :keyword excluded_principals: List of AAD principal IDs excluded from the lock. Up to 5
         principals are permitted.
        :paramtype excluded_principals: list[str]
        :keyword excluded_actions: List of role-based management operations that are excluded from the
         denySettings. Up to 200 actions are permitted. If the denySetting mode is set to
         'denyWriteAndDelete', then the following actions are automatically appended to
         'excludedActions': '*\\/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting
         mode is set to 'denyDelete', then the following actions are automatically appended to
         'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
        :paramtype excluded_actions: list[str]
        :keyword apply_to_child_scopes: DenySettings will be applied to child resource scopes of every
         managed resource with a deny assignment.
        :paramtype apply_to_child_scopes: bool
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.excluded_principals = excluded_principals
        self.excluded_actions = excluded_actions
        self.apply_to_child_scopes = apply_to_child_scopes


class DeploymentParameter(_serialization.Model):
    """Deployment parameter for the template.

    :ivar value: Input value to the parameter.
    :vartype value: any
    :ivar type: Type of the value.
    :vartype type: str
    :ivar reference: Azure Key Vault parameter reference.
    :vartype reference:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.KeyVaultParameterReference
    """

    _attribute_map = {
        "value": {"key": "value", "type": "object"},
        "type": {"key": "type", "type": "str"},
        "reference": {"key": "reference", "type": "KeyVaultParameterReference"},
    }

    def __init__(
        self,
        *,
        value: Optional[Any] = None,
        type: Optional[str] = None,
        reference: Optional["_models.KeyVaultParameterReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Input value to the parameter.
        :paramtype value: any
        :keyword type: Type of the value.
        :paramtype type: str
        :keyword reference: Azure Key Vault parameter reference.
        :paramtype reference:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.KeyVaultParameterReference
        """
        super().__init__(**kwargs)
        self.value = value
        self.type = type
        self.reference = reference


class DeploymentStack(AzureResourceBase):
    """Deployment stack object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: String Id used to locate any resource on Azure.
    :vartype id: str
    :ivar name: Name of this resource.
    :vartype name: str
    :ivar type: Type of this resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.SystemData
    :ivar location: The location of the Deployment stack. It cannot be changed after creation. It
     must be one of the supported Azure locations.
    :vartype location: str
    :ivar tags: Deployment stack resource tags.
    :vartype tags: dict[str, str]
    :ivar error: The error detail.
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksTemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     Use this element when providing the parameter values directly in the request, rather than
     linking to an existing parameter file. Use either the parametersLink property or the parameters
     property, but not both.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentParameter]
    :ivar parameters_link: The URI of parameters file. Use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksParametersLink
    :ivar action_on_unmanage: Defines the behavior of resources that are no longer managed after
     the Deployment stack is updated or deleted.
    :vartype action_on_unmanage:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ActionOnUnmanage
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDebugSetting
    :ivar bypass_stack_out_of_sync_error: Flag to bypass service errors that indicate the stack
     resource list is not correctly synchronized.
    :vartype bypass_stack_out_of_sync_error: bool
    :ivar deployment_scope: The scope at which the initial deployment should be created. If a scope
     is not specified, it will default to the scope of the deployment stack. Valid scopes are:
     management group (format:
     '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     '/subscriptions/{subscriptionId}'), resource group (format:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
    :vartype deployment_scope: str
    :ivar description: Deployment stack description. Max length of 4096 characters.
    :vartype description: str
    :ivar deny_settings: Defines how resources deployed by the stack are locked.
    :vartype deny_settings: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenySettings
    :ivar provisioning_state: State of the deployment stack. Known values are: "creating",
     "validating", "waiting", "deploying", "canceling", "updatingDenyAssignments",
     "deletingResources", "succeeded", "failed", "canceled", and "deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStackProvisioningState
    :ivar correlation_id: The correlation id of the last Deployment stack upsert or delete
     operation. It is in GUID format and is used for tracing.
    :vartype correlation_id: str
    :ivar detached_resources: An array of resources that were detached during the most recent
     Deployment stack update. Detached means that the resource was removed from the template, but no
     relevant deletion operations were specified. So, the resource still exists while no longer
     being associated with the stack.
    :vartype detached_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceReference]
    :ivar deleted_resources: An array of resources that were deleted during the most recent
     Deployment stack update. Deleted means that the resource was removed from the template and
     relevant deletion operations were specified.
    :vartype deleted_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceReference]
    :ivar failed_resources: An array of resources that failed to reach goal state during the most
     recent update. Each resourceId is accompanied by an error message.
    :vartype failed_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceReferenceExtended]
    :ivar resources: An array of resources currently managed by the deployment stack.
    :vartype resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ManagedResourceReference]
    :ivar deployment_id: The resourceId of the deployment resource created by the deployment stack.
    :vartype deployment_id: str
    :ivar outputs: The outputs of the deployment resource created by the deployment stack.
    :vartype outputs: JSON
    :ivar duration: The duration of the last successful Deployment stack update.
    :vartype duration: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "description": {"max_length": 4096},
        "provisioning_state": {"readonly": True},
        "correlation_id": {"readonly": True},
        "detached_resources": {"readonly": True},
        "deleted_resources": {"readonly": True},
        "failed_resources": {"readonly": True},
        "resources": {"readonly": True},
        "deployment_id": {"readonly": True},
        "outputs": {"readonly": True},
        "duration": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "error": {"key": "properties.error", "type": "ErrorDetail"},
        "template": {"key": "properties.template", "type": "object"},
        "template_link": {"key": "properties.templateLink", "type": "DeploymentStacksTemplateLink"},
        "parameters": {"key": "properties.parameters", "type": "{DeploymentParameter}"},
        "parameters_link": {"key": "properties.parametersLink", "type": "DeploymentStacksParametersLink"},
        "action_on_unmanage": {"key": "properties.actionOnUnmanage", "type": "ActionOnUnmanage"},
        "debug_setting": {"key": "properties.debugSetting", "type": "DeploymentStacksDebugSetting"},
        "bypass_stack_out_of_sync_error": {"key": "properties.bypassStackOutOfSyncError", "type": "bool"},
        "deployment_scope": {"key": "properties.deploymentScope", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "deny_settings": {"key": "properties.denySettings", "type": "DenySettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "correlation_id": {"key": "properties.correlationId", "type": "str"},
        "detached_resources": {"key": "properties.detachedResources", "type": "[ResourceReference]"},
        "deleted_resources": {"key": "properties.deletedResources", "type": "[ResourceReference]"},
        "failed_resources": {"key": "properties.failedResources", "type": "[ResourceReferenceExtended]"},
        "resources": {"key": "properties.resources", "type": "[ManagedResourceReference]"},
        "deployment_id": {"key": "properties.deploymentId", "type": "str"},
        "outputs": {"key": "properties.outputs", "type": "object"},
        "duration": {"key": "properties.duration", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        template: Optional[JSON] = None,
        template_link: Optional["_models.DeploymentStacksTemplateLink"] = None,
        parameters: Optional[Dict[str, "_models.DeploymentParameter"]] = None,
        parameters_link: Optional["_models.DeploymentStacksParametersLink"] = None,
        action_on_unmanage: Optional["_models.ActionOnUnmanage"] = None,
        debug_setting: Optional["_models.DeploymentStacksDebugSetting"] = None,
        bypass_stack_out_of_sync_error: Optional[bool] = None,
        deployment_scope: Optional[str] = None,
        description: Optional[str] = None,
        deny_settings: Optional["_models.DenySettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the Deployment stack. It cannot be changed after creation.
         It must be one of the supported Azure locations.
        :paramtype location: str
        :keyword tags: Deployment stack resource tags.
        :paramtype tags: dict[str, str]
        :keyword error: The error detail.
        :paramtype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksTemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. Use this element when providing the parameter values directly in the request, rather
         than linking to an existing parameter file. Use either the parametersLink property or the
         parameters property, but not both.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentParameter]
        :keyword parameters_link: The URI of parameters file. Use this element to link to an existing
         parameters file. Use either the parametersLink property or the parameters property, but not
         both.
        :paramtype parameters_link:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksParametersLink
        :keyword action_on_unmanage: Defines the behavior of resources that are no longer managed after
         the Deployment stack is updated or deleted.
        :paramtype action_on_unmanage:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ActionOnUnmanage
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDebugSetting
        :keyword bypass_stack_out_of_sync_error: Flag to bypass service errors that indicate the stack
         resource list is not correctly synchronized.
        :paramtype bypass_stack_out_of_sync_error: bool
        :keyword deployment_scope: The scope at which the initial deployment should be created. If a
         scope is not specified, it will default to the scope of the deployment stack. Valid scopes are:
         management group (format:
         '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
         '/subscriptions/{subscriptionId}'), resource group (format:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
        :paramtype deployment_scope: str
        :keyword description: Deployment stack description. Max length of 4096 characters.
        :paramtype description: str
        :keyword deny_settings: Defines how resources deployed by the stack are locked.
        :paramtype deny_settings: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenySettings
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.error = error
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.action_on_unmanage = action_on_unmanage
        self.debug_setting = debug_setting
        self.bypass_stack_out_of_sync_error = bypass_stack_out_of_sync_error
        self.deployment_scope = deployment_scope
        self.description = description
        self.deny_settings = deny_settings
        self.provisioning_state = None
        self.correlation_id = None
        self.detached_resources = None
        self.deleted_resources = None
        self.failed_resources = None
        self.resources = None
        self.deployment_id = None
        self.outputs = None
        self.duration = None


class DeploymentStackListResult(_serialization.Model):
    """List of Deployment stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of Deployment stacks.
    :vartype value: list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStack]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeploymentStack]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DeploymentStack"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of Deployment stacks.
        :paramtype value:
         list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStack]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DeploymentStacksError(_serialization.Model):
    """Deployment Stacks error response.

    :ivar error: The error detail.
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error detail.
        :paramtype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class DeploymentStackProperties(DeploymentStacksError):
    """Deployment stack properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar error: The error detail.
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksTemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     Use this element when providing the parameter values directly in the request, rather than
     linking to an existing parameter file. Use either the parametersLink property or the parameters
     property, but not both.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentParameter]
    :ivar parameters_link: The URI of parameters file. Use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksParametersLink
    :ivar action_on_unmanage: Defines the behavior of resources that are no longer managed after
     the Deployment stack is updated or deleted. Required.
    :vartype action_on_unmanage:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ActionOnUnmanage
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDebugSetting
    :ivar bypass_stack_out_of_sync_error: Flag to bypass service errors that indicate the stack
     resource list is not correctly synchronized.
    :vartype bypass_stack_out_of_sync_error: bool
    :ivar deployment_scope: The scope at which the initial deployment should be created. If a scope
     is not specified, it will default to the scope of the deployment stack. Valid scopes are:
     management group (format:
     '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     '/subscriptions/{subscriptionId}'), resource group (format:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
    :vartype deployment_scope: str
    :ivar description: Deployment stack description. Max length of 4096 characters.
    :vartype description: str
    :ivar deny_settings: Defines how resources deployed by the stack are locked. Required.
    :vartype deny_settings: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenySettings
    :ivar provisioning_state: State of the deployment stack. Known values are: "creating",
     "validating", "waiting", "deploying", "canceling", "updatingDenyAssignments",
     "deletingResources", "succeeded", "failed", "canceled", and "deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStackProvisioningState
    :ivar correlation_id: The correlation id of the last Deployment stack upsert or delete
     operation. It is in GUID format and is used for tracing.
    :vartype correlation_id: str
    :ivar detached_resources: An array of resources that were detached during the most recent
     Deployment stack update. Detached means that the resource was removed from the template, but no
     relevant deletion operations were specified. So, the resource still exists while no longer
     being associated with the stack.
    :vartype detached_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceReference]
    :ivar deleted_resources: An array of resources that were deleted during the most recent
     Deployment stack update. Deleted means that the resource was removed from the template and
     relevant deletion operations were specified.
    :vartype deleted_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceReference]
    :ivar failed_resources: An array of resources that failed to reach goal state during the most
     recent update. Each resourceId is accompanied by an error message.
    :vartype failed_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceReferenceExtended]
    :ivar resources: An array of resources currently managed by the deployment stack.
    :vartype resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ManagedResourceReference]
    :ivar deployment_id: The resourceId of the deployment resource created by the deployment stack.
    :vartype deployment_id: str
    :ivar outputs: The outputs of the deployment resource created by the deployment stack.
    :vartype outputs: JSON
    :ivar duration: The duration of the last successful Deployment stack update.
    :vartype duration: str
    """

    _validation = {
        "action_on_unmanage": {"required": True},
        "description": {"max_length": 4096},
        "deny_settings": {"required": True},
        "provisioning_state": {"readonly": True},
        "correlation_id": {"readonly": True},
        "detached_resources": {"readonly": True},
        "deleted_resources": {"readonly": True},
        "failed_resources": {"readonly": True},
        "resources": {"readonly": True},
        "deployment_id": {"readonly": True},
        "outputs": {"readonly": True},
        "duration": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "template": {"key": "template", "type": "object"},
        "template_link": {"key": "templateLink", "type": "DeploymentStacksTemplateLink"},
        "parameters": {"key": "parameters", "type": "{DeploymentParameter}"},
        "parameters_link": {"key": "parametersLink", "type": "DeploymentStacksParametersLink"},
        "action_on_unmanage": {"key": "actionOnUnmanage", "type": "ActionOnUnmanage"},
        "debug_setting": {"key": "debugSetting", "type": "DeploymentStacksDebugSetting"},
        "bypass_stack_out_of_sync_error": {"key": "bypassStackOutOfSyncError", "type": "bool"},
        "deployment_scope": {"key": "deploymentScope", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "deny_settings": {"key": "denySettings", "type": "DenySettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "detached_resources": {"key": "detachedResources", "type": "[ResourceReference]"},
        "deleted_resources": {"key": "deletedResources", "type": "[ResourceReference]"},
        "failed_resources": {"key": "failedResources", "type": "[ResourceReferenceExtended]"},
        "resources": {"key": "resources", "type": "[ManagedResourceReference]"},
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "outputs": {"key": "outputs", "type": "object"},
        "duration": {"key": "duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_on_unmanage: "_models.ActionOnUnmanage",
        deny_settings: "_models.DenySettings",
        error: Optional["_models.ErrorDetail"] = None,
        template: Optional[JSON] = None,
        template_link: Optional["_models.DeploymentStacksTemplateLink"] = None,
        parameters: Optional[Dict[str, "_models.DeploymentParameter"]] = None,
        parameters_link: Optional["_models.DeploymentStacksParametersLink"] = None,
        debug_setting: Optional["_models.DeploymentStacksDebugSetting"] = None,
        bypass_stack_out_of_sync_error: Optional[bool] = None,
        deployment_scope: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: The error detail.
        :paramtype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksTemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. Use this element when providing the parameter values directly in the request, rather
         than linking to an existing parameter file. Use either the parametersLink property or the
         parameters property, but not both.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentParameter]
        :keyword parameters_link: The URI of parameters file. Use this element to link to an existing
         parameters file. Use either the parametersLink property or the parameters property, but not
         both.
        :paramtype parameters_link:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksParametersLink
        :keyword action_on_unmanage: Defines the behavior of resources that are no longer managed after
         the Deployment stack is updated or deleted. Required.
        :paramtype action_on_unmanage:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ActionOnUnmanage
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksDebugSetting
        :keyword bypass_stack_out_of_sync_error: Flag to bypass service errors that indicate the stack
         resource list is not correctly synchronized.
        :paramtype bypass_stack_out_of_sync_error: bool
        :keyword deployment_scope: The scope at which the initial deployment should be created. If a
         scope is not specified, it will default to the scope of the deployment stack. Valid scopes are:
         management group (format:
         '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
         '/subscriptions/{subscriptionId}'), resource group (format:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
        :paramtype deployment_scope: str
        :keyword description: Deployment stack description. Max length of 4096 characters.
        :paramtype description: str
        :keyword deny_settings: Defines how resources deployed by the stack are locked. Required.
        :paramtype deny_settings: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenySettings
        """
        super().__init__(error=error, **kwargs)
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.action_on_unmanage = action_on_unmanage
        self.debug_setting = debug_setting
        self.bypass_stack_out_of_sync_error = bypass_stack_out_of_sync_error
        self.deployment_scope = deployment_scope
        self.description = description
        self.deny_settings = deny_settings
        self.provisioning_state = None
        self.correlation_id = None
        self.detached_resources = None
        self.deleted_resources = None
        self.failed_resources = None
        self.resources = None
        self.deployment_id = None
        self.outputs = None
        self.duration = None


class DeploymentStacksDebugSetting(_serialization.Model):
    """The debug setting.

    :ivar detail_level: Specifies the type of information to log for debugging. The permitted
     values are none, requestContent, responseContent, or both requestContent and responseContent
     separated by a comma. The default is none. When setting this value, carefully consider the type
     of information that is being passed in during deployment. By logging information about the
     request or response, sensitive data that is retrieved through the deployment operations could
     potentially be exposed.
    :vartype detail_level: str
    """

    _attribute_map = {
        "detail_level": {"key": "detailLevel", "type": "str"},
    }

    def __init__(self, *, detail_level: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword detail_level: Specifies the type of information to log for debugging. The permitted
         values are none, requestContent, responseContent, or both requestContent and responseContent
         separated by a comma. The default is none. When setting this value, carefully consider the type
         of information that is being passed in during deployment. By logging information about the
         request or response, sensitive data that is retrieved through the deployment operations could
         potentially be exposed.
        :paramtype detail_level: str
        """
        super().__init__(**kwargs)
        self.detail_level = detail_level


class DeploymentStacksParametersLink(_serialization.Model):
    """Entity representing the reference to the deployment parameters.

    All required parameters must be populated in order to send to server.

    :ivar uri: The URI of the parameters file. Required.
    :vartype uri: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    """

    _validation = {
        "uri": {"required": True},
    }

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
    }

    def __init__(self, *, uri: str, content_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: The URI of the parameters file. Required.
        :paramtype uri: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version


class DeploymentStacksTemplateLink(_serialization.Model):
    """Entity representing the reference to the template.

    :ivar uri: The URI of the template to deploy. Use either the uri or id property, but not both.
    :vartype uri: str
    :ivar id: The resourceId of a Template Spec. Use either the id or uri property, but not both.
    :vartype id: str
    :ivar relative_path: The relativePath property can be used to deploy a linked template at a
     location relative to the parent. If the parent template was linked with a TemplateSpec, this
     will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child
     deployment will be a combination of the parent and relativePath URIs.
    :vartype relative_path: str
    :ivar query_string: The query string (for example, a SAS token) to be used with the
     templateLink URI.
    :vartype query_string: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
        "query_string": {"key": "queryString", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        relative_path: Optional[str] = None,
        query_string: Optional[str] = None,
        content_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword uri: The URI of the template to deploy. Use either the uri or id property, but not
         both.
        :paramtype uri: str
        :keyword id: The resourceId of a Template Spec. Use either the id or uri property, but not
         both.
        :paramtype id: str
        :keyword relative_path: The relativePath property can be used to deploy a linked template at a
         location relative to the parent. If the parent template was linked with a TemplateSpec, this
         will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child
         deployment will be a combination of the parent and relativePath URIs.
        :paramtype relative_path: str
        :keyword query_string: The query string (for example, a SAS token) to be used with the
         templateLink URI.
        :paramtype query_string: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.id = id
        self.relative_path = relative_path
        self.query_string = query_string
        self.content_version = content_version


class DeploymentStackTemplateDefinition(_serialization.Model):
    """Export Template specific properties of the Deployment stack.

    :ivar template: The template content. Use this element to pass the template syntax directly in
     the request rather than link to an existing template. It can be a JObject or well-formed JSON
     string. Use either the templateLink property or the template property, but not both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksTemplateLink
    """

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
        "template_link": {"key": "templateLink", "type": "DeploymentStacksTemplateLink"},
    }

    def __init__(
        self,
        *,
        template: Optional[JSON] = None,
        template_link: Optional["_models.DeploymentStacksTemplateLink"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template: The template content. Use this element to pass the template syntax directly
         in the request rather than link to an existing template. It can be a JObject or well-formed
         JSON string. Use either the templateLink property or the template property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksTemplateLink
        """
        super().__init__(**kwargs)
        self.template = template
        self.template_link = template_link


class DeploymentStackValidateProperties(_serialization.Model):
    """The Deployment stack validation result details.

    :ivar action_on_unmanage: Defines the behavior of resources that are no longer managed after
     the Deployment stack is updated or deleted.
    :vartype action_on_unmanage:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ActionOnUnmanage
    :ivar correlation_id: The correlation id of the Deployment stack validate operation. It is in
     GUID format and is used for tracing.
    :vartype correlation_id: str
    :ivar deny_settings: The Deployment stack deny settings.
    :vartype deny_settings: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenySettings
    :ivar deployment_scope: The Deployment stack deployment scope.
    :vartype deployment_scope: str
    :ivar description: The Deployment stack validation description.
    :vartype description: str
    :ivar parameters: Deployment parameters.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentParameter]
    :ivar template_link: The URI of the template.
    :vartype template_link:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksTemplateLink
    :ivar validated_resources: The array of resources that were validated.
    :vartype validated_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceReference]
    """

    _attribute_map = {
        "action_on_unmanage": {"key": "actionOnUnmanage", "type": "ActionOnUnmanage"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "deny_settings": {"key": "denySettings", "type": "DenySettings"},
        "deployment_scope": {"key": "deploymentScope", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{DeploymentParameter}"},
        "template_link": {"key": "templateLink", "type": "DeploymentStacksTemplateLink"},
        "validated_resources": {"key": "validatedResources", "type": "[ResourceReference]"},
    }

    def __init__(
        self,
        *,
        action_on_unmanage: Optional["_models.ActionOnUnmanage"] = None,
        correlation_id: Optional[str] = None,
        deny_settings: Optional["_models.DenySettings"] = None,
        deployment_scope: Optional[str] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.DeploymentParameter"]] = None,
        template_link: Optional["_models.DeploymentStacksTemplateLink"] = None,
        validated_resources: Optional[List["_models.ResourceReference"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_on_unmanage: Defines the behavior of resources that are no longer managed after
         the Deployment stack is updated or deleted.
        :paramtype action_on_unmanage:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ActionOnUnmanage
        :keyword correlation_id: The correlation id of the Deployment stack validate operation. It is
         in GUID format and is used for tracing.
        :paramtype correlation_id: str
        :keyword deny_settings: The Deployment stack deny settings.
        :paramtype deny_settings: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenySettings
        :keyword deployment_scope: The Deployment stack deployment scope.
        :paramtype deployment_scope: str
        :keyword description: The Deployment stack validation description.
        :paramtype description: str
        :keyword parameters: Deployment parameters.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentParameter]
        :keyword template_link: The URI of the template.
        :paramtype template_link:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStacksTemplateLink
        :keyword validated_resources: The array of resources that were validated.
        :paramtype validated_resources:
         list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceReference]
        """
        super().__init__(**kwargs)
        self.action_on_unmanage = action_on_unmanage
        self.correlation_id = correlation_id
        self.deny_settings = deny_settings
        self.deployment_scope = deployment_scope
        self.description = description
        self.parameters = parameters
        self.template_link = template_link
        self.validated_resources = validated_resources


class DeploymentStackValidateResult(AzureResourceBase, DeploymentStacksError):
    """The Deployment stack validation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error detail.
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
    :ivar id: String Id used to locate any resource on Azure.
    :vartype id: str
    :ivar name: Name of this resource.
    :vartype name: str
    :ivar type: Type of this resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.SystemData
    :ivar properties: The validation result details.
    :vartype properties:
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStackValidateProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DeploymentStackValidateProperties"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
        properties: Optional["_models.DeploymentStackValidateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: The error detail.
        :paramtype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
        :keyword properties: The validation result details.
        :paramtype properties:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DeploymentStackValidateProperties
        """
        super().__init__(error=error, **kwargs)
        self.error = error
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class KeyVaultParameterReference(_serialization.Model):
    """Azure Key Vault parameter reference.

    All required parameters must be populated in order to send to server.

    :ivar key_vault: Azure Key Vault reference. Required.
    :vartype key_vault: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.KeyVaultReference
    :ivar secret_name: Azure Key Vault secret name. Required.
    :vartype secret_name: str
    :ivar secret_version: Azure Key Vault secret version.
    :vartype secret_version: str
    """

    _validation = {
        "key_vault": {"required": True},
        "secret_name": {"required": True},
    }

    _attribute_map = {
        "key_vault": {"key": "keyVault", "type": "KeyVaultReference"},
        "secret_name": {"key": "secretName", "type": "str"},
        "secret_version": {"key": "secretVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_vault: "_models.KeyVaultReference",
        secret_name: str,
        secret_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault: Azure Key Vault reference. Required.
        :paramtype key_vault:
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.KeyVaultReference
        :keyword secret_name: Azure Key Vault secret name. Required.
        :paramtype secret_name: str
        :keyword secret_version: Azure Key Vault secret version.
        :paramtype secret_version: str
        """
        super().__init__(**kwargs)
        self.key_vault = key_vault
        self.secret_name = secret_name
        self.secret_version = secret_version


class KeyVaultReference(_serialization.Model):
    """Azure Key Vault reference.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure Key Vault resourceId. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure Key Vault resourceId. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ResourceReference(_serialization.Model):
    """The resourceId model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resourceId of a resource managed by the deployment stack.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class ManagedResourceReference(ResourceReference):
    """The managed resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resourceId of a resource managed by the deployment stack.
    :vartype id: str
    :ivar status: Current management state of the resource in the deployment stack. Known values
     are: "managed", "removeDenyFailed", and "deleteFailed".
    :vartype status: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceStatusMode
    :ivar deny_status: denyAssignment settings applied to the resource. Known values are:
     "denyDelete", "notSupported", "inapplicable", "denyWriteAndDelete", "removedBySystem", and
     "none".
    :vartype deny_status: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenyStatusMode
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "deny_status": {"key": "denyStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ResourceStatusMode"]] = None,
        deny_status: Union[str, "_models.DenyStatusMode"] = "none",
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Current management state of the resource in the deployment stack. Known values
         are: "managed", "removeDenyFailed", and "deleteFailed".
        :paramtype status: str or
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ResourceStatusMode
        :keyword deny_status: denyAssignment settings applied to the resource. Known values are:
         "denyDelete", "notSupported", "inapplicable", "denyWriteAndDelete", "removedBySystem", and
         "none".
        :paramtype deny_status: str or
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.DenyStatusMode
        """
        super().__init__(**kwargs)
        self.status = status
        self.deny_status = deny_status


class ResourceReferenceExtended(ResourceReference, DeploymentStacksError):
    """The resourceId extended model. This is used to document failed resources with a resourceId and
    a corresponding error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error detail.
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
    :ivar id: The resourceId of a resource managed by the deployment stack.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error detail.
        :paramtype error: ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.ErrorDetail
        """
        super().__init__(error=error, **kwargs)
        self.error = error
        self.id = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.resource.deploymentstacks.v2024_03_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
