# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._defender_for_storage_operations import build_create_request, build_get_request

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DefenderForStorageOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.v2022_12_01_preview.aio.SecurityCenter`'s
        :attr:`defender_for_storage` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace_async
    async def get(
        self, resource_id: str, setting_name: Union[str, _models.SettingName], **kwargs: Any
    ) -> _models.DefenderForStorageSetting:
        """Gets the Defender for Storage settings for the specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.v2022_12_01_preview.models.SettingName
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DefenderForStorageSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_12_01_preview.models.DefenderForStorageSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-12-01-preview")
        )
        cls: ClsType[_models.DefenderForStorageSetting] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_id=resource_id,
            setting_name=setting_name,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DefenderForStorageSetting", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}"}

    @overload
    async def create(
        self,
        resource_id: str,
        setting_name: Union[str, _models.SettingName],
        defender_for_storage_setting: _models.DefenderForStorageSetting,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DefenderForStorageSetting:
        """Creates or updates the Defender for Storage settings on a specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.v2022_12_01_preview.models.SettingName
        :param defender_for_storage_setting: Defender for Storage Settings. Required.
        :type defender_for_storage_setting:
         ~azure.mgmt.security.v2022_12_01_preview.models.DefenderForStorageSetting
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DefenderForStorageSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_12_01_preview.models.DefenderForStorageSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_id: str,
        setting_name: Union[str, _models.SettingName],
        defender_for_storage_setting: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DefenderForStorageSetting:
        """Creates or updates the Defender for Storage settings on a specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.v2022_12_01_preview.models.SettingName
        :param defender_for_storage_setting: Defender for Storage Settings. Required.
        :type defender_for_storage_setting: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DefenderForStorageSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_12_01_preview.models.DefenderForStorageSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_id: str,
        setting_name: Union[str, _models.SettingName],
        defender_for_storage_setting: Union[_models.DefenderForStorageSetting, IO],
        **kwargs: Any
    ) -> _models.DefenderForStorageSetting:
        """Creates or updates the Defender for Storage settings on a specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.v2022_12_01_preview.models.SettingName
        :param defender_for_storage_setting: Defender for Storage Settings. Is either a
         DefenderForStorageSetting type or a IO type. Required.
        :type defender_for_storage_setting:
         ~azure.mgmt.security.v2022_12_01_preview.models.DefenderForStorageSetting or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DefenderForStorageSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_12_01_preview.models.DefenderForStorageSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-12-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DefenderForStorageSetting] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(defender_for_storage_setting, (IOBase, bytes)):
            _content = defender_for_storage_setting
        else:
            _json = self._serialize.body(defender_for_storage_setting, "DefenderForStorageSetting")

        request = build_create_request(
            resource_id=resource_id,
            setting_name=setting_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("DefenderForStorageSetting", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("DefenderForStorageSetting", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create.metadata = {"url": "/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}"}
