/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewItem;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemConfigurationTransfer;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemTransfer;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardManagerDialog;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class DashboardListControl
extends Composite
implements DashboardGroupContainer {
    private static final int ITEM_SPACING = 5;
    private final IWorkbenchSite site;
    private final DashboardContainer viewContainer;
    private final List<DashboardViewItem> items = new ArrayList<DashboardViewItem>();
    private final Font boldFont;
    private DashboardViewItem selectedItem;
    private int listRowCount = 1;
    private int listColumnCount = 1;

    public DashboardListControl(IWorkbenchSite site, Composite parent, DashboardContainer viewContainer) {
        super(parent, 0x20000000);
        this.site = site;
        this.viewContainer = viewContainer;
        Font normalFont = this.getFont();
        FontData[] fontData = normalFont.getFontData();
        fontData[0].setHeight(fontData[0].getHeight() + 1);
        fontData[0].setStyle(1);
        this.boldFont = new Font(normalFont.getDevice(), fontData[0]);
        this.addDisposeListener(e -> this.boldFont.dispose());
        this.setForeground(UIStyles.getDefaultTextForeground());
        this.setBackground(UIStyles.getDefaultTextBackground());
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        if (!UIUtils.isInDialog((Control)parent)) {
            this.createIntroItem();
        }
        this.registerContextMenu();
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DashboardListControl.this.setSelection(null);
                DashboardListControl.this.setFocus();
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DashboardListControl.this.handleKeyEvent(e);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DashboardListControl.this.computeGridSize();
                DashboardListControl.this.layout(true, true);
            }
        });
        this.addItemDropSupport();
    }

    private void addItemDropSupport() {
        DropTarget target = new DropTarget((Control)this, 2);
        target.setTransfer(new Transfer[]{DashboardItemTransfer.INSTANCE, DashboardItemConfigurationTransfer.INSTANCE});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2 || event.detail == 1) {
                    if (event.data instanceof DashboardItemConfiguration) {
                        DashboardItemConfiguration itemConfiguration = (DashboardItemConfiguration)event.data;
                        DashboardListControl.this.addItem(itemConfiguration);
                    } else if (event.data instanceof DashboardViewItem) {
                        DashboardViewItem item = (DashboardViewItem)event.data;
                        DashboardListControl.this.addItem(item.getItemConfiguration().getDashboardItem());
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                if (!this.isDropSupported(event)) {
                    event.detail = 0;
                } else if (event.detail == 0) {
                    event.detail = 2;
                }
                event.feedback = 9;
            }

            private boolean isDropSupported(DropTargetEvent event) {
                if (event.dataTypes == null) {
                    return false;
                }
                TransferData[] transferDataArray = event.dataTypes;
                int n = event.dataTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    TransferData td = transferDataArray[n2];
                    if (td.type == DashboardItemConfigurationTransfer.INSTANCE.getSupportedTypes()[0].type || td.type == DashboardItemTransfer.INSTANCE.getSupportedTypes()[0].type) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    private void createIntroItem() {
        Composite intro = UIUtils.createComposite((Composite)this, (int)1);
        Label titleLabel = new Label(intro, 0);
        titleLabel.setFont(this.getTitleFont());
        titleLabel.setText("Customize your dashboard");
        final String addCommandName = ActionUtils.findCommandName((String)"org.jkiss.dbeaver.ui.dashboard.add");
        UIUtils.createLink((Composite)intro, (String)("<a>" + addCommandName + "</a> to this dashboard by drag-n-drop or double-click from the <a>catalog</a> or another dashboard.\nYou can also create new charts in the <a>Configuration</a> dialog.\nFor further information, please refer to the <a>documentation</a>."), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CommonUtils.equalObjects((Object)addCommandName, (Object)e.text)) {
                    ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.dashboard.add", (IServiceLocator)DashboardListControl.this.site);
                } else if (CommonUtils.equalObjects((Object)"catalog", (Object)e.text)) {
                    DashboardListControl.this.viewContainer.showChartCatalog();
                } else if (CommonUtils.equalObjects((Object)"documentation", (Object)e.text)) {
                    ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Dashboards/"));
                } else {
                    new DashboardManagerDialog(UIUtils.getActiveWorkbenchShell()).open();
                }
            }
        });
    }

    public int getListRowCount() {
        return this.listRowCount;
    }

    public int getListColumnCount() {
        return this.listColumnCount;
    }

    private void computeGridSize() {
        int totalItems = this.items.size();
        Point listAreaSize = this.getSize();
        if (listAreaSize.x <= 0 || listAreaSize.y <= 0 || this.items.isEmpty()) {
            return;
        }
        this.listRowCount = 1;
        int rowCount = 1;
        while (rowCount < 50) {
            int itemsPerRow = (int)Math.ceil((float)totalItems / (float)rowCount);
            int itemWidth = listAreaSize.x / itemsPerRow;
            int itemHeight = itemWidth / 3;
            int totalHeight = itemHeight * rowCount;
            if (totalHeight > listAreaSize.y) {
                if (rowCount <= 1) break;
                this.listRowCount = rowCount - 1;
                break;
            }
            ++rowCount;
        }
        ((GridLayout)this.getLayout()).numColumns = this.listColumnCount = (int)Math.ceil((float)totalItems / (float)this.listRowCount);
    }

    void handleKeyEvent(KeyEvent e) {
        switch (e.keyCode) {
            case 13: {
                ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.dashboard.view", (IServiceLocator)this.site);
                break;
            }
            case 127: {
                ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.dashboard.remove", (IServiceLocator)this.site);
                break;
            }
            case 0x1000009: {
                ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.dashboard.add", (IServiceLocator)this.site);
                break;
            }
            case 0x1000001: 
            case 0x1000003: {
                this.moveSelection(-1);
                break;
            }
            case 0x1000002: 
            case 0x1000004: {
                this.moveSelection(1);
            }
        }
    }

    private void moveSelection(int delta) {
        if (this.items.isEmpty()) {
            return;
        }
        if (this.selectedItem == null) {
            this.setSelection(this.items.get(0));
        } else {
            int curIndex = this.items.indexOf(this.selectedItem);
            if ((curIndex += delta) < 0) {
                curIndex = this.items.size() - 1;
            } else if (curIndex >= this.items.size()) {
                curIndex = 0;
            }
            DashboardViewItem newSelection = this.items.get(curIndex);
            newSelection.getDashboardControl().setFocus();
            this.setSelection(newSelection);
            newSelection.redraw();
        }
    }

    private void registerContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.ui.dashboard.add"));
        menuMgr.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.ui.chart.refresh"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("toggleCatalogPanel", "true");
        menuMgr.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.ui.dashboard.catalog.show", params));
        this.setMenu(menuMgr.createContextMenu((Control)this));
        this.addDisposeListener(e -> menuMgr.dispose());
    }

    DBPProject getProject() {
        return this.viewContainer.getViewConfiguration().getProject();
    }

    DBPDataSourceContainer getDataSourceContainer() {
        return this.viewContainer.getDataSourceContainer();
    }

    @Override
    @NotNull
    public DashboardContainer getView() {
        return this.viewContainer;
    }

    @NotNull
    public List<DashboardViewItem> getItems() {
        return this.items;
    }

    @Override
    public void removeItem(@NotNull DashboardItemContainer container) {
        DashboardViewItem item = (DashboardViewItem)container;
        item.dispose();
        this.computeGridSize();
        if (this.items.isEmpty()) {
            this.createIntroItem();
            this.viewContainer.showChartCatalog();
        }
        this.layout(true, true);
        this.viewContainer.getViewConfiguration().removeItem(item.getItemDescriptor().getId());
        this.viewContainer.saveChanges();
    }

    @Override
    public void addItem(@NotNull DashboardItemConfiguration dashboard) {
        if (this.viewContainer.getViewConfiguration().getItemConfig(dashboard.getId()) != null) {
            return;
        }
        if (this.items.isEmpty()) {
            UIUtils.disposeChildControls((Composite)this);
        }
        this.viewContainer.getViewConfiguration().readDashboardItemConfiguration(dashboard);
        new DashboardViewItem(this, dashboard);
        this.viewContainer.saveChanges();
        this.computeGridSize();
        this.layout(true, true);
    }

    @Override
    public void selectItem(DashboardItemContainer item) {
        this.setSelection((DashboardViewItem)item);
        if (item != null) {
            item.getDashboardControl().setFocus();
        }
    }

    void createDefaultDashboards() {
        if (this.viewContainer.getViewConfiguration().isInitDefaultCharts() && this.viewContainer.getDataSourceContainer() != null) {
            List dashboards = DashboardRegistry.getInstance().getDashboardItems(null, (DBPNamedObject)this.viewContainer.getDataSourceContainer(), true);
            for (DashboardItemConfiguration dd : dashboards) {
                this.loadItem(dd);
            }
        }
    }

    public void createDashboardsFromConfiguration() {
        for (DashboardItemViewSettings itemConfig : new ArrayList<DashboardItemViewSettings>(this.viewContainer.getViewConfiguration().getDashboardItemConfigs())) {
            DashboardItemConfiguration dashboard = itemConfig.getItemConfiguration();
            if (dashboard != null) {
                this.loadItem(dashboard);
                continue;
            }
            this.viewContainer.getViewConfiguration().removeItemConfiguration(itemConfig);
        }
    }

    private void loadItem(DashboardItemConfiguration dashboard) {
        if (this.items.isEmpty()) {
            UIUtils.disposeChildControls((Composite)this);
        }
        this.viewContainer.getViewConfiguration().readDashboardItemConfiguration(dashboard);
        new DashboardViewItem(this, dashboard);
    }

    void addItem(DashboardViewItem item) {
        this.addItemMoveSupport(item);
        this.items.add(item);
    }

    void removeItem(DashboardViewItem item) {
        this.items.remove(item);
    }

    public int getItemSpacing() {
        return 5;
    }

    public Font getTitleFont() {
        return this.boldFont;
    }

    public DashboardViewItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelection(DashboardViewItem selection) {
        DashboardViewItem oldSelection = this.selectedItem;
        if (oldSelection == selection) {
            return;
        }
        this.selectedItem = selection;
        if (selection != null && !selection.isDisposed()) {
            selection.redraw();
        }
        if (oldSelection != null && !oldSelection.isDisposed()) {
            oldSelection.redraw();
        }
        this.viewContainer.updateSelection();
    }

    public void clear() {
        this.selectedItem = null;
        for (DashboardViewItem item : List.copyOf(this.items)) {
            item.dispose();
        }
        this.items.clear();
        this.getView().getViewConfiguration().clearItems();
    }

    private void addItemMoveSupport(DashboardViewItem item) {
        Label dndControl = item.getTitleLabel();
        DragSource source = new DragSource((Control)dndControl, 3);
        source.setTransfer(new Transfer[]{DashboardItemTransfer.INSTANCE});
        source.addDragListener(new DragSourceListener(){
            private Image dragImage;
            private long lastDragEndTime;

            public void dragStart(DragSourceEvent event) {
                if (DashboardListControl.this.selectedItem == null || this.lastDragEndTime > 0L && System.currentTimeMillis() - this.lastDragEndTime < 100L) {
                    event.doit = false;
                } else {
                    Rectangle columnBounds = DashboardListControl.this.selectedItem.getBounds();
                    if (this.dragImage != null) {
                        this.dragImage.dispose();
                        this.dragImage = null;
                    }
                    GC gc = new GC((Drawable)DashboardListControl.this);
                    this.dragImage = new Image((Device)Display.getCurrent(), columnBounds.width, columnBounds.height);
                    gc.copyArea(this.dragImage, columnBounds.x, columnBounds.y);
                    event.image = this.dragImage;
                    gc.dispose();
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (DashboardListControl.this.selectedItem != null && DashboardItemTransfer.INSTANCE.isSupportedType(event.dataType)) {
                    event.data = DashboardListControl.this.selectedItem;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (this.dragImage != null) {
                    UIUtils.dispose((Resource)this.dragImage);
                    this.dragImage = null;
                }
                this.lastDragEndTime = System.currentTimeMillis();
            }
        });
        this.addItemViewDropSupport((Control)dndControl, 3);
        this.addItemViewDropSupport((Control)item.getDashboardControl(), 3);
    }

    private void addItemViewDropSupport(Control dndControl, int operations) {
        DropTarget dropTarget = new DropTarget(dndControl, operations);
        dropTarget.setTransfer(new Transfer[]{DashboardItemTransfer.INSTANCE, DashboardItemConfigurationTransfer.INSTANCE});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2) {
                    if (event.data instanceof DashboardViewItem) {
                        UIUtils.asyncExec(() -> this.moveDashboard(event));
                    } else if (event.data instanceof DashboardItemConfiguration) {
                        DashboardItemConfiguration item = (DashboardItemConfiguration)event.data;
                        UIUtils.asyncExec(() -> DashboardListControl.this.addItem(item));
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                event.detail = !this.isDropSupported(event) ? 0 : 2;
                event.feedback = 9;
            }

            private boolean isDropSupported(DropTargetEvent event) {
                DashboardViewItem overItem = this.getOverItem(event);
                return DashboardListControl.this.selectedItem != null && overItem != null;
            }

            private void moveDashboard(DropTargetEvent event) {
                DashboardViewItem overItem = this.getOverItem(event);
                if (DashboardListControl.this.selectedItem == null || overItem == null || DashboardListControl.this.selectedItem == overItem) {
                    return;
                }
                ArrayList<DashboardViewItem> newList = new ArrayList<DashboardViewItem>(DashboardListControl.this.items);
                int newIndex = newList.indexOf(overItem);
                newList.remove(DashboardListControl.this.selectedItem);
                newList.add(newIndex, DashboardListControl.this.selectedItem);
                DashboardConfiguration viewConfiguration = DashboardListControl.this.viewContainer.getViewConfiguration();
                DashboardListControl.this.setRedraw(false);
                try {
                    DashboardListControl.this.selectedItem = null;
                    DashboardListControl.this.items.clear();
                    int i = 0;
                    while (i < newList.size()) {
                        DashboardViewItem oldItem = (DashboardViewItem)newList.get(i);
                        DashboardViewItem newItem = new DashboardViewItem(DashboardListControl.this, oldItem.getItemDescriptor());
                        DashboardItemViewSettings dashboardConfig = viewConfiguration.getItemConfig(newItem.getItemDescriptor().getId());
                        dashboardConfig.setIndex(i);
                        newItem.moveViewFrom(oldItem, true);
                        ++i;
                    }
                    for (DashboardViewItem item : newList) {
                        item.dispose();
                    }
                }
                finally {
                    DashboardListControl.this.layout(true, true);
                    DashboardListControl.this.setRedraw(true);
                }
                DashboardListControl.this.viewContainer.saveChanges();
            }

            private DashboardViewItem getOverItem(DropTargetEvent event) {
                Object source = event.getSource();
                if (source instanceof DropTarget) {
                    Control control = ((DropTarget)source).getControl();
                    Composite parent = control.getParent();
                    while (parent != null) {
                        if (parent instanceof DashboardViewItem) {
                            return (DashboardViewItem)parent;
                        }
                        parent = parent.getParent();
                    }
                }
                return null;
            }
        });
    }

    public void showItem(DashboardItemContainer item) {
    }
}

