/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import org.freeplane.features.encrypt.EncryptionController;
import org.freeplane.features.encrypt.mindmapmode.MEncryptionController;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.explorer.mindmapmode.MMapExplorerController;
import org.freeplane.features.layout.LayoutController;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.text.TextController;
import org.freeplane.plugin.script.ScriptContext;

public abstract class AbstractProxy<T> {
    private static final String DEFAULT_CLASS_NAME_ENDING = "Proxy";
    private final T delegate;
    private final ScriptContext scriptContext;

    AbstractProxy(T delegate, ScriptContext scriptContext) {
        this.delegate = delegate;
        this.scriptContext = scriptContext;
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.delegate.equals(((AbstractProxy)obj).getDelegate());
    }

    public T getDelegate() {
        return this.delegate;
    }

    public ScriptContext getScriptContext() {
        return this.scriptContext;
    }

    public MModeController getModeController() {
        return MModeController.getMModeController();
    }

    public MEncryptionController getEncryptionController() {
        return (MEncryptionController)this.getModeController().getExtension(EncryptionController.class);
    }

    public LocationController getLocationController() {
        return LocationController.getController((ModeController)this.getModeController());
    }

    public MMapExplorerController getExplorer() {
        return (MMapExplorerController)this.getModeController().getExtension(MapExplorerController.class);
    }

    public LayoutController getLayoutController() {
        return LayoutController.getController((ModeController)this.getModeController());
    }

    public NoteController getNoteController() {
        return (NoteController)this.getModeController().getExtension(NoteController.class);
    }

    public FreeNode getFreeNodeHook() {
        return (FreeNode)this.getModeController().getExtension(FreeNode.class);
    }

    public TextController getTextController() {
        return TextController.getController((ModeController)this.getModeController());
    }

    public MapClipboardController getClipboardController() {
        return (MapClipboardController)this.getModeController().getExtension(MapClipboardController.class);
    }

    public int hashCode() {
        return this.delegate.hashCode() * 31 + this.getClass().hashCode();
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        String className = simpleName.endsWith(DEFAULT_CLASS_NAME_ENDING) ? simpleName.substring(0, simpleName.length() - DEFAULT_CLASS_NAME_ENDING.length()) : simpleName;
        return '(' + className + ") " + this.delegate.toString();
    }
}

