/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class LongPacker {
    private LongPacker() {
    }

    public static int packLong(DataOutput os, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        int i = 1;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            os.write((int)value & 0x7F | 0x80);
            value >>>= 7;
            ++i;
        }
        os.write((byte)value);
        return i;
    }

    public static int packLong(byte[] ba, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        int i = 1;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            ba[i - 1] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
            ++i;
        }
        ba[i - 1] = (byte)value;
        return i;
    }

    public static long unpackLong(DataInput is) throws IOException {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = is.readUnsignedByte();
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed long.");
    }

    public static long unpackLong(byte[] ba) {
        return LongPacker.unpackLong(ba, 0);
    }

    public static long unpackLong(byte[] ba, int index) {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = ba[index++];
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed long.");
    }

    public static int packInt(DataOutput os, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        int i = 1;
        while ((value & 0xFFFFFF80) != 0) {
            os.write(value & 0x7F | 0x80);
            value >>>= 7;
            ++i;
        }
        os.write((byte)value);
        return i;
    }

    public static int unpackInt(DataInput is) throws IOException {
        int result = 0;
        for (int offset = 0; offset < 32; offset += 7) {
            int b = is.readUnsignedByte();
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new Error("Malformed integer.");
    }

    public static int unpackInt(ByteBuffer bb) throws IOException {
        int result = 0;
        for (int offset = 0; offset < 32; offset += 7) {
            int b = bb.get() & 0xFFFF;
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new Error("Malformed integer.");
    }
}

