/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.awt.PaintUtils;
import com.bric.swing.ColorPicker;
import com.bric.swing.ImageTransferable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ColorSwatch
extends JPanel {
    private static final long serialVersionUID = 1L;
    JPopupMenu menu;
    JMenuItem copyItem;
    MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (ColorSwatch.this.menu == null) {
                    ColorSwatch.this.menu = new JPopupMenu();
                    ColorSwatch.this.copyItem = new JMenuItem(ColorPicker.strings.getObject("Copy").toString());
                    ColorSwatch.this.menu.add(ColorSwatch.this.copyItem);
                    ColorSwatch.this.copyItem.addActionListener(ColorSwatch.this.actionListener);
                }
                ColorSwatch.this.menu.show(ColorSwatch.this, e.getX(), e.getY());
            }
        }
    };
    ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == ColorSwatch.this.copyItem) {
                BufferedImage image = new BufferedImage(100, 100, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(ColorSwatch.this.getBackground());
                g.fillRect(0, 0, image.getWidth(), image.getHeight());
                g.dispose();
                ImageTransferable contents = new ImageTransferable(image);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
            }
        }
    };
    int w;
    private static TexturePaint checkerPaint = null;

    public ColorSwatch(int width) {
        this.w = width;
        this.setPreferredSize(new Dimension(width, width));
        this.setMinimumSize(new Dimension(width, width));
        this.addMouseListener(this.mouseListener);
    }

    private static TexturePaint getCheckerPaint() {
        if (checkerPaint == null) {
            int t = 8;
            BufferedImage bi = new BufferedImage(t * 2, t * 2, 1);
            Graphics2D g = bi.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, 2 * t, 2 * t);
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, t, t);
            g.fillRect(t, t, t, t);
            checkerPaint = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
        }
        return checkerPaint;
    }

    @Override
    public void paint(Graphics g0) {
        super.paint(g0);
        Graphics2D g = (Graphics2D)g0;
        Color c = this.getForeground();
        int w2 = Math.min(this.getWidth(), this.w);
        int h2 = Math.min(this.getHeight(), this.w);
        Rectangle r = new Rectangle(this.getWidth() / 2 - w2 / 2, this.getHeight() / 2 - h2 / 2, w2, h2);
        if (c.getAlpha() < 255) {
            TexturePaint checkers = ColorSwatch.getCheckerPaint();
            g.setPaint(checkers);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        g.setColor(c);
        g.fillRect(r.x, r.y, r.width, r.height);
        PaintUtils.drawBevel(g, r);
    }
}

