/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.HorizontalAlignment;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonComponentUI;

public class BasicRibbonComponentUI
extends RibbonComponentUI {
    protected JRibbonComponent ribbonComponent;
    protected JLabel captionLabel;
    protected PropertyChangeListener propertyChangeListener;
    protected ResizableIcon disabledIcon;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonComponentUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.ribbonComponent = (JRibbonComponent)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
    }

    protected void installDefaults() {
        ResizableIcon icon;
        if (!this.ribbonComponent.isSimpleWrapper() && (icon = this.ribbonComponent.getIcon()) != null) {
            icon.setDimension(new Dimension(16, 16));
            this.disabledIcon = this.createDisabledIcon();
        }
        this.ribbonComponent.getMainComponent().setOpaque(false);
        this.ribbonComponent.setOpaque(false);
    }

    protected void installComponents() {
        this.captionLabel = new JLabel(this.ribbonComponent.getCaption());
        this.captionLabel.setEnabled(this.ribbonComponent.isEnabled());
        this.ribbonComponent.add(this.captionLabel);
        JComponent mainComponent = this.ribbonComponent.getMainComponent();
        this.ribbonComponent.add(mainComponent);
    }

    protected void installListeners() {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    boolean isEnabled = (Boolean)evt.getNewValue();
                    BasicRibbonComponentUI.this.ribbonComponent.getMainComponent().setEnabled(isEnabled);
                    if (!BasicRibbonComponentUI.this.ribbonComponent.isSimpleWrapper()) {
                        BasicRibbonComponentUI.this.captionLabel.setEnabled(isEnabled);
                    }
                    BasicRibbonComponentUI.this.ribbonComponent.repaint();
                }
                if ("caption".equals(evt.getPropertyName())) {
                    BasicRibbonComponentUI.this.captionLabel.setText((String)evt.getNewValue());
                }
                if ("displayPriority".equals(evt.getPropertyName())) {
                    BasicRibbonComponentUI.this.ribbonComponent.revalidate();
                    BasicRibbonComponentUI.this.ribbonComponent.doLayout();
                }
            }
        };
        this.ribbonComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
        JComponent mainComponent = this.ribbonComponent.getMainComponent();
        this.ribbonComponent.remove(mainComponent);
        this.ribbonComponent.remove(this.captionLabel);
        this.captionLabel = null;
    }

    protected void uninstallListeners() {
        this.ribbonComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    public Point getKeyTipAnchorCenterPoint() {
        if (this.ribbonComponent.isSimpleWrapper()) {
            return new Point(this.ribbonComponent.getMainComponent().getX() + 10, this.ribbonComponent.getHeight());
        }
        return new Point(this.captionLabel.getX(), this.ribbonComponent.getHeight());
    }

    protected LayoutManager createLayoutManager() {
        return new ExtComponentLayout();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JRibbonComponent ribbonComp = (JRibbonComponent)c;
        if (this.isIconVisible(this.ribbonComponent.getDisplayPriority())) {
            ResizableIcon icon;
            Insets ins = ribbonComp.getInsets();
            ResizableIcon resizableIcon = icon = ribbonComp.isEnabled() ? ribbonComp.getIcon() : this.disabledIcon;
            if (icon != null) {
                int availableHeight = ribbonComp.getHeight() - ins.top - ins.bottom;
                int iconY = Math.max(0, ins.top + (availableHeight - icon.getIconHeight()) / 2);
                if (ribbonComp.getComponentOrientation().isLeftToRight()) {
                    this.paintIcon(g, ribbonComp, icon, ins.left, iconY);
                } else {
                    this.paintIcon(g, ribbonComp, icon, ribbonComp.getWidth() - ins.right - icon.getIconWidth(), iconY);
                }
            }
        }
    }

    protected void paintIcon(Graphics g, JRibbonComponent ribbonComp, Icon icon, int x, int y) {
        icon.paintIcon(ribbonComp, g, x, y);
    }

    protected int getLayoutGap() {
        return 4;
    }

    protected ResizableIcon createDisabledIcon() {
        return new FilteredResizableIcon(this.ribbonComponent.getIcon(), new ColorConvertOp(ColorSpace.getInstance(1003), null));
    }

    protected boolean isIconVisible(RibbonElementPriority displayPriority) {
        if (this.ribbonComponent.isSimpleWrapper()) {
            return false;
        }
        return displayPriority == RibbonElementPriority.TOP || displayPriority == RibbonElementPriority.MEDIUM;
    }

    protected boolean isCaptionVisible(RibbonElementPriority displayPriority) {
        if (this.ribbonComponent.isSimpleWrapper()) {
            return false;
        }
        return displayPriority == RibbonElementPriority.TOP;
    }

    @Override
    public Dimension getPreferredSize(RibbonElementPriority priority) {
        ResizableIcon icon;
        Insets ins = this.ribbonComponent.getInsets();
        JComponent mainComponent = this.ribbonComponent.getMainComponent();
        Dimension prefMain = mainComponent.getPreferredSize();
        int width = ins.left;
        int height = prefMain.height;
        if (this.isIconVisible(priority) && (icon = this.ribbonComponent.getIcon()) != null) {
            width += icon.getIconWidth() + this.getLayoutGap();
            height = Math.max(height, icon.getIconHeight());
        }
        if (this.isCaptionVisible(priority)) {
            Dimension prefCaption = this.captionLabel.getPreferredSize();
            width += prefCaption.width + this.getLayoutGap();
            height = Math.max(height, prefCaption.height);
        }
        width += prefMain.width;
        return new Dimension(width += ins.right, height += ins.top + ins.bottom);
    }

    protected class ExtComponentLayout
    implements LayoutManager {
        protected ExtComponentLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            ResizableIcon icon;
            Insets ins = BasicRibbonComponentUI.this.ribbonComponent.getInsets();
            JComponent mainComponent = BasicRibbonComponentUI.this.ribbonComponent.getMainComponent();
            Dimension minMain = mainComponent.getMinimumSize();
            int width = ins.left;
            int height = minMain.height;
            if (BasicRibbonComponentUI.this.isIconVisible(BasicRibbonComponentUI.this.ribbonComponent.getDisplayPriority()) && (icon = BasicRibbonComponentUI.this.ribbonComponent.getIcon()) != null) {
                width += icon.getIconWidth() + BasicRibbonComponentUI.this.getLayoutGap();
                height = Math.max(height, icon.getIconHeight());
            }
            if (BasicRibbonComponentUI.this.isCaptionVisible(BasicRibbonComponentUI.this.ribbonComponent.getDisplayPriority())) {
                Dimension minCaption = BasicRibbonComponentUI.this.captionLabel.getMinimumSize();
                width += minCaption.width + BasicRibbonComponentUI.this.getLayoutGap();
                height = Math.max(height, minCaption.height);
            }
            width += minMain.width;
            return new Dimension(width += ins.right, height += ins.top + ins.bottom);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return BasicRibbonComponentUI.this.getPreferredSize(BasicRibbonComponentUI.this.ribbonComponent.getDisplayPriority());
        }

        @Override
        public void layoutContainer(Container parent) {
            JRibbonComponent ribbonComp = (JRibbonComponent)parent;
            Insets ins = ribbonComp.getInsets();
            int gap = BasicRibbonComponentUI.this.getLayoutGap();
            int availableHeight = ribbonComp.getHeight() - ins.top - ins.bottom;
            int availableWidth = ribbonComp.getWidth() - ins.left - ins.right;
            HorizontalAlignment horizAlignment = ribbonComp.getHorizontalAlignment();
            JComponent mainComp = ribbonComp.getMainComponent();
            Dimension prefMainDim = mainComp.getPreferredSize();
            int prefMainWidth = prefMainDim.width;
            int finalHeight = Math.min(prefMainDim.height, availableHeight);
            boolean ltr = ribbonComp.getComponentOrientation().isLeftToRight();
            if (ribbonComp.isSimpleWrapper()) {
                int finalMainWidth = Math.min(availableWidth, prefMainWidth);
                int offset = availableWidth - prefMainWidth;
                int topMain = ins.top + (availableHeight - finalHeight) / 2;
                int x = ltr ? ins.left : ribbonComp.getWidth() - ins.right;
                switch (horizAlignment) {
                    case LEADING: {
                        if (ltr) {
                            mainComp.setBounds(x, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case TRAILING: {
                        if (ltr) {
                            mainComp.setBounds(x + offset, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth - offset, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case CENTER: {
                        if (ltr) {
                            mainComp.setBounds(x + offset / 2, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth - offset / 2, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case FILL: {
                        if (ltr) {
                            mainComp.setBounds(x, topMain, availableWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - availableWidth, topMain, availableWidth, finalHeight);
                    }
                }
                mainComp.doLayout();
            } else {
                int x;
                int n = x = ltr ? ins.left : ribbonComp.getWidth() - ins.right;
                if (BasicRibbonComponentUI.this.isIconVisible(BasicRibbonComponentUI.this.ribbonComponent.getDisplayPriority()) && ribbonComp.getIcon() != null) {
                    int iconW = ribbonComp.getIcon().getIconWidth();
                    int n2 = x = ltr ? x + iconW + gap : x - iconW - gap;
                }
                if (BasicRibbonComponentUI.this.isCaptionVisible(BasicRibbonComponentUI.this.ribbonComponent.getDisplayPriority())) {
                    BasicRibbonComponentUI.this.captionLabel.setVisible(true);
                    Dimension prefCaptionDim = BasicRibbonComponentUI.this.captionLabel.getPreferredSize();
                    if (ltr) {
                        BasicRibbonComponentUI.this.captionLabel.setBounds(x, ins.top + (availableHeight - prefCaptionDim.height) / 2, prefCaptionDim.width, prefCaptionDim.height);
                        x += prefCaptionDim.width + gap;
                    } else {
                        BasicRibbonComponentUI.this.captionLabel.setBounds(x - prefCaptionDim.width, ins.top + (availableHeight - prefCaptionDim.height) / 2, prefCaptionDim.width, prefCaptionDim.height);
                        x -= prefCaptionDim.width + gap;
                    }
                } else {
                    BasicRibbonComponentUI.this.captionLabel.setVisible(false);
                }
                int topMain = ins.top + (availableHeight - finalHeight) / 2;
                int finalMainWidth = ltr ? Math.min(ribbonComp.getWidth() - ins.right - x, prefMainWidth) : Math.min(x - ins.left, prefMainWidth);
                int offset = ltr ? ribbonComp.getWidth() - ins.right - x - prefMainWidth : x - prefMainWidth - ins.left;
                switch (horizAlignment) {
                    case LEADING: {
                        if (ltr) {
                            mainComp.setBounds(x, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case TRAILING: {
                        if (ltr) {
                            mainComp.setBounds(x + offset, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth - offset, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case CENTER: {
                        if (ltr) {
                            mainComp.setBounds(x + offset / 2, topMain, finalMainWidth, finalHeight);
                            break;
                        }
                        mainComp.setBounds(x - finalMainWidth - offset / 2, topMain, finalMainWidth, finalHeight);
                        break;
                    }
                    case FILL: {
                        if (ltr) {
                            mainComp.setBounds(x, topMain, ribbonComp.getWidth() - ins.right - x, finalHeight);
                            break;
                        }
                        mainComp.setBounds(ins.left, topMain, x - ins.left, finalHeight);
                    }
                }
                mainComp.doLayout();
            }
        }
    }
}

