/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.ArchiveResources;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.NbInstrumentation;
import org.netbeans.NetigsoLoader;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.modules.ModuleInfo;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public abstract class NetigsoFramework {
    private ModuleManager mgr;

    protected NetigsoFramework() {
        if (!this.getClass().getName().equals("org.netbeans.core.netigso.Netigso")) {
            throw new IllegalStateException();
        }
    }

    final NetigsoFramework bindTo(ModuleManager mgr) {
        try {
            NetigsoFramework nf = (NetigsoFramework)this.clone();
            assert (nf != this);
            nf.mgr = mgr;
            return nf;
        }
        catch (CloneNotSupportedException ex) {
            Util.err.log(Level.INFO, null, ex);
            this.mgr = mgr;
            return this;
        }
    }

    protected abstract void prepare(Lookup var1, Collection<? extends Module> var2);

    protected abstract Set<String> start(Collection<? extends Module> var1);

    protected abstract void start();

    protected abstract void shutdown();

    protected abstract Set<String> createLoader(ModuleInfo var1, ProxyClassLoader var2, File var3) throws IOException;

    protected Enumeration<URL> findResources(Module module, String resName) {
        return Enumerations.empty();
    }

    protected abstract void reload(Module var1) throws IOException;

    protected abstract void stopLoader(ModuleInfo var1, ClassLoader var2);

    protected ClassLoader findFrameworkClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected int defaultStartLevel() {
        return 0;
    }

    protected final byte[] fromArchive(ArchiveResources resources, String name) throws IOException {
        return JarClassLoader.archive.getData(resources, name);
    }

    protected final ClassLoader createClassLoader(String cnb) {
        Module m = this.findModule(cnb);
        return m == null ? null : new NetigsoLoader(m);
    }

    protected final Module findModule(String cnb) {
        return this.mgr.get(cnb);
    }

    protected final byte[] patchByteCode(ClassLoader l, String className, ProtectionDomain pd, byte[] arr) {
        try {
            return NbInstrumentation.patchByteCode(l, className, null, arr);
        }
        catch (IllegalClassFormatException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

