/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.appearance.AppearanceModelImpl;
import org.gephi.appearance.PartitionImpl;
import org.gephi.appearance.RankingImpl;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.spi.PartitionTransformer;
import org.gephi.appearance.spi.RankingTransformer;
import org.gephi.appearance.spi.SimpleTransformer;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;

public abstract class FunctionImpl
implements Function {
    protected final AppearanceModelImpl model;
    protected final Class<? extends Element> elementClass;
    protected final String name;
    protected final Column column;
    protected final Transformer transformer;
    protected final TransformerUI transformerUI;
    protected final PartitionImpl partition;
    protected final RankingImpl ranking;
    protected final AtomicInteger version;
    protected WeakReference<Graph> lastGraph;
    protected boolean lastTransformNullValues;

    protected FunctionImpl(AppearanceModelImpl model, String name, Class<? extends Element> elementClass, Column column, Transformer transformer, TransformerUI transformerUI, PartitionImpl partition, RankingImpl ranking) {
        if (name == null) {
            throw new NullPointerException("The name can't be null");
        }
        this.model = model;
        this.name = name;
        this.elementClass = elementClass;
        this.column = column;
        try {
            this.transformer = (Transformer)transformer.getClass().newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.transformerUI = transformerUI;
        this.partition = partition;
        this.ranking = ranking;
        this.version = new AtomicInteger(partition != null ? partition.getVersion(model.getPartitionGraph()) : Integer.MIN_VALUE);
        this.lastGraph = partition != null ? new WeakReference<Graph>(model.getPartitionGraph()) : null;
        this.lastTransformNullValues = model.isTransformNullValues();
    }

    @Override
    public void transform(Element element) {
        Graph graph = this.getGraph();
        if (this.isSimple()) {
            ((SimpleTransformer)this.transformer).transform(element);
        } else if (this.isRanking()) {
            this.transformRanking(element, graph, this.ranking.getMinValue(graph), this.ranking.getMaxValue(graph));
        } else if (this.isPartition()) {
            this.transformPartition(element, graph);
        }
    }

    @Override
    public void transformAll(Iterable<? extends Element> elementIterable) {
        Graph graph = this.getGraph();
        if (!graph.getView().isDestroyed()) {
            if (this.isSimple()) {
                elementIterable.forEach(((SimpleTransformer)this.transformer)::transform);
            } else if (this.isRanking()) {
                Number minValue = this.ranking.getMinValue(graph);
                Number maxValue = this.ranking.getMaxValue(graph);
                elementIterable.forEach(e -> this.transformRanking((Element)e, graph, minValue, maxValue));
            } else if (this.isPartition()) {
                elementIterable.forEach(e -> this.transformPartition((Element)e, graph));
            }
        }
    }

    private void transformPartition(Element element, Graph graph) {
        Object val = this.partition.getValue(element, graph);
        if (val != null || this.model.isTransformNullValues()) {
            ((PartitionTransformer)this.transformer).transform(element, this.partition, val);
        }
    }

    private void transformRanking(Element element, Graph graph, Number minValue, Number maxValue) {
        Number val = this.ranking.getValue(element, graph.getModel().getGraphVisible());
        if (val != null) {
            float normalizedValue = this.ranking.normalize(val, this.ranking.getInterpolator(), minValue, maxValue);
            ((RankingTransformer)this.transformer).transform(element, this.ranking, val, normalizedValue);
        } else if (this.model.isTransformNullValues()) {
            ((RankingTransformer)this.transformer).transform(element, this.ranking, null, 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChanged() {
        if (this.isPartition()) {
            Graph graph = this.model.getPartitionGraph();
            boolean viewChanged = false;
            FunctionImpl functionImpl = this;
            synchronized (functionImpl) {
                if (this.lastGraph == null) {
                    this.lastGraph = new WeakReference<Graph>(graph);
                } else {
                    Graph lg = (Graph)this.lastGraph.get();
                    this.lastGraph = null;
                    if (lg == null || lg != graph) {
                        viewChanged = true;
                        this.lastGraph = new WeakReference<Graph>(graph);
                    }
                }
                if (this.lastTransformNullValues != this.model.isTransformNullValues()) {
                    viewChanged = true;
                }
                this.lastTransformNullValues = this.model.isTransformNullValues();
            }
            int newVersion = this.partition.getVersion(graph);
            return this.version.getAndSet(newVersion) != newVersion || viewChanged;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        Graph graph = this.getGraph();
        if (graph.getView().isDestroyed()) {
            return false;
        }
        if (this.isRanking()) {
            return this.ranking.isValid(graph);
        }
        if (this.isPartition()) {
            return this.partition.isValid(graph);
        }
        return true;
    }

    @Override
    public Graph getGraph() {
        if (this.isRanking()) {
            return this.model.getRankingGraph();
        }
        if (this.isPartition()) {
            return this.model.getPartitionGraph();
        }
        return this.model.getGraphModel().getGraph();
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public TransformerUI getUI() {
        return this.transformerUI;
    }

    @Override
    public boolean isSimple() {
        return this.ranking == null && this.partition == null;
    }

    @Override
    public boolean isAttribute() {
        return this.column != null;
    }

    @Override
    public boolean isPartition() {
        return this.partition != null;
    }

    @Override
    public boolean isRanking() {
        return this.ranking != null;
    }

    @Override
    public Class<? extends Element> getElementClass() {
        return this.elementClass;
    }

    @Override
    public AppearanceModelImpl getModel() {
        return this.model;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.name;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionImpl other = (FunctionImpl)obj;
        return Objects.equals(this.name, other.name);
    }
}

