/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import org.gephi.appearance.AttributeRankingImpl;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.TimeIndex;
import org.gephi.graph.api.types.TimeSet;

public class TimesetRankingImpl
extends AttributeRankingImpl {
    public TimesetRankingImpl(Column column) {
        super(column);
    }

    @Override
    public Number getValue(Element element, Graph graph) {
        TimeSet timeSet = (TimeSet)element.getAttribute((Column)this.column.get(), graph.getView());
        if (timeSet != null) {
            return timeSet.getMinDouble();
        }
        return null;
    }

    @Override
    public Number getMinValue(Graph graph) {
        return this.getIndex(graph).getMinTimestamp();
    }

    @Override
    public Number getMaxValue(Graph graph) {
        return this.getIndex(graph).getMaxTimestamp();
    }

    private TimeIndex<? extends Element> getIndex(Graph graph) {
        if (((Column)this.column.get()).getTable().isNodeTable()) {
            return graph.getModel().getNodeTimeIndex(graph.getView());
        }
        return graph.getModel().getEdgeTimeIndex(graph.getView());
    }

    @Override
    public boolean isValid(Graph graph) {
        if (this.column.get() != null) {
            TimeIndex<? extends Element> timeIndex = this.getIndex(graph);
            return timeIndex.getMinTimestamp() != Double.NEGATIVE_INFINITY && timeIndex.getMaxTimestamp() != Double.POSITIVE_INFINITY;
        }
        return false;
    }
}

