/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeWindowedDeserializer<T>
implements Deserializer<Windowed<T>> {
    public static final String WINDOW_SIZE_MS_CONFIG = "window.size.ms";
    public static final String WINDOWED_INNER_DESERIALIZER_CLASS = "windowed.inner.deserializer.class";
    private final Logger log = LoggerFactory.getLogger(TimeWindowedDeserializer.class);
    private Long windowSize;
    private boolean isChangelogTopic;
    private Deserializer<T> inner;

    public TimeWindowedDeserializer() {
        this(null, null);
    }

    public TimeWindowedDeserializer(Deserializer<T> inner, Long windowSize) {
        this.inner = inner;
        this.windowSize = windowSize;
        this.isChangelogTopic = false;
    }

    public Long getWindowSize() {
        return this.windowSize;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configureWindowSizeMs(configs);
        this.configureWindowInnerDeserializerClass(configs);
    }

    public Windowed<T> deserialize(String topic, byte[] data) {
        WindowedSerdes.verifyInnerDeserializerNotNull(this.inner, this);
        if (data == null || data.length == 0) {
            return null;
        }
        if (this.isChangelogTopic) {
            return WindowKeySchema.fromStoreKey(data, this.windowSize, this.inner, topic);
        }
        return WindowKeySchema.from(data, this.windowSize, this.inner, topic);
    }

    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    public void setIsChangelogTopic(boolean isChangelogTopic) {
        this.isChangelogTopic = isChangelogTopic;
    }

    Deserializer<T> innerDeserializer() {
        return this.inner;
    }

    private void configureWindowSizeMs(Map<String, ?> configs) {
        Long configWindowSize = configs.get(WINDOW_SIZE_MS_CONFIG) instanceof String ? Long.valueOf(Long.parseLong((String)configs.get(WINDOW_SIZE_MS_CONFIG))) : (Long)configs.get(WINDOW_SIZE_MS_CONFIG);
        if (this.windowSize != null && configWindowSize != null) {
            throw new IllegalArgumentException("Window size should not be set in both the time windowed deserializer constructor and the window.size.ms config");
        }
        if (this.windowSize == null && configWindowSize == null) {
            throw new IllegalArgumentException("Window size needs to be set either through the time windowed deserializer constructor or the window.size.ms config but not both");
        }
        this.windowSize = this.windowSize == null ? configWindowSize : this.windowSize;
    }

    private void configureWindowInnerDeserializerClass(Map<String, ?> configs) {
        String windowedInnerClassSerdeConfig;
        String deserializerConfigKey = WINDOWED_INNER_DESERIALIZER_CLASS;
        String deserializerConfigValue = (String)configs.get(WINDOWED_INNER_DESERIALIZER_CLASS);
        if (deserializerConfigValue == null && (windowedInnerClassSerdeConfig = (String)configs.get("windowed.inner.class.serde")) != null) {
            deserializerConfigKey = "windowed.inner.class.serde";
            deserializerConfigValue = windowedInnerClassSerdeConfig;
            this.log.warn("Config {} is deprecated. Please use {} instead.", (Object)"windowed.inner.class.serde", (Object)WINDOWED_INNER_DESERIALIZER_CLASS);
        }
        Serde windowedInnerDeserializerClass = null;
        if (deserializerConfigValue != null) {
            try {
                windowedInnerDeserializerClass = (Serde)Utils.newInstance((String)deserializerConfigValue, Serde.class);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(deserializerConfigKey, (Object)deserializerConfigValue, "Serde class " + deserializerConfigValue + " could not be found.");
            }
        }
        if (this.inner != null && deserializerConfigValue != null) {
            if (!this.inner.getClass().getName().equals(windowedInnerDeserializerClass.deserializer().getClass().getName())) {
                throw new IllegalArgumentException("Inner class deserializer set using constructor (" + this.inner.getClass().getName() + ") is different from the one set in " + deserializerConfigKey + " config (" + windowedInnerDeserializerClass.deserializer().getClass().getName() + ").");
            }
        } else {
            if (this.inner == null && deserializerConfigValue == null) {
                throw new IllegalArgumentException("Inner class deserializer should be set either via  constructor or via the windowed.inner.deserializer.class config");
            }
            if (this.inner == null) {
                this.inner = windowedInnerDeserializerClass.deserializer();
            }
        }
    }
}

