! 
!     Copyright (c) 2017, NVIDIA CORPORATION.  All rights reserved.
!
! NVIDIA CORPORATION and its licensors retain all intellectual property
! and proprietary rights in and to this software, related documentation
! and any modifications thereto.  Any use, reproduction, disclosure or
! distribution of this software and related documentation without an express
! license agreement from NVIDIA CORPORATION is strictly prohibited.
! 

!          THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT
!   WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT
!   NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR
!   FITNESS FOR A PARTICULAR PURPOSE.
!
! Fortran interfaces for libm routines that don't have Fortran equivalents
!

module libm

interface acosh
 double precision function acosh(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(acosh)
 real function acoshf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(acoshf)
end interface

interface asinh
 double precision function asinh(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(asinh)
 real function asinhf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(asinhf)
end interface

interface
 real function asinf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(asinf)
end interface

interface
 real function acosf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(acosf)
end interface

interface
 real function atan2f(x,y) bind(c)
  real, value :: x,y
!dir$ ignore_tkr (d) x,y
 end function
!$pragma libm(atan2f)
end interface

interface atanh
 double precision function atanh(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(atanh)
 real function atanhf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(atanhf)
end interface

interface cbrt
 double precision function cbrt(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(cbrt)
 real function cbrtf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(cbrtf)
end interface

interface ceil
 double precision function ceil(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(ceil)
 real function ceilf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(ceilf)
end interface

interface copysign
 double precision function copysign(x,y) bind(c)
  double precision, value :: x, y
!dir$ ignore_tkr (d) x, (d) y
 end function
!$pragma libm(copysign)
 real function copysignf(x,y) bind(c)
  real, value :: x, y
!dir$ ignore_tkr (d) x, (d) y
 end function
!$pragma libm(copysignf)
end interface

interface
 real function cosf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(cosf)
end interface

interface
 real function coshf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(coshf)
end interface

interface erf
 double precision function erf(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(erf)
 real function erff(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(erff)
end interface

interface erfc
 double precision function erfc(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(erfc)
 real function erfcf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(erfcf)
end interface

interface expm1
 double precision function expm1(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(expm1)
 real function expm1f(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(expm1f)
end interface

interface
 real function expf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(expf)
end interface

interface exp10
 double precision function exp10(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(exp10)
 real function exp10f(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(exp10f)
end interface

interface exp2
 double precision function exp2(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(exp2)
 real function exp2f(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(exp2f)
end interface

interface fabs
 double precision function fabs(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(fabs)
 real function fabsf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(fabsf)
end interface

interface floor
 double precision function floor(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(floor)
 real function floorf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(floorf)
end interface

interface fma
 double precision function fma(x,y,z) bind(c)
  double precision, value :: x,y,z
!dir$ ignore_tkr (d) x, (d) y, (d) z
 end function
!$pragma libm(fma)
 real function fmaf(x,y,z) bind(c)
  real, value :: x,y,z
!dir$ ignore_tkr (d) x, (d) y, (d) z
 end function
!$pragma libm(fmaf)
end interface

interface fmax
 double precision function fmax(x,y) bind(c)
  double precision, value :: x,y
!dir$ ignore_tkr (d) x,y
 end function
!$pragma libm(fmax)
 real function fmaxf(x,y) bind(c)
  real, value :: x,y
!dir$ ignore_tkr (d) x,y
 end function
!$pragma libm(fmaxf)
end interface

interface fmin
 double precision function fmin(x,y) bind(c)
  double precision, value :: x,y
!dir$ ignore_tkr (d) x,y
 end function
!$pragma libm(fmin)
 real function fminf(x,y) bind(c)
  real, value :: x,y
!dir$ ignore_tkr (d) x,y
 end function
!$pragma libm(fminf)
end interface

interface frexp
 double precision function frexp(x,y) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
  double precision :: y
!dir$ ignore_tkr (d) y
 end function
!$pragma libm(frexp)
 real function frexpf(x,y) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
  real :: y
!dir$ ignore_tkr (d) y
 end function
!$pragma libm(frexpf)
end interface

interface ilogb
 integer function ilogb(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(ilogb)
 integer function ilogbf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(ilogbf)
end interface

interface ldexp
 double precision function ldexp(x,y) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
  integer, value :: y
!dir$ ignore_tkr (d) y
 end function
!$pragma libm(ldexp)
 real function ldexpf(x,y) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
  integer, value :: y
!dir$ ignore_tkr (d) y
 end function
!$pragma libm(ldexpf)
end interface

interface lgamma
 double precision function lgamma(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(lgamma)
 real function lgammaf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(lgammaf)
end interface

interface llrint
 integer(8) function llrint(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(llrint)
 integer(8) function llrintf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(llrintf)
end interface

interface lrint
 integer function lrint(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(lrint)
 integer function lrintf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(lrintf)
end interface

interface llround
 integer(8) function llround(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(llround)
 integer(8) function llroundf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(llroundf)
end interface

interface lround
 integer function lround(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(lround)
 integer function lroundf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(lroundf)
end interface

interface logb
 double precision function logb(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(logb)
 real function logbf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(logbf)
end interface

interface
 real function log10f(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(log10f)
end interface

interface
 real function logf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(logf)
end interface

interface log1p
 double precision function log1p(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(log1p)
 real function log1pf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(log1pf)
end interface

interface log2
 double precision function log2(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(log2)
 real function log2f(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(log2f)
end interface

interface modf
 double precision function modf(x,y) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
  double precision :: y
!dir$ ignore_tkr (d) y
 end function
!$pragma libm(modf)
 real function modff(x,y) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
  real :: y
!dir$ ignore_tkr (d) y
 end function
!$pragma libm(modff)
end interface

interface nearbyint
 double precision function nearbyint(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(nearbyint)
 real function nearbyintf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(nearbyintf)
end interface

interface nextafter
 double precision function nextafter(x,y) bind(c)
  double precision, value :: x,y
!dir$ ignore_tkr (d) x, (d) y
 end function
!$pragma libm(nextafter)
 real function nextafterf(x,y) bind(c)
  real, value :: x,y
!dir$ ignore_tkr (d) x, (d) y
 end function
!$pragma libm(nextafterf)
end interface

interface pow
 double precision function pow(x,y) bind(c)
  double precision, value :: x,y
!dir$ ignore_tkr (d) x, (d) y
 end function
!$pragma libm(pow)
 real function powf(x,y) bind(c)
  real, value :: x,y
!dir$ ignore_tkr (d) x, (d) y
 end function
!$pragma libm(powf)
end interface

interface remainder
 double precision function remainder(x,y) bind(c)
  double precision, value :: x,y
!dir$ ignore_tkr (d) x, (d) y
 end function
!$pragma libm(remainder)
 real function remainderf(x,y) bind(c)
  real, value :: x,y
!dir$ ignore_tkr (d) x, (d) y
 end function
!$pragma libm(remainderf)
end interface

interface remquo
 double precision function remquo(x,y,i) bind(c)
  double precision, value :: x,y
!dir$ ignore_tkr (d) x, (d) y
  integer :: i
!dir$ ignore_tkr (d) i
 end function
!$pragma libm(remquo)
 real function remquof(x,y,i) bind(c)
  real, value :: x,y
!dir$ ignore_tkr (d) x, (d) y
  integer :: i
!dir$ ignore_tkr (d) i
 end function
!$pragma libm(remquof)
end interface

interface rint
 double precision function rint(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(rint)
 real function rintf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(rintf)
end interface

interface scalbn
 double precision function scalbn(x,n) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
  integer, value :: n
!dir$ ignore_tkr (d) n
 end function
!$pragma libm(scalbn)
 real function scalbnf(x,n) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
  integer, value :: n
!dir$ ignore_tkr (d) n
 end function
!$pragma libm(scalbnf)
 double precision function scalbln(x,n) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
  integer(8), value :: n
!dir$ ignore_tkr (d) n
 end function
!$pragma libm(scalbln)
 real function scalblnf(x,n) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
  integer(8), value :: n
!dir$ ignore_tkr (d) n
 end function
!$pragma libm(scalblnf)
end interface

interface
 real function sinf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(sinf)
end interface

interface
 real function sinhf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(sinhf)
end interface

interface
 real function sqrtf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(sqrtf)
end interface

interface
 real function tanf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(tanf)
end interface

interface
 real function tanhf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(tanhf)
end interface

interface tgamma
 double precision function tgamma(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(tgamma)
 real function tgammaf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(tgammaf)
end interface

interface trunc
 double precision function trunc(x) bind(c)
  double precision, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(trunc)
 real function truncf(x) bind(c)
  real, value :: x
!dir$ ignore_tkr (d) x
 end function
!$pragma libm(truncf)
end interface

end module libm
