/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.TaskOperationFailure;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.tasks.TransportTasksAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.LeaderBulkByScrollTaskState;
import org.opensearch.index.reindex.RethrottleAction;
import org.opensearch.index.reindex.RethrottleRequest;
import org.opensearch.tasks.TaskInfo;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportRethrottleAction
extends TransportTasksAction<BulkByScrollTask, RethrottleRequest, ListTasksResponse, TaskInfo> {
    private final Client client;

    @Inject
    public TransportRethrottleAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/reindex/rethrottle", clusterService, transportService, actionFilters, RethrottleRequest::new, ListTasksResponse::new, TaskInfo::new, "management");
        this.client = client;
    }

    protected void taskOperation(RethrottleRequest request, BulkByScrollTask task, ActionListener<TaskInfo> listener) {
        TransportRethrottleAction.rethrottle(this.logger, this.clusterService.localNode().getId(), this.client, task, request.getRequestsPerSecond(), listener);
    }

    static void rethrottle(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        if (task.isWorker()) {
            TransportRethrottleAction.rethrottleChildTask(logger, localNodeId, task, newRequestsPerSecond, listener);
            return;
        }
        if (task.isLeader()) {
            TransportRethrottleAction.rethrottleParentTask(logger, localNodeId, client, task, newRequestsPerSecond, listener);
            return;
        }
        throw new IllegalArgumentException("task [" + task.getId() + "] has not yet been initialized to the point where it knows how to rethrottle itself");
    }

    private static void rethrottleParentTask(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        LeaderBulkByScrollTaskState leaderState = task.getLeaderState();
        int runningSubtasks = leaderState.runningSliceSubTasks();
        if (runningSubtasks > 0) {
            RethrottleRequest subRequest = new RethrottleRequest();
            subRequest.setRequestsPerSecond(newRequestsPerSecond / (float)runningSubtasks);
            subRequest.setParentTaskId(new TaskId(localNodeId, task.getId()));
            logger.debug("rethrottling children of task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(subRequest.getRequestsPerSecond()));
            client.execute((ActionType)RethrottleAction.INSTANCE, (ActionRequest)subRequest, ActionListener.wrap(r -> {
                r.rethrowFailures("Rethrottle");
                listener.onResponse((Object)task.taskInfoGivenSubtaskInfo(localNodeId, r.getTasks()));
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            logger.debug("children of task [{}] are already finished, nothing to rethrottle", (Object)task.getId());
            listener.onResponse((Object)task.taskInfo(localNodeId, true));
        }
    }

    private static void rethrottleChildTask(Logger logger, String localNodeId, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        logger.debug("rethrottling local task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(newRequestsPerSecond));
        task.getWorkerState().rethrottle(newRequestsPerSecond);
        listener.onResponse((Object)task.taskInfo(localNodeId, true));
    }

    protected ListTasksResponse newResponse(RethrottleRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }
}

