/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.support.BaseMultiValuesSourceFieldConfig;
import org.opensearch.search.aggregations.support.ValueType;

public class MultiTermsValuesSourceConfig
extends BaseMultiValuesSourceFieldConfig {
    private final ValueType userValueTypeHint;
    private final String format;
    private final IncludeExclude includeExclude;
    private static final String NAME = "field_config";
    public static final ParseField FILTER = new ParseField("filter", new String[0]);
    public static final ParserSupplier PARSER = (scriptable, timezoneAware, valueTypeHinted, formatted) -> {
        ObjectParser parser = new ObjectParser(NAME, Builder::new);
        BaseMultiValuesSourceFieldConfig.PARSER.apply((Object)parser, (Object)scriptable, (Object)timezoneAware);
        if (valueTypeHinted.booleanValue()) {
            parser.declareField(Builder::setUserValueTypeHint, p -> ValueType.lenientParse(p.text()), ValueType.VALUE_TYPE, ObjectParser.ValueType.STRING);
        }
        if (formatted.booleanValue()) {
            parser.declareField(Builder::setFormat, XContentParser::text, ParseField.CommonFields.FORMAT, ObjectParser.ValueType.STRING);
        }
        parser.declareField((b, v) -> b.setIncludeExclude(IncludeExclude.merge(b.getIncludeExclude(), v)), IncludeExclude::parseExclude, IncludeExclude.EXCLUDE_FIELD, ObjectParser.ValueType.STRING_ARRAY);
        return parser;
    };

    protected MultiTermsValuesSourceConfig(String fieldName, Object missing, Script script, ZoneId timeZone, ValueType userValueTypeHint, String format, IncludeExclude includeExclude) {
        super(fieldName, missing, script, timeZone);
        this.userValueTypeHint = userValueTypeHint;
        this.format = format;
        this.includeExclude = includeExclude;
    }

    public MultiTermsValuesSourceConfig(StreamInput in) throws IOException {
        super(in);
        this.userValueTypeHint = (ValueType)in.readOptionalWriteable(ValueType::readFromStream);
        this.format = in.readOptionalString();
        this.includeExclude = (IncludeExclude)in.readOptionalWriteable(IncludeExclude::new);
    }

    public ValueType getUserValueTypeHint() {
        return this.userValueTypeHint;
    }

    public String getFormat() {
        return this.format;
    }

    public IncludeExclude getIncludeExclude() {
        return this.includeExclude;
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.userValueTypeHint);
        out.writeOptionalString(this.format);
        out.writeOptionalWriteable((Writeable)this.includeExclude);
    }

    @Override
    public void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.userValueTypeHint != null) {
            builder.field(AggregationBuilder.CommonFields.VALUE_TYPE.getPreferredName(), this.userValueTypeHint.getPreferredName());
        }
        if (this.format != null) {
            builder.field(AggregationBuilder.CommonFields.FORMAT.getPreferredName(), this.format);
        }
        if (this.includeExclude != null) {
            this.includeExclude.toXContent(builder, params);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiTermsValuesSourceConfig that = (MultiTermsValuesSourceConfig)o;
        return Objects.equals((Object)this.userValueTypeHint, (Object)that.userValueTypeHint) && Objects.equals(this.format, that.format) && Objects.equals(this.includeExclude, that.includeExclude);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.userValueTypeHint, this.format, this.includeExclude});
    }

    public static class Builder
    extends BaseMultiValuesSourceFieldConfig.Builder<MultiTermsValuesSourceConfig, Builder> {
        private ValueType userValueTypeHint = null;
        private String format;
        private IncludeExclude includeExclude = null;

        public IncludeExclude getIncludeExclude() {
            return this.includeExclude;
        }

        public Builder setIncludeExclude(IncludeExclude includeExclude) {
            this.includeExclude = includeExclude;
            return this;
        }

        public ValueType getUserValueTypeHint() {
            return this.userValueTypeHint;
        }

        public Builder setUserValueTypeHint(ValueType userValueTypeHint) {
            this.userValueTypeHint = userValueTypeHint;
            return this;
        }

        public String getFormat() {
            return this.format;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        @Override
        public MultiTermsValuesSourceConfig build() {
            if (Strings.isNullOrEmpty((String)this.fieldName) && this.script == null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be null.  Please specify one or the other.");
            }
            return new MultiTermsValuesSourceConfig(this.fieldName, this.missing, this.script, this.timeZone, this.userValueTypeHint, this.format, this.includeExclude);
        }
    }

    public static interface ParserSupplier {
        public ObjectParser<Builder, Void> apply(Boolean var1, Boolean var2, Boolean var3, Boolean var4);
    }
}

