-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- Data source
-- https://forebears.io/poland/surnames
-- https://dane.gov.pl/pl/dataset/219/resource/28021/table?page=1&per_page=20&q=&sort=
-- https://dane.gov.pl/pl/dataset/219/resource/28020/table?page=1&per_page=20&q=&sort=

local CultureName = require './common'

local male = {
	"Antoni",
	"Jan",
	"Aleksander",
	"Jakub",
	"Franciszek",
	"Szymon",
	"Filip",
	"Mikołaj",
	"Leon",
	"Stanisław",
	"Wojciech",
	"Adam",
	"Kacper",
	"Tymon",
	"Nikodem",
	"Marcel",
	"Ignacy",
	"Michał",
	"Wiktor",
	"Igor",
	"Oliwier",
	"Maksymilian",
	"Piotr",
	"Tymoteusz",
	"Miłosz",
	"Oskar",
	"Julian",
	"Bartosz",
	"Dawid",
	"Mateusz",
	"Krzysztof",
	"Gabriel",
	"Karol",
	"Alan",
	"Dominik",
	"Hubert",
	"Tomasz",
	"Maciej",
	"Fabian",
	"Paweł",
	"Natan",
	"Kamil",
	"Borys",
	"Bartłomiej",
	"Artur",
	"Tadeusz",
	"Patryk",
	"Cezary",
	"Kajetan",
	"Kuba",
	"Adrian",
	"Olaf",
	"Henryk",
	"Grzegorz",
	"Sebastian",
	"Daniel",
	"Eryk",
	"Krystian",
	"Witold",
	"Kazimierz",
	"Józef",
	"Rafał",
	"Teodor",
	"Jerzy",
	"Stefan",
	"Tobiasz",
	"Mieszko",
	"Łukasz",
	"Leonard",
	"Emil",
	"Gustaw",
	"Marcin",
	"Damian",
	"Robert",
	"Przemysław",
	"Konstanty",
	"Nataniel",
	"Ryszard",
	"Feliks",
	"Marek",
	"Radek",
	"Konrad",
	"Juliusz",
	"Jeremi",
	"Remigiusz",
	"Florian",
	"Arkadiusz",
	"Albert",
	"Jędrzej",
	"Lucjan",
	"Andrzej",
	"Jacek",
	"Ludwik",
	"Seweryn",
	"Roman",
	"Norbert",
	"Olgierd",
	"Dariusz",
	"Szczepan",
	"Mariusz",
}

local female = {
	"Zuzanna",
	"Julia",
	"Zofia",
	"Hanna",
	"Maja",
	"Lena",
	"Alicja",
	"Oliwia",
	"Laura",
	"Maria",
	"Pola",
	"Amelia",
	"Emilia",
	"Antonina",
	"Wiktoria",
	"Aleksandra",
	"Marcelina",
	"Liliana",
	"Iga",
	"Helena",
	"Klara",
	"Natalia",
	"Michalina",
	"Gabriela",
	"Nadia",
	"Anna",
	"Kornelia",
	"Blanka",
	"Milena",
	"Łucja",
	"Jagoda",
	"Nela",
	"Kaja",
	"Nikola",
	"Martyna",
	"Anastazja",
	"Barbara",
	"Nina",
	"Weronika",
	"Karolina",
	"Agata",
	"Matyldia",
	"Aniela",
	"Magdalena",
	"Róża",
	"Kinga",
	"Rozalia",
	"Sara",
	"Eliza",
	"Adrianna",
	"Joanna",
	"Izabela",
	"Małgorzata",
	"Gaja",
	"Paulina",
	"Aurelia",
	"Marianna",
	"Lidia",
	"Katarzyna",
	"Melania",
	"Marta",
	"Urszula",
	"Malwina",
	"Bianka",
	"Dominika",
	"Ewa",
	"Klaudia",
	"Patrycja",
	"Olga",
	"Apolonia",
	"Ida",
	"Wanda",
	"Daria",
	"Jagna",
	"Dorota",
	"Ada",
	"Diana",
	"Kamila",
	"Marika",
	"Lilia",
	"Elena",
	"Stefania",
	"Luiza",
	"Inga",
	"Dagmara",
	"Jadwiga",
	"Sofia",
	"Roksana",
	"Monika",
	"Agnieszka",
	"Tola",
	"Lara",
	"Jowita",
	"Marlena",
	"Celina",
	"Karina",
	"Justyna",
	"Adela",
	"Lea",
	"Alina",
}

local surname = {
	"Nowak",
	"Kowalski",
	"Lewandowski",
	"Kowalczyk",
	"Kamiński",
	"Zieliński",
	"Szymański",
	"Kozłowski",
	"Jankowski",
	"Wojciechowski",
	"Kwiatkowski",
	"Kaczmarek",
	"Mazur",
	"Krawczyk",
	"Piotrowski",
	"Grabowski",
	"Nowakowski",
	"Pawłowski",
	"Michalski",
	"Adamczyk",
	"Nowicki",
	"Dudek",
	"Zając",
	"Wieczorek",
	"Majewski",
	"Jabłoński",
	"Olszewski",
	"Jaworski",
	"Pawlak",
	"Malinowski",
	"Walczak",
	"Witkowski",
	"Rutkowski",
	"Michalak",
	"Sikora",
	"Ostrowski",
	"Baran",
	"Szewczyk",
	"Duda",
	"Tomaszewski",
	"Pietrzak",
	"Marciniak",
	"Zalewski",
	"Jakubowski",
	"Zawadzki",
	"Jasiński",
	"Sadowski",
	"Chmielewski",
	"Borkowski",
	"Czarnecki",
	"Sawicki",
	"Kubiak",
	"Sokołowski",
	"Maciejewski",
	"Urbański",
	"Kucharski",
	"Szczepański",
	"Wilk",
	"Lis",
	"Mazurek",
	"Kalinowski",
	"Wysocki",
	"Adamski",
	"Wasilewski",
	"Sobczak",
	"Andrzejewski",
	"Czerwiński",
	"Cieślak",
	"Zakrzewski",
	"Sikorski",
	"Krajewski",
	"Szymczak",
	"Szulc",
	"Gajewski",
	"Baranowski",
	"Laskowski",
	"Makowski",
	"Brzeziński",
	"Przybylski",
	"Borowski",
	"Nowacki",
	"Chojnacki",
	"Domański",
	"Ciesielski",
	"Krupa",
	"Szczepaniak",
	"Kaczmarczyk",
	"Wesołowski",
	"Kowalewski",
	"Leszczyński",
	"Lipiński",
	"Kozak",
	"Kania",
	"Urbaniak",
	"Mucha",
	"Kowalik",
	"Tomczak",
	"Czajkowski",
	"Mikołajczyk",
	"Markowski",
}

local Polish = CultureName.New(
{
	male = male,
	female = female,
	surname = surname,
	name = "Polish",
	code = "pl",
	replace = {
		['ą'] = 'a', ['Ą'] = 'A',
		['ć'] = 'c', ['Ć'] = 'C',
		['ę'] = 'e', ['Ę'] = 'E',
		['ł'] = 'l', ['Ł'] = 'L',
		['ń'] = 'n', ['Ń'] = 'N',
		['ó'] = 'o', ['Ó'] = 'O',
		['ś'] = 's', ['Ś'] = 'S',
		['ź'] = 'z', ['Ź'] = 'Z',
		['ż'] = 'z', ['Ż'] = 'Z',
	}
})

return Polish
