/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Hashing$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.AbstractSet;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Range;
import scala.collection.immutable.SetHashIterator;
import scala.collection.immutable.SetIterator;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.SetNode$;
import scala.collection.immutable.SetReverseIterator;
import scala.collection.immutable.StrictOptimizedSetOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class HashSet<A>
extends AbstractSet<A>
implements DefaultSerializable,
StrictOptimizedSetOps<A, HashSet, HashSet<A>> {
    private final BitmapIndexedSetNode<A> rootNode;

    /*
     * WARNING - void declaration
     */
    @Override
    public final <A1, A2> Tuple2<HashSet<A1>, HashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public final Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    public final BitmapIndexedSetNode<A> rootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - void declaration
     */
    private HashSet<A> newHashSetOrThis(BitmapIndexedSetNode<A> newRootNode) {
        void var1_1;
        if (this.rootNode() == newRootNode) {
            return this;
        }
        return new HashSet<A>(var1_1);
    }

    @Override
    public final IterableFactory<HashSet> iterableFactory() {
        return HashSet$.MODULE$;
    }

    @Override
    public final int knownSize() {
        return this.rootNode().size();
    }

    @Override
    public final int size() {
        return this.rootNode().size();
    }

    @Override
    public final boolean isEmpty() {
        return this.rootNode().size() == 0;
    }

    @Override
    public final Iterator<A> iterator() {
        if (this.isEmpty()) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new SetIterator<A>(this.rootNode());
    }

    public final Iterator<A> reverseIterator() {
        return new SetReverseIterator<A>(this.rootNode());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(A element) {
        void var3_3;
        void var2_2;
        void var1_1;
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        return this.rootNode().contains(var1_1, (int)var2_2, (int)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> incl(A element) {
        void var1_1;
        void var3_3;
        void var2_2;
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        SetNode newRootNode = this.rootNode().updated((Object)element, (int)var2_2, (int)var3_3, 0);
        return this.newHashSetOrThis((BitmapIndexedSetNode<A>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> excl(A element) {
        void var1_1;
        void var3_3;
        void var2_2;
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        SetNode newRootNode = this.rootNode().removed((Object)element, (int)var2_2, (int)var3_3, 0);
        return this.newHashSetOrThis((BitmapIndexedSetNode<A>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> concat(IterableOnce<A> that) {
        HashSet.HashSetIterator iter;
        if (that instanceof HashSet) {
            that = (HashSet)that;
            if (this.isEmpty()) {
                return that;
            }
            SetNode newNode = this.rootNode().concat((SetNode)((HashSet)that).rootNode(), 0);
            if (newNode == ((HashSet)that).rootNode()) {
                return that;
            }
            return this.newHashSetOrThis((BitmapIndexedSetNode<A>)newNode);
        }
        if (that instanceof scala.collection.mutable.HashSet) {
            if ((that = (scala.collection.mutable.HashSet)that) == null) {
                throw null;
            }
            iter = new HashSet.HashSetIterator<HashSet.Node<A>>((scala.collection.mutable.HashSet)that){

                public final HashSet.Node<A> extract(HashSet.Node<A> nd) {
                    return nd;
                }
                {
                    void var1_1;
                }
            };
            SetNode current = this.rootNode();
            while (iter.hasNext()) {
                HashSet.Node next = (HashSet.Node)iter.next();
                int unimproveHash_improvedHash = next.hash();
                int originalHash = unimproveHash_improvedHash ^ unimproveHash_improvedHash >>> 16;
                int improved = Hashing$.MODULE$.improve(originalHash);
                if ((current = ((BitmapIndexedSetNode)current).updated(next.key(), originalHash, improved, 0)) == this.rootNode()) continue;
                int bitposFrom_mask = improved & 0x1F;
                int shallowlyMutableNodeMap = 1 << bitposFrom_mask;
                while (iter.hasNext()) {
                    HashSet.Node next2 = (HashSet.Node)iter.next();
                    int unimproveHash_improvedHash2 = next2.hash();
                    int originalHash2 = unimproveHash_improvedHash2 ^ unimproveHash_improvedHash2 >>> 16;
                    int improved2 = Hashing$.MODULE$.improve(originalHash2);
                    shallowlyMutableNodeMap = ((BitmapIndexedSetNode)current).updateWithShallowMutations(next2.key(), originalHash2, improved2, 0, shallowlyMutableNodeMap);
                }
                return new HashSet<A>(current);
            }
            return this;
        }
        if (iter instanceof LinkedHashSet) {
            iter = (LinkedHashSet)((Object)iter);
            Iterator iter2 = ((LinkedHashSet)((Object)iter)).entryIterator();
            SetNode current = this.rootNode();
            while (iter2.hasNext()) {
                LinkedHashSet.Entry next = iter2.next();
                int originalHash = ((LinkedHashSet)((Object)iter)).unimproveHash(next.hash());
                int improved = Hashing$.MODULE$.improve(originalHash);
                if ((current = ((BitmapIndexedSetNode)current).updated(next.key(), originalHash, improved, 0)) == this.rootNode()) continue;
                int bitposFrom_mask = improved & 0x1F;
                int shallowlyMutableNodeMap = 1 << bitposFrom_mask;
                while (iter2.hasNext()) {
                    LinkedHashSet.Entry next3 = iter2.next();
                    int originalHash3 = ((LinkedHashSet)((Object)iter)).unimproveHash(next3.hash());
                    int improved3 = Hashing$.MODULE$.improve(originalHash3);
                    shallowlyMutableNodeMap = ((BitmapIndexedSetNode)current).updateWithShallowMutations(next3.key(), originalHash3, improved3, 0, shallowlyMutableNodeMap);
                }
                return new HashSet<A>(current);
            }
            return this;
        }
        iter = iter.iterator();
        SetNode current = this.rootNode();
        while (iter.hasNext()) {
            void var2_5;
            int improved;
            int originalHash;
            Object element = iter.next();
            if ((current = ((BitmapIndexedSetNode)current).updated(element, originalHash = Statics.anyHash(element), improved = Hashing$.MODULE$.improve(originalHash), 0)) == this.rootNode()) continue;
            int bitposFrom_mask = improved & 0x1F;
            int shallowlyMutableNodeMap = 1 << bitposFrom_mask;
            while (iter.hasNext()) {
                Object element2 = iter.next();
                int originalHash4 = Statics.anyHash(element2);
                int improved4 = Hashing$.MODULE$.improve(originalHash4);
                shallowlyMutableNodeMap = ((BitmapIndexedSetNode)current).updateWithShallowMutations(element2, originalHash4, improved4, 0, shallowlyMutableNodeMap);
            }
            return new HashSet<A>(var2_5);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> tail() {
        void var1_1;
        A $minus_elem = this.head();
        return this.excl((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> init() {
        void var1_1;
        A $minus_elem = this.last();
        return this.excl((Object)var1_1);
    }

    @Override
    public final A head() {
        return this.iterator().next();
    }

    @Override
    public final A last() {
        return this.reverseIterator().next();
    }

    @Override
    public final <U> void foreach(Function1<A, U> f) {
        BitmapIndexedSetNode<A> bitmapIndexedSetNode = this.rootNode();
        if (bitmapIndexedSetNode == null) {
            throw null;
        }
        BitmapIndexedSetNode<A> foreach_this = bitmapIndexedSetNode;
        int foreach_thisPayloadArity = bitmapIndexedSetNode.payloadArity();
        for (int foreach_i = 0; foreach_i < foreach_thisPayloadArity; ++foreach_i) {
            f.apply(foreach_this.content()[foreach_i]);
        }
        int foreach_thisNodeArity = foreach_this.nodeArity();
        for (int foreach_j = 0; foreach_j < foreach_thisNodeArity; ++foreach_j) {
            ((SetNode)foreach_this.getNode(foreach_j)).foreach(f);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean subsetOf(Set<A> that) {
        block6: {
            block5: {
                boolean bl;
                if (this.isEmpty()) break block5;
                if (that.isEmpty()) break block6;
                if (that instanceof HashSet) {
                    that = that;
                    bl = this.rootNode().subsetOf(that.rootNode(), 0);
                } else {
                    void var1_1;
                    bl = this.forall(var1_1);
                }
                if (!bl) break block6;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object that) {
        void var1_1;
        block2: {
            block4: {
                block3: {
                    if (!(that instanceof HashSet)) break block2;
                    if (this == (that = (HashSet)((Object)that))) break block3;
                    BitmapIndexedSetNode<A> bitmapIndexedSetNode = this.rootNode();
                    that = ((HashSet)((Object)that)).rootNode();
                    if (bitmapIndexedSetNode != null ? !((Object)bitmapIndexedSetNode).equals(that) : that != null) break block4;
                }
                return true;
            }
            return false;
        }
        return Set.equals$(this, var1_1);
    }

    @Override
    public final String className() {
        return "HashSet";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        SetHashIterator<A> it = new SetHashIterator<A>(this.rootNode());
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)var1_1, MurmurHash3$.MODULE$.setSeed());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> diff(Set<A> that) {
        void var1_1;
        void var2_3;
        HashSet.HashSetIterator iter;
        if (this.isEmpty()) {
            return this;
        }
        if (that instanceof HashSet) {
            if (((HashSet)(that = (HashSet)that)).isEmpty()) {
                return this;
            }
            if (((BitmapIndexedSetNode)this.rootNode().diff((SetNode)((HashSet)that).rootNode(), 0)).size() == 0) {
                return HashSet$.MODULE$.empty();
            }
            HashSet hashSet = this;
            return hashSet.newHashSetOrThis((BitmapIndexedSetNode<A>)hashSet.rootNode().diff((SetNode)((HashSet)that).rootNode(), 0));
        }
        if (that instanceof scala.collection.mutable.HashSet) {
            if ((that = (scala.collection.mutable.HashSet)that) == null) {
                throw null;
            }
            iter = new /* invalid duplicate definition of identical inner class */;
            SetNode curr = this.rootNode();
            while (iter.hasNext()) {
                HashSet.Node next = (HashSet.Node)iter.next();
                int unimproveHash_improvedHash = next.hash();
                int originalHash = unimproveHash_improvedHash ^ unimproveHash_improvedHash >>> 16;
                int improved = Hashing$.MODULE$.improve(originalHash);
                if ((curr = ((BitmapIndexedSetNode)curr).removed(next.key(), originalHash, improved, 0)) == this.rootNode()) continue;
                if (((BitmapIndexedSetNode)curr).size() == 0) {
                    return HashSet$.MODULE$.empty();
                }
                while (iter.hasNext()) {
                    void var3_4;
                    next = (HashSet.Node)iter.next();
                    unimproveHash_improvedHash = next.hash();
                    originalHash = unimproveHash_improvedHash ^ unimproveHash_improvedHash >>> 16;
                    improved = Hashing$.MODULE$.improve(originalHash);
                    ((BitmapIndexedSetNode)curr).removeWithShallowMutations(var3_4.key(), originalHash, improved);
                    if (((BitmapIndexedSetNode)curr).size() != 0) continue;
                    return HashSet$.MODULE$.empty();
                }
                return new HashSet<A>(curr);
            }
            return this;
        }
        int thatKnownSize = iter.knownSize();
        if (thatKnownSize == 0) {
            return this;
        }
        if (var2_3 <= this.size()) {
            return this.removedAllWithShallowMutations(iter);
        }
        Function1<Object, Object> & Serializable filterNot_pred = arg_0 -> HashSet.$anonfun$diff$1$adapted((Set)((Object)iter), arg_0);
        SetNode filterImpl_newRootNode = this.rootNode().filterImpl(filterNot_pred, true);
        if (filterImpl_newRootNode == this.rootNode()) {
            return this;
        }
        if (((BitmapIndexedSetNode)filterImpl_newRootNode).size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        return new HashSet<A>(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private HashSet<A> removedAllWithShallowMutations(IterableOnce<A> that) {
        Iterator<A> iter = that.iterator();
        SetNode curr = this.rootNode();
        while (iter.hasNext()) {
            void var2_2;
            int improved;
            int originalHash;
            A next = iter.next();
            if ((curr = ((BitmapIndexedSetNode)curr).removed((Object)next, originalHash = Statics.anyHash(next), improved = Hashing$.MODULE$.improve(originalHash), 0)) == this.rootNode()) continue;
            if (((BitmapIndexedSetNode)curr).size() == 0) {
                return HashSet$.MODULE$.empty();
            }
            while (iter.hasNext()) {
                void var3_3;
                next = iter.next();
                originalHash = Statics.anyHash(next);
                improved = Hashing$.MODULE$.improve(originalHash);
                ((BitmapIndexedSetNode)curr).removeWithShallowMutations(var3_3, originalHash, improved);
                if (((BitmapIndexedSetNode)curr).size() != 0) continue;
                return HashSet$.MODULE$.empty();
            }
            return new HashSet<A>(var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> removedAll(IterableOnce<A> that) {
        void var1_1;
        Range range;
        if (that instanceof Set) {
            that = that;
            return this.diff(that);
        }
        if (that instanceof Range && (range = (Range)((Object)that)).length() > this.size()) {
            Function1<Object, Object> & Serializable filter_pred = (Function1<Object, Object> & Serializable)x0$1 -> {
                void var1_1;
                return BoxesRunTime.boxToBoolean(HashSet.$anonfun$removedAll$1(range, (Object)var1_1));
            };
            SetNode filterImpl_newRootNode = this.rootNode().filterImpl(filter_pred, false);
            if (filterImpl_newRootNode == this.rootNode()) {
                return this;
            }
            if (((BitmapIndexedSetNode)filterImpl_newRootNode).size() == 0) {
                return HashSet$.MODULE$.empty();
            }
            return new HashSet<A>(var1_1);
        }
        return this.removedAllWithShallowMutations((IterableOnce<A>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Tuple2<HashSet<A>, HashSet<A>> partition(Function1<A, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> filterImpl(Function1<A, Object> pred, boolean isFlipped) {
        void var1_1;
        void var2_2;
        SetNode newRootNode = this.rootNode().filterImpl((Function1)pred, (boolean)var2_2);
        if (newRootNode == this.rootNode()) {
            return this;
        }
        if (((BitmapIndexedSetNode)newRootNode).size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        return new HashSet<A>(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> intersect(Set<A> that) {
        void var1_1;
        return (HashSet)SetOps.intersect$(this, (Set)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> take(int n) {
        void var1_1;
        return (HashSet)IterableOps.take$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> takeWhile(Function1<A, Object> p) {
        void var1_1;
        return (HashSet)IterableOps.takeWhile$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> drop(int n) {
        void var1_1;
        return (HashSet)IterableOps.drop$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> dropRight(int n) {
        void var1_1;
        return (HashSet)StrictOptimizedIterableOps.dropRight$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> dropWhile(Function1<A, Object> p) {
        void var1_1;
        return (HashSet)IterableOps.dropWhile$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$diff$1(Set x1$1, Object elem) {
        void var1_1;
        return x1$1.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$removedAll$1(Range x3$1, Object x0$1) {
        if (x0$1 instanceof Integer) {
            Range range;
            void var1_1;
            int n = BoxesRunTime.unboxToInt(var1_1);
            return !range.contains(n);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public HashSet(BitmapIndexedSetNode<A> rootNode) {
        void var1_1;
        this.rootNode = var1_1;
        Statics.releaseFence();
    }

    public HashSet() {
        this(SetNode$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$diff$1$adapted(Set x1$1, Object elem) {
        void var1_1;
        return BoxesRunTime.boxToBoolean(HashSet.$anonfun$diff$1(x1$1, var1_1));
    }
}

