/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.RedBlackTree;
import scala.math.Ordering;
import scala.runtime.Null$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$ = new RedBlackTree$();

    /*
     * WARNING - void declaration
     */
    public final boolean isRed(RedBlackTree.Node<?, ?> node) {
        void var1_1;
        return node != null && var1_1.red();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isBlack(RedBlackTree.Node<?, ?> node) {
        void var1_1;
        return node == null || !var1_1.red();
    }

    public final boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree.root() == null;
    }

    /*
     * WARNING - void declaration
     */
    public final void clear(RedBlackTree.Tree<?, ?> tree) {
        void var1_1;
        tree.root_$eq(null);
        var1_1.size_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    public final <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$1) {
        void var3_3;
        void var2_2;
        RedBlackTree.Node node;
        if ((node = this.getNode(((RedBlackTree.Tree)((Object)node)).root(), var2_2, (Ordering<A>)var3_3)) == null) {
            return None$.MODULE$;
        }
        return new Some(node.value());
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Node<A, B> getNode(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        void var1_1;
        while (true) {
            if (node == null) {
                return null;
            }
            int cmp = ord.compare(key, node.key());
            if (cmp < 0) {
                node = node.left();
                continue;
            }
            if (cmp <= 0) break;
            node = node.right();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> evidence$2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getNode(var1_1.root(), var2_2, (Ordering<A>)var3_3) != null;
    }

    public final <A, B> Option<Tuple2<A, B>> min(RedBlackTree.Tree<A, B> tree) {
        RedBlackTree.Node node;
        if ((node = this.scala$collection$mutable$RedBlackTree$$minNode(((RedBlackTree.Tree)((Object)node)).root())) == null) {
            return None$.MODULE$;
        }
        return new Some(new Tuple2(node.key(), node.value()));
    }

    public final <A> Option<A> minKey(RedBlackTree.Tree<A, ?> tree) {
        RedBlackTree.Node node;
        if ((node = this.scala$collection$mutable$RedBlackTree$$minNode(((RedBlackTree.Tree)((Object)node)).root())) == null) {
            return None$.MODULE$;
        }
        return new Some(node.key());
    }

    /*
     * WARNING - void declaration
     */
    public final <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$minNode(RedBlackTree.Node<A, B> node) {
        void var1_1;
        if (node == null) {
            return null;
        }
        return this.minNodeNonNull((RedBlackTree.Node<A, B>)var1_1);
    }

    public final <A, B> RedBlackTree.Node<A, B> minNodeNonNull(RedBlackTree.Node<A, B> node) {
        while (node.left() != null) {
            node = node.left();
        }
        return node;
    }

    public final <A, B> Option<Tuple2<A, B>> max(RedBlackTree.Tree<A, B> tree) {
        RedBlackTree.Node node;
        if ((node = this.maxNode(((RedBlackTree.Tree)((Object)node)).root())) == null) {
            return None$.MODULE$;
        }
        return new Some(new Tuple2(node.key(), node.value()));
    }

    public final <A> Option<A> maxKey(RedBlackTree.Tree<A, ?> tree) {
        RedBlackTree.Node node;
        if ((node = this.maxNode(((RedBlackTree.Tree)((Object)node)).root())) == null) {
            return None$.MODULE$;
        }
        return new Some(node.key());
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Node<A, B> maxNode(RedBlackTree.Node<A, B> node) {
        void var1_1;
        if (node == null) {
            return null;
        }
        return this.maxNodeNonNull((RedBlackTree.Node<A, B>)var1_1);
    }

    public final <A, B> RedBlackTree.Node<A, B> maxNodeNonNull(RedBlackTree.Node<A, B> node) {
        while (node.right() != null) {
            node = node.right();
        }
        return node;
    }

    public final <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$minNodeAfter(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        RedBlackTree.Node x;
        if (node == null) {
            return null;
        }
        RedBlackTree.Node<A, B> y = null;
        int cmp = 1;
        while (x != null && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp <= 0) {
            return y;
        }
        return this.scala$collection$mutable$RedBlackTree$$successor(y);
    }

    /*
     * WARNING - void declaration
     */
    public final <A, B> void insert(RedBlackTree.Tree<A, B> tree, A key, B value, Ordering<A> ord) {
        void var1_1;
        void var2_2;
        void var3_3;
        RedBlackTree.Node<A, void> y = null;
        RedBlackTree.Node<A, void> x = tree.root();
        int cmp = 1;
        while (x != null && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp == 0) {
            y.value_$eq((void)value);
            return;
        }
        RedBlackTree.Node<A, void> z = new RedBlackTree.Node<A, void>(key, var3_3, true, null, null, y);
        if (y == null) {
            tree.root_$eq(z);
        } else if (cmp < 0) {
            y.left_$eq(z);
        } else {
            y.right_$eq(z);
        }
        this.fixAfterInsert(tree, (RedBlackTree.Node<A, B>)var2_2);
        void v0 = var1_1;
        v0.size_$eq(v0.size() + 1);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> void fixAfterInsert(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> node) {
        void var1_1;
        RedBlackTree.Node<A, B> z = node;
        while (this.isRed(z.parent())) {
            RedBlackTree.Node<A, B> y;
            if (z.parent() == z.parent().parent().left()) {
                y = z.parent().parent().right();
                if (this.isRed(y)) {
                    z.parent().red_$eq(false);
                    y.red_$eq(false);
                    z.parent().parent().red_$eq(true);
                    z = z.parent().parent();
                    continue;
                }
                RedBlackTree.Node<A, B> node2 = z;
                if (node2 == node2.parent().right()) {
                    z = z.parent();
                    this.rotateLeft(tree, z);
                }
                z.parent().red_$eq(false);
                z.parent().parent().red_$eq(true);
                this.rotateRight(tree, z.parent().parent());
                continue;
            }
            y = z.parent().parent().left();
            if (this.isRed(y)) {
                void var3_3;
                z.parent().red_$eq(false);
                var3_3.red_$eq(false);
                z.parent().parent().red_$eq(true);
                z = z.parent().parent();
                continue;
            }
            RedBlackTree.Node<A, B> node3 = z;
            if (node3 == node3.parent().left()) {
                z = z.parent();
                this.rotateRight(tree, z);
            }
            z.parent().red_$eq(false);
            z.parent().parent().red_$eq(true);
            this.rotateLeft(tree, z.parent().parent());
        }
        var1_1.root().red_$eq(false);
    }

    /*
     * WARNING - void declaration
     */
    public final <A, B> void delete(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, B> z = this.getNode(tree.root(), key, ord);
        if (z != null) {
            void var1_1;
            RedBlackTree.Node<A, B> xParent;
            RedBlackTree.Node<A, B> x;
            boolean yIsRed = z.red();
            if (z.left() == null) {
                x = z.right();
                RedBlackTree.Node<A, B> node = z;
                this.transplant(tree, node, node.right());
                xParent = z.parent();
            } else if (z.right() == null) {
                x = z.left();
                RedBlackTree.Node<A, B> node = z;
                this.transplant(tree, node, node.left());
                xParent = z.parent();
            } else {
                void var2_2;
                void var3_3;
                RedBlackTree.Node<A, B> y = this.minNodeNonNull(z.right());
                yIsRed = y.red();
                x = y.right();
                if (y.parent() == z) {
                    xParent = y;
                } else {
                    xParent = y.parent();
                    RedBlackTree.Node<A, B> node = y;
                    this.transplant(tree, node, node.right());
                    y.right_$eq(z.right());
                    y.right().parent_$eq(y);
                }
                this.transplant(tree, z, y);
                y.left_$eq(z.left());
                y.left().parent_$eq(y);
                var3_3.red_$eq(var2_2.red());
            }
            if (!yIsRed) {
                this.fixAfterDelete(tree, x, xParent);
            }
            void v3 = var1_1;
            v3.size_$eq(v3.size() - 1);
            return;
        }
    }

    private <A, B> void fixAfterDelete(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> node, RedBlackTree.Node<A, B> parent) {
        RedBlackTree.Node<A, B> node2;
        RedBlackTree.Node<A, B> x = node;
        while (x != tree.root() && this.isBlack(x)) {
            RedBlackTree.Node w;
            RedBlackTree.Node xParent;
            if (x == xParent.left()) {
                w = xParent.right();
                if (w.red()) {
                    w.red_$eq(false);
                    xParent.red_$eq(true);
                    this.rotateLeft(tree, xParent);
                    w = xParent.right();
                }
                if (this.isBlack(w.left()) && this.isBlack(w.right())) {
                    w.red_$eq(true);
                    w = xParent;
                } else {
                    if (this.isBlack(w.right())) {
                        w.left().red_$eq(false);
                        w.red_$eq(true);
                        this.rotateRight(tree, w);
                        w = xParent.right();
                    }
                    w.red_$eq(xParent.red());
                    xParent.red_$eq(false);
                    w.right().red_$eq(false);
                    this.rotateLeft(tree, xParent);
                    w = tree.root();
                }
            } else {
                w = xParent.left();
                if (w.red()) {
                    w.red_$eq(false);
                    xParent.red_$eq(true);
                    this.rotateRight(tree, xParent);
                    w = xParent.left();
                }
                if (this.isBlack(w.right()) && this.isBlack(w.left())) {
                    w.red_$eq(true);
                    w = xParent;
                } else {
                    if (this.isBlack(w.left())) {
                        w.right().red_$eq(false);
                        w.red_$eq(true);
                        this.rotateLeft(tree, w);
                        w = xParent.left();
                    }
                    w.red_$eq(xParent.red());
                    xParent.red_$eq(false);
                    node2.left().red_$eq(false);
                    this.rotateRight(tree, xParent);
                    node2 = tree.root();
                }
            }
            xParent = node2.parent();
        }
        if (node2 != null) {
            node2.red_$eq(false);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <A, B> RedBlackTree.Node<A, B> scala$collection$mutable$RedBlackTree$$successor(RedBlackTree.Node<A, B> node) {
        void var1_1;
        if (node.right() != null) {
            return this.minNodeNonNull(node.right());
        }
        RedBlackTree.Node<A, B> x = node;
        for (RedBlackTree.Node<A, B> y = node.parent(); y != null && x == y.right(); y = y.parent()) {
            x = y;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> void rotateLeft(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> x) {
        if (x != null) {
            void var3_3;
            void var2_2;
            RedBlackTree.Node<A, B> y = x.right();
            x.right_$eq(y.left());
            if (y.left() != null) {
                y.left().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                void var1_1;
                var1_1.root_$eq(y);
            } else {
                RedBlackTree.Node<A, B> node = x;
                if (node == node.parent().left()) {
                    x.parent().left_$eq(y);
                } else {
                    x.parent().right_$eq(y);
                }
            }
            y.left_$eq(x);
            var2_2.parent_$eq(var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> void rotateRight(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> x) {
        if (x != null) {
            void var3_3;
            void var2_2;
            RedBlackTree.Node<A, B> y = x.left();
            x.left_$eq(y.right());
            if (y.right() != null) {
                y.right().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                void var1_1;
                var1_1.root_$eq(y);
            } else {
                RedBlackTree.Node<A, B> node = x;
                if (node == node.parent().right()) {
                    x.parent().right_$eq(y);
                } else {
                    x.parent().left_$eq(y);
                }
            }
            y.right_$eq(x);
            var2_2.parent_$eq(var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> void transplant(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> to, RedBlackTree.Node<A, B> from) {
        if (to.parent() == null) {
            void var1_1;
            var1_1.root_$eq(from);
        } else {
            RedBlackTree.Node<A, B> node = to;
            if (node == node.parent().left()) {
                to.parent().left_$eq(from);
            } else {
                to.parent().right_$eq(from);
            }
        }
        if (from != null) {
            void var2_2;
            void var3_3;
            var3_3.parent_$eq(var2_2.parent());
            return;
        }
    }

    public final <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        RedBlackTree.Node<A, B> foreachNode_node = tree.root();
        if (foreachNode_node != null) {
            while (true) {
                RedBlackTree.Node foreachNode_foreachNodeNonNull_node;
                if (foreachNode_foreachNodeNonNull_node.left() != null) {
                    RedBlackTree.Node foreachNodeNonNull_node = foreachNode_foreachNodeNonNull_node.left();
                    while (true) {
                        if (foreachNodeNonNull_node.left() != null) {
                            this.foreachNodeNonNull(foreachNodeNonNull_node.left(), f);
                        }
                        f.apply(new Tuple2(foreachNodeNonNull_node.key(), foreachNodeNonNull_node.value()));
                        if (foreachNodeNonNull_node.right() == null) break;
                        foreachNodeNonNull_node = foreachNodeNonNull_node.right();
                    }
                }
                f.apply(new Tuple2(foreachNode_foreachNodeNonNull_node.key(), foreachNode_foreachNodeNonNull_node.value()));
                if (foreachNode_foreachNodeNonNull_node.right() == null) break;
                foreachNode_foreachNodeNonNull_node = foreachNode_foreachNodeNonNull_node.right();
            }
            return;
        }
    }

    private <A, B, U> void foreachNodeNonNull(RedBlackTree.Node<A, B> node, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (node.left() != null) {
                this.foreachNodeNonNull(node.left(), f);
            }
            f.apply(new Tuple2<A, B>(node.key(), node.value()));
            if (node.right() == null) break;
            node = node.right();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        RedBlackTree.Node<A, ?> r = tree.root();
        if (r != null) {
            RedBlackTree.Node g$1_r;
            do {
                void g$1_node;
                RedBlackTree.Node g$1_l;
                if ((g$1_l = g$1_node.left()) != null) {
                    void var3_3;
                    this.g$1((RedBlackTree.Node)var3_3, f);
                }
                f.apply(g$1_node.key());
                g$1_r = g$1_node.right();
            } while (g$1_r != null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <A, B, U> void foreachEntry(RedBlackTree.Tree<A, B> tree, Function2<A, B, U> f) {
        RedBlackTree.Node<A, B> r = tree.root();
        if (r != null) {
            RedBlackTree.Node g$2_r;
            do {
                void g$2_node;
                RedBlackTree.Node g$2_l;
                if ((g$2_l = g$2_node.left()) != null) {
                    void var3_3;
                    this.g$2((RedBlackTree.Node)var3_3, f);
                }
                f.apply(g$2_node.key(), g$2_node.value());
                g$2_r = g$2_node.right();
            } while (g$2_r != null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <A> RedBlackTree.Tree<A, Null$> fromOrderedKeys(Iterator<A> xs, int size) {
        void var2_2;
        void var3_3;
        void var1_1;
        int maxUsedDepth = 32 - Integer.numberOfLeadingZeros(size);
        return new RedBlackTree.Tree(RedBlackTree$.f$3(1, size, (Iterator)var1_1, (int)var3_3), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <A, B> RedBlackTree.Node<A, B> copyTree(RedBlackTree.Node<A, B> n) {
        void var1_1;
        if (n == null) {
            return null;
        }
        RedBlackTree.Node<A, B> c = new RedBlackTree.Node<A, B>(n.key(), n.value(), n.red(), this.copyTree(n.left()), this.copyTree(n.right()), null);
        if (c.left() != null) {
            c.left().parent_$eq(c);
        }
        if (c.right() != null) {
            c.right().parent_$eq(c);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void g$1(RedBlackTree.Node node, Function1 f$1) {
        RedBlackTree.Node r;
        do {
            RedBlackTree.Node l;
            if ((l = node.left()) != null) {
                void var3_3;
                this.g$1((RedBlackTree.Node)var3_3, f$1);
            }
            f$1.apply(node.key());
            r = node.right();
        } while (r != null);
    }

    /*
     * WARNING - void declaration
     */
    private final void g$2(RedBlackTree.Node node, Function2 f$2) {
        RedBlackTree.Node r;
        do {
            RedBlackTree.Node l;
            if ((l = node.left()) != null) {
                void var3_3;
                this.g$2((RedBlackTree.Node)var3_3, f$2);
            }
            f$2.apply(node.key(), node.value());
            r = node.right();
        } while (r != null);
    }

    /*
     * WARNING - void declaration
     */
    private static final RedBlackTree.Node f$3(int level, int size, Iterator xs$1, int maxUsedDepth$1) {
        void var1_3;
        void var0_1;
        void var3_5;
        void var2_4;
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return new RedBlackTree.Node(xs$1.next(), null, level == maxUsedDepth$1 && level != 1, null, null, null);
            }
        }
        int leftSize = (size - 1) / 2;
        RedBlackTree.Node left = RedBlackTree$.f$3(level + 1, leftSize, xs$1, maxUsedDepth$1);
        Object x = xs$1.next();
        RedBlackTree.Node right = RedBlackTree$.f$3(level + 1, size - 1 - leftSize, (Iterator)var2_4, (int)var3_5);
        RedBlackTree.Node n = new RedBlackTree.Node(x, null, false, left, right, null);
        if (left != null) {
            left.parent_$eq(n);
        }
        var0_1.parent_$eq(n);
        return var1_3;
    }

    private RedBlackTree$() {
    }
}

