/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.rdr.AESEAXCipher;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.OutStream;
import java.nio.ByteBuffer;

public class AESOutStream
extends OutStream {
    static final int maxMessageSize = 8192;
    private AESEAXCipher cipher;
    private int start;
    private int offset;
    private int bufSize;
    private byte[] buffer;
    private byte[] counter;
    private OutStream out;

    public AESOutStream(OutStream outStream, byte[] byArray) {
        this.out = outStream;
        this.bufSize = 8192;
        this.b = new byte[this.bufSize];
        this.buffer = new byte[this.bufSize + 16 + 2];
        this.start = 0;
        this.offset = 0;
        this.ptr = 0;
        this.end = this.start + this.bufSize;
        this.cipher = new AESEAXCipher(byArray);
        this.counter = new byte[16];
    }

    @Override
    public int length() {
        return this.offset + this.ptr - this.start;
    }

    @Override
    public void flush() {
        int n = this.start;
        while (n < this.ptr) {
            int n2 = this.writeMessage(this.b, n, this.ptr - n);
            n += n2;
            this.offset += n2;
        }
        this.ptr = this.start;
    }

    @Override
    protected int overrun(int n, int n2) {
        if (n > this.bufSize) {
            throw new Exception("AESOutStream overrun: max itemSize exceeded");
        }
        this.flush();
        int n3 = (this.end - this.ptr) / n;
        if (n3 < n2) {
            return n3;
        }
        return n2;
    }

    protected int writeMessage(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        this.buffer[0] = (byte)((n2 & 0xFF00) >> 8);
        this.buffer[1] = (byte)(n2 & 0xFF);
        this.cipher.encrypt(byArray, n, n2, this.buffer, 0, 2, this.counter, this.buffer, 2, this.buffer, 2 + n2);
        this.out.writeBytes(ByteBuffer.wrap(this.buffer, 0, n2 + 16 + 2), n2 + 16 + 2);
        this.out.flush();
        int n3 = 0;
        while (n3 < 16) {
            int n4 = n3++;
            this.counter[n4] = (byte)(this.counter[n4] + 1);
            if (this.counter[n4] != 0) break;
        }
        return n2;
    }
}

