/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.HashMap;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    protected final HashMap<String, String> excludes;

    public SetPropertiesRule() {
        this.excludes = null;
    }

    public SetPropertiesRule(String[] stringArray) {
        this.excludes = new HashMap();
        for (String string : stringArray) {
            if (string == null) continue;
            this.excludes.put(string, string);
        }
    }

    @Override
    public void begin(String string, String string2, Attributes attributes) throws Exception {
        Object object = this.digester.peek();
        if (this.digester.log.isTraceEnabled()) {
            this.digester.log.trace((Object)("[SetPropertiesRule]{" + this.digester.match + "} Set " + object.getClass().getName() + " properties"));
        }
        StringBuilder stringBuilder = this.digester.getGeneratedCode();
        String string3 = null;
        if (stringBuilder != null) {
            string3 = this.digester.toVariableName(object);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getLocalName(i);
            if (string4.isEmpty()) {
                string4 = attributes.getQName(i);
            }
            String string5 = attributes.getValue(i);
            if (this.digester.log.isTraceEnabled()) {
                this.digester.log.trace((Object)("[SetPropertiesRule]{" + this.digester.match + "} Setting property '" + string4 + "' to '" + string5 + "'"));
            }
            if (this.digester.isFakeAttribute(object, string4) || this.excludes != null && this.excludes.containsKey(string4)) continue;
            StringBuilder stringBuilder2 = null;
            if (stringBuilder != null) {
                stringBuilder2 = new StringBuilder();
            }
            if (!IntrospectionUtils.setProperty((Object)object, (String)string4, (String)string5, (boolean)true, (StringBuilder)stringBuilder2)) {
                if (!this.digester.getRulesValidation() || "optional".equals(string4)) continue;
                this.digester.log.warn((Object)sm.getString("rule.noProperty", new Object[]{this.digester.match, string4, string5}));
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(string3).append('.').append((CharSequence)stringBuilder2).append(';');
            stringBuilder.append(System.lineSeparator());
        }
        if (object instanceof Listener) {
            ((Listener)object).endSetPropertiesRule();
            if (stringBuilder != null) {
                stringBuilder.append("((org.apache.tomcat.util.digester.SetPropertiesRule.Listener) ");
                stringBuilder.append(string3).append(").endSetPropertiesRule();");
                stringBuilder.append(System.lineSeparator());
            }
        }
    }

    public String toString() {
        return "SetPropertiesRule[]";
    }

    public static interface Listener {
        public void endSetPropertiesRule();
    }
}

