/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.http;

import jakarta.servlet.http.CookieNameValidator;
import jakarta.servlet.http.RFC6265Validator;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class Cookie
implements Cloneable,
Serializable {
    private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
    private static final ResourceBundle LSTRINGS = ResourceBundle.getBundle("jakarta.servlet.http.LocalStrings");
    private static final CookieNameValidator validation = new RFC6265Validator();
    private static final long serialVersionUID = 2L;
    private final String name;
    private String value;
    private volatile Map<String, String> attributes;
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String PATH = "Path";
    private static final String SECURE = "Secure";
    private static final String HTTP_ONLY = "HttpOnly";

    public Cookie(String string, String string2) {
        validation.validate(string);
        this.name = string;
        this.value = string2;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public void setComment(String string) {
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public String getComment() {
        return null;
    }

    public void setDomain(String string) {
        if (string == null) {
            this.setAttributeInternal(DOMAIN, null);
        } else {
            this.setAttributeInternal(DOMAIN, string.toLowerCase(Locale.ENGLISH));
        }
    }

    public String getDomain() {
        return this.getAttribute(DOMAIN);
    }

    public void setMaxAge(int n) {
        this.setAttributeInternal(MAX_AGE, Integer.toString(n));
    }

    public int getMaxAge() {
        String string = this.getAttribute(MAX_AGE);
        if (string == null) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    public void setPath(String string) {
        this.setAttributeInternal(PATH, string);
    }

    public String getPath() {
        return this.getAttribute(PATH);
    }

    public void setSecure(boolean bl) {
        this.setAttributeInternal(SECURE, Boolean.toString(bl));
    }

    public boolean getSecure() {
        return Boolean.parseBoolean(this.getAttribute(SECURE));
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public int getVersion() {
        return 0;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public void setVersion(int n) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public void setHttpOnly(boolean bl) {
        this.setAttributeInternal(HTTP_ONLY, Boolean.toString(bl));
    }

    public boolean isHttpOnly() {
        return Boolean.parseBoolean(this.getAttribute(HTTP_ONLY));
    }

    public void setAttribute(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(LSTRINGS.getString("cookie.attribute.invalidName.null"));
        }
        if (!validation.isToken(string)) {
            String string3 = LSTRINGS.getString("cookie.attribute.invalidName.notToken");
            throw new IllegalArgumentException(MessageFormat.format(string3, string));
        }
        if (string.equalsIgnoreCase(MAX_AGE)) {
            if (string2 == null) {
                this.setAttributeInternal(MAX_AGE, null);
            } else {
                this.setMaxAge(Integer.parseInt(string2));
            }
        } else {
            this.setAttributeInternal(string, string2);
        }
    }

    private void setAttributeInternal(String string, String string2) {
        if (this.attributes == null) {
            if (string2 == null) {
                return;
            }
            this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        if (string2 == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, string2);
        }
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.attributes == null ? 0 : this.attributes.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)object;
        if (this.attributes == null ? cookie.attributes != null : !this.attributes.equals(cookie.attributes)) {
            return false;
        }
        if (this.name == null ? cookie.name != null : !this.name.equals(cookie.name)) {
            return false;
        }
        return !(this.value == null ? cookie.value != null : !this.value.equals(cookie.value));
    }
}

