/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.SharedPoolDataSource;

public class SharedPoolDataSourceFactory
extends InstanceKeyDataSourceFactory {
    private static final String SHARED_POOL_CLASSNAME = SharedPoolDataSource.class.getName();

    @Override
    protected boolean isCorrectClass(String string) {
        return SHARED_POOL_CLASSNAME.equals(string);
    }

    @Override
    protected InstanceKeyDataSource getNewInstance(Reference reference) {
        SharedPoolDataSource sharedPoolDataSource = new SharedPoolDataSource();
        RefAddr refAddr = reference.get("maxTotal");
        if (refAddr != null && refAddr.getContent() != null) {
            sharedPoolDataSource.setMaxTotal(Integer.parseInt(refAddr.getContent().toString()));
        }
        return sharedPoolDataSource;
    }
}

