/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarEntry;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarEntries {
    private List<HarEntry> entries = new ArrayList<HarEntry>();

    public HarEntries() {
    }

    public HarEntries(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("[ missing after \"entries\" element " + jp.getCurrentName(), jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            this.addEntry(new HarEntry(jp, warnings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarEntries(HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + "entries";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT entry_id FROM " + tableName + " WHERE log_id=?");
            ps.setLong(1, logId);
            rs = ps.executeQuery();
            ArrayList<Long> l = new ArrayList<Long>();
            while (rs.next()) {
                l.add(rs.getLong(1));
            }
            for (Long long1 : l) {
                this.addEntry(new HarEntry(config, long1));
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeArrayFieldStart("entries");
        for (HarEntry entry : this.entries) {
            entry.writeHar(g);
        }
        g.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long logId, HarDatabaseConfig config) throws SQLException {
        Connection c = config.getConnection();
        String entriesTableName = config.getTablePrefix() + HarEntry.TABLE_NAME;
        if (!config.isCreatedTable(entriesTableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + entriesTableName + " (entry_id " + config.getDbAutoGeneratedId() + ",page_ref " + config.getStringDbType() + ", start_date " + config.getTimestampDbType() + ",time " + config.getLongDbType() + ",server_ip " + config.getStringDbType() + ",connexion " + config.getStringDbType() + ",comment " + config.getStringDbType() + ",log_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(entriesTableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        PreparedStatement entryPs = c.prepareStatement("INSERT INTO " + entriesTableName + " (page_ref,start_date,time,server_ip,connexion,comment,log_id) VALUES (?,?,?,?,?,?,?)", 1);
        try {
            for (HarEntry entry : this.entries) {
                entry.writeJDBC(logId, entryPs, config);
            }
        }
        finally {
            try {
                if (entryPs != null) {
                    entryPs.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        for (HarEntry entry : this.entries) {
            entry.deleteFromJDBC(config, logId, false);
        }
        Iterator<HarEntry> iterator = this.entries.iterator();
        if (iterator.hasNext()) {
            HarEntry entry;
            entry = iterator.next();
            entry.deleteFromJDBC(config, logId, true);
        }
        config.deleteFromTable(logId, config, "entries");
    }

    public void addEntry(HarEntry entry) {
        this.entries.add(entry);
    }

    public void removeEntry(HarEntry entry) {
        this.entries.remove(entry);
    }

    public List<HarEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<HarEntry> entries) {
        this.entries = entries;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("  \"entries\": [");
        if (this.entries != null) {
            boolean first = true;
            for (HarEntry entry : this.entries) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(entry);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

