/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.Toolkit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.GuiBootstrap;
import org.zaproxy.zap.view.AboutDialog;

class OsXGui {
    private static final Logger LOGGER = LogManager.getLogger(OsXGui.class);

    private OsXGui() {
    }

    public static void setup() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("dock:name", "ZAP");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "ZAP");
        LOGGER.info("Initializing OS X specific settings.");
        Taskbar.getTaskbar().setIconImage(OsXGui.createIcon());
        Desktop desktop = Desktop.getDesktop();
        desktop.setAboutHandler(ae -> OsXGui.showAboutDialog());
        desktop.setPreferencesHandler(pe -> OsXGui.showOptionsDialog());
        desktop.setQuitHandler((qe, qr) -> OsXGui.exitZap());
    }

    private static Image createIcon() {
        return Toolkit.getDefaultToolkit().getImage(GuiBootstrap.class.getResource("/resource/zap1024x1024.png"));
    }

    private static void showAboutDialog() {
        AboutDialog dialog = new AboutDialog((Frame)View.getSingleton().getMainFrame(), true);
        dialog.setVisible(true);
    }

    private static void showOptionsDialog() {
        Control.getSingleton().getMenuToolsControl().options();
    }

    private static void exitZap() {
        Control.getSingleton().getMenuFileControl().exit();
    }
}

