/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public class PopupMenuNote
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = -5692544221103745600L;
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuNote.class);
    private final ExtensionHistory extension;

    public PopupMenuNote(ExtensionHistory extension) {
        super(Constant.messages.getString("history.note.popup"));
        this.extension = extension;
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.HISTORY_PANEL;
    }

    @Override
    public void performAction(HistoryReference href) {
        try {
            this.extension.showNotesAddDialog(href, href.getHttpMessage().getNote());
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

