/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.ManualAuthenticationMethodType;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsPanel;
import org.zaproxy.zap.extension.stdmenus.PopupContextMenuItemFactory;
import org.zaproxy.zap.extension.users.ContextUsersPanel;
import org.zaproxy.zap.extension.users.DialogAddUser;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;

public class PopupMenuFactoryAddUserFromSession
extends PopupContextMenuItemFactory {
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuFactoryAddUserFromSession.class);
    private static final long serialVersionUID = 2453839120088204122L;
    private ExtensionHttpSessions extension;
    private ExtensionAuthentication extensionAuth;
    private ExtensionUserManagement extensionUsers;

    public PopupMenuFactoryAddUserFromSession(ExtensionHttpSessions extension) {
        super(Constant.messages.getString("httpsessions.popup.session.addUser"));
        this.extension = extension;
    }

    @Override
    public ExtensionPopupMenuItem getContextMenu(Context context, String parentMenu) {
        return new PopupMenuAddUserFromSession(context);
    }

    private ExtensionAuthentication getExtensionAuthentication() {
        if (this.extensionAuth == null) {
            this.extensionAuth = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAuthentication.class);
        }
        return this.extensionAuth;
    }

    private ExtensionUserManagement getExtensionUserManagement() {
        if (this.extensionUsers == null) {
            this.extensionUsers = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
        }
        return this.extensionUsers;
    }

    protected class PopupMenuAddUserFromSession
    extends ExtensionPopupMenuItem {
        private static final long serialVersionUID = 301409585294663964L;
        private Context context;
        private boolean pendingUsersClearing;
        private User newUser;

        @Override
        public boolean isSubMenu() {
            return true;
        }

        @Override
        public String getParentMenuName() {
            return Constant.messages.getString("httpsessions.popup.session.addUser");
        }

        public PopupMenuAddUserFromSession(Context context) {
            super(context.getName());
            this.context = context;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenuAddUserFromSession.this.performAction();
                }
            });
        }

        @Override
        public boolean isEnableForComponent(Component invoker) {
            if (PopupMenuFactoryAddUserFromSession.this.getExtensionAuthentication() == null) {
                return false;
            }
            if (PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement() == null) {
                return false;
            }
            return invoker.getName() != null && invoker.getName().equals("httpsessions");
        }

        private boolean confirmUsersDeletion(Context uiSharedContext) {
            int choice;
            return PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement() == null || PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement().getSharedContextUsers(uiSharedContext).size() <= 0 || (choice = JOptionPane.showConfirmDialog(this, Constant.messages.getString("authentication.dialog.confirmChange.label"), Constant.messages.getString("authentication.dialog.confirmChange.title"), 2)) != 2;
        }

        private User showAddUserDialogue(Context uiSharedContext, HttpSession session) {
            DialogAddUser addDialog = null;
            if (addDialog == null) {
                addDialog = new DialogAddUserBasedOnSession(View.getSingleton().getOptionsDialog(null), PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement(), session);
                addDialog.pack();
            }
            addDialog.setWorkingContext(uiSharedContext);
            addDialog.setVisible(true);
            User user = addDialog.getUser();
            addDialog.clear();
            addDialog.dispose();
            return user;
        }

        public void performAction() {
            SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
            sessionDialog.recreateUISharedContexts(Model.getSingleton().getSession());
            final Context uiSharedContext = sessionDialog.getUISharedContext(this.context.getId());
            HttpSessionsPanel panel = PopupMenuFactoryAddUserFromSession.this.extension.getHttpSessionsPanel();
            HttpSession session = panel.getSelectedSession();
            LOGGER.info("Creating user from HttpSession {} for Context {}", (Object)session.getName(), (Object)uiSharedContext.getName());
            this.pendingUsersClearing = false;
            if (!(uiSharedContext.getAuthenticationMethod() instanceof ManualAuthenticationMethodType.ManualAuthenticationMethod)) {
                LOGGER.info("Creating new Manual Authentication instance for Context {}", (Object)uiSharedContext.getName());
                ManualAuthenticationMethodType.ManualAuthenticationMethod method = new ManualAuthenticationMethodType().createAuthenticationMethod(this.context.getId());
                if (!this.confirmUsersDeletion(uiSharedContext)) {
                    LOGGER.debug("Cancelled change of authentication type.");
                    return;
                }
                uiSharedContext.setAuthenticationMethod(method);
                this.pendingUsersClearing = true;
            }
            this.newUser = this.showAddUserDialogue(uiSharedContext, session);
            if (this.newUser == null) {
                LOGGER.debug("Cancelled creation of user from HttpSession.");
                return;
            }
            LOGGER.info("Created user: {}", (Object)this.newUser);
            View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextUsersPanel.getPanelName(this.context.getId()), false, new Runnable(){

                @Override
                public void run() {
                    if (PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement() != null) {
                        if (PopupMenuAddUserFromSession.this.pendingUsersClearing) {
                            PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement().removeSharedContextUsers(uiSharedContext);
                        }
                        PopupMenuFactoryAddUserFromSession.this.getExtensionUserManagement().addSharedContextUser(uiSharedContext, PopupMenuAddUserFromSession.this.newUser);
                    }
                }
            });
        }

        private class DialogAddUserBasedOnSession
        extends DialogAddUser {
            private static final long serialVersionUID = 2269873123657767822L;
            private HttpSession session;

            public DialogAddUserBasedOnSession(Dialog owner, ExtensionUserManagement extension, HttpSession session) {
                super(owner, extension);
                this.session = session;
            }

            @Override
            protected void init() {
                if (this.workingContext == null) {
                    throw new IllegalStateException("A working Context should be set before setting the 'Add Dialog' visible.");
                }
                this.configuredCredentials = ManualAuthenticationMethodType.createAuthenticationCredentials(this.session);
                this.getNameTextField().setText(this.session.getName());
                this.getEnabledCheckBox().setSelected(true);
                this.initializeCredentialsConfigPanel();
            }
        }
    }
}

