/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URI;
import org.apache.commons.lang3.StringUtils;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.DefaultValueGenerator;
import org.zaproxy.zap.model.ValueGenerator;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.spider.parser.SpiderResourceFound;

@Deprecated
public class SpiderHtmlFormParser
extends SpiderParser {
    private static final String ENCODING_TYPE = "UTF-8";
    private static final String DEFAULT_EMPTY_VALUE = "";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private URI uri;
    private String url;
    private Map<String, String> envAttributes = new HashMap<String, String>();
    private final ValueGenerator valueGenerator;

    public SpiderHtmlFormParser(SpiderParam param) {
        this(param, new DefaultValueGenerator());
    }

    public SpiderHtmlFormParser(SpiderParam param, ValueGenerator valueGenerator) {
        super(param);
        if (valueGenerator == null) {
            throw new IllegalArgumentException("Parameter valueGenerator must not be null.");
        }
        this.valueGenerator = valueGenerator;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        this.getLogger().debug("Parsing an HTML message for forms...");
        if (!this.getSpiderParam().isProcessForm()) {
            return false;
        }
        if (source == null) {
            source = new Source((CharSequence)message.getResponseBody().toString());
        }
        String baseURL = message.getRequestHeader().getURI().toString();
        this.uri = message.getRequestHeader().getURI();
        Element base = source.getFirstElement("base");
        if (base != null) {
            this.getLogger().debug("Base tag was found in HTML: {}", (Object)base.getDebugInfo());
            String href = base.getAttributeValue("href");
            if (href != null && !href.isEmpty()) {
                baseURL = this.getCanonicalURL(href, baseURL);
            }
        }
        List forms = source.getAllElements("form");
        for (Element form : forms) {
            this.envAttributes.clear();
            for (Attribute att : form.getAttributes()) {
                this.envAttributes.put(att.getKey(), att.getValue());
            }
            String formMethod = form.getAttributeValue("method");
            List<FormAction> formActions = this.processFormActions(form, formMethod, baseURL, source);
            for (FormAction fAction : formActions) {
                String action = fAction.action;
                String method = fAction.method;
                this.getLogger().debug("Found new form with method: '{}' and action: {}", (Object)method, (Object)action);
                if (!this.getSpiderParam().isPostForm() && method != null && method.trim().equalsIgnoreCase(METHOD_POST)) {
                    this.getLogger().debug("Skipping form with POST method because of user settings.");
                    continue;
                }
                if (action.contains("#")) {
                    int fs = action.lastIndexOf("#");
                    action = action.substring(0, fs);
                }
                this.url = this.getCanonicalURL(action, baseURL);
                FormData formData = this.prepareFormDataSet(source, form);
                if (method != null && method.trim().equalsIgnoreCase(METHOD_POST)) {
                    String fullURL = this.getCanonicalURL(action, baseURL);
                    if (fullURL == null) {
                        return false;
                    }
                    this.getLogger().debug("Canonical URL constructed using '{}: {}", (Object)action, (Object)fullURL);
                    for (String submitData : formData) {
                        this.notifyPostResourceFound(message, depth, fullURL, submitData);
                    }
                    continue;
                }
                if (action.contains("?")) {
                    if (action.endsWith("?")) {
                        this.processGetForm(message, depth, action, baseURL, formData);
                        continue;
                    }
                    this.processGetForm(message, depth, action + "&", baseURL, formData);
                    continue;
                }
                this.processGetForm(message, depth, action + "?", baseURL, formData);
            }
        }
        return false;
    }

    private List<FormAction> processFormActions(Element form, String originalMethod, String baseURL, Source source) {
        ArrayList<FormAction> formActions = new ArrayList<FormAction>();
        String action = form.getAttributeValue("action");
        if (action == null) {
            this.getLogger().debug("No form 'action' defined. Using base URL: {}", (Object)baseURL);
            action = baseURL;
        }
        List<Element> formButtonElements = form.getChildElements().stream().filter(this::allowedButtonType).filter(element -> StringUtils.isEmpty((CharSequence)element.getAttributeValue("form"))).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((CharSequence)form.getAttributeValue("id"))) {
            String targetId = form.getAttributeValue("id");
            formButtonElements.addAll(source.getAllElements("button").stream().filter(this::allowedButtonType).filter(element -> StringUtils.equals((CharSequence)element.getAttributeValue("form"), (CharSequence)targetId)).collect(Collectors.toList()));
        }
        if (!formButtonElements.isEmpty()) {
            String defaultAction = action;
            formButtonElements.forEach(button -> {
                if (StringUtils.isEmpty((CharSequence)button.getAttributeValue("formaction"))) {
                    formActions.add(new FormAction(defaultAction, this.processFormMethodWithButton((Element)button, originalMethod)));
                } else {
                    formActions.add(new FormAction(button.getAttributeValue("formaction"), this.processFormMethodWithButton((Element)button, originalMethod)));
                }
            });
        } else {
            formActions.add(new FormAction(action, originalMethod));
        }
        return formActions;
    }

    private boolean allowedButtonType(Element element) {
        String type = element.getAttributeValue("type");
        return element.getStartTag().getName().equals("button") && !StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"button") && !StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"reset");
    }

    private String processFormMethodWithButton(Element button, String defaultMethod) {
        String buttonMethod = button.getAttributeValue("formmethod");
        return StringUtils.isEmpty((CharSequence)buttonMethod) || !buttonMethod.equalsIgnoreCase(METHOD_GET) && !buttonMethod.equalsIgnoreCase(METHOD_POST) ? defaultMethod : buttonMethod;
    }

    private void processGetForm(HttpMessage message, int depth, String action, String baseURL, FormData formData) {
        for (String submitData : formData) {
            this.getLogger().debug("Submitting form with GET method and query with form parameters: {}", (Object)submitData);
            this.processURL(message, depth, action + submitData, baseURL);
        }
    }

    private FormData prepareFormDataSet(Source source, Element form) {
        LinkedList<FormDataField> formDataFields = new LinkedList<FormDataField>();
        for (FormField field : SpiderHtmlFormParser.getFormFields(source, form)) {
            this.getLogger().debug("New form field: {}", (Object)field.getDebugInfo());
            for (String value : this.getDefaultTextValue(field)) {
                formDataFields.add(new FormDataField(field.getName(), value, field.getFormControl().getFormControlType().isSubmit()));
            }
        }
        return new FormData(formDataFields);
    }

    private static FormFields getFormFields(Source source, Element form) {
        TreeSet<FormControl> formControls = new TreeSet<FormControl>();
        SpiderHtmlFormParser.addAll(formControls, (Segment)form, "input");
        SpiderHtmlFormParser.addAll(formControls, (Segment)form, "textarea");
        SpiderHtmlFormParser.addAll(formControls, (Segment)form, "select");
        SpiderHtmlFormParser.addAll(formControls, (Segment)form, "button");
        String formId = form.getAttributeValue("id");
        if (formId != null && !formId.isEmpty()) {
            SpiderHtmlFormParser.addAll(formControls, source.getAllElements("form", formId, true));
        }
        Iterator it = formControls.iterator();
        while (it.hasNext()) {
            FormControl formControl = (FormControl)it.next();
            String targetForm = (String)formControl.getAttributesMap().get("form");
            if (targetForm == null || targetForm.equals(formId)) continue;
            it.remove();
        }
        return new FormFields(formControls);
    }

    private static void addAll(SortedSet<FormControl> formControls, Segment segment, String tagName) {
        SpiderHtmlFormParser.addAll(formControls, segment.getAllElements(tagName));
    }

    private static void addAll(SortedSet<FormControl> formControls, List<Element> elements) {
        for (Element element : elements) {
            FormControl formControl = element.getFormControl();
            if (formControl == null) continue;
            formControls.add(formControl);
        }
    }

    private List<String> getDefaultTextValue(FormField field) {
        String fieldId = field.getName();
        HashMap<String, String> fieldAttributes = new HashMap<String, String>();
        ArrayList<String> definedValues = new ArrayList<String>();
        fieldAttributes.putAll(field.getFormControl().getAttributesMap());
        fieldAttributes.put("Control Type", field.getFormControl().getFormControlType().name());
        if (field.getFormControl().getFormControlType().isSubmit()) {
            ArrayList<String> submitFields = new ArrayList<String>();
            for (String value : field.getPredefinedValues()) {
                String finalValue = this.valueGenerator.getValue(this.uri, this.url, fieldId, value, definedValues, this.envAttributes, fieldAttributes);
                submitFields.add(finalValue);
            }
            return submitFields;
        }
        ArrayList<String> values = field.getValues();
        String defaultValue = null;
        if (field.getFormControl().getAttributesMap().containsKey("value")) {
            defaultValue = (String)field.getFormControl().getAttributesMap().get("value");
        }
        this.getLogger().debug("Existing values: {}", (Object)values);
        if (values.isEmpty() || values.size() == 1 && ((String)values.get(0)).isEmpty()) {
            Collection predefValues = field.getPredefinedValues();
            if (!predefValues.isEmpty()) {
                definedValues.addAll(predefValues);
                if (defaultValue == null) {
                    Iterator iterator = predefValues.iterator();
                    defaultValue = (String)iterator.next();
                    if (iterator.hasNext()) {
                        defaultValue = (String)iterator.next();
                    }
                }
            }
            defaultValue = defaultValue == null ? DEFAULT_EMPTY_VALUE : defaultValue;
        } else if (defaultValue == null) {
            defaultValue = (String)values.get(0);
        }
        String finalValue = this.valueGenerator.getValue(this.uri, this.url, fieldId, defaultValue, definedValues, this.envAttributes, fieldAttributes);
        this.getLogger().debug("Generated: {}For field {}", (Object)finalValue, (Object)field.getName());
        values = new ArrayList<String>(1);
        values.add(finalValue);
        return values;
    }

    private void notifyPostResourceFound(HttpMessage message, int depth, String url, String requestBody) {
        this.getLogger().debug("Submitting form with POST method and message body with form parameters (normal encoding): {}", (Object)requestBody);
        this.notifyListenersResourceFound(SpiderResourceFound.builder().setMessage(message).setDepth(depth + 1).setUri(url).setMethod(METHOD_POST).setBody(requestBody).build());
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyConsumed) {
        return !wasAlreadyConsumed && message.getResponseHeader().isHtml();
    }

    private static class FormAction {
        final String action;
        final String method;

        FormAction(String action, String method) {
            this.action = action;
            this.method = method;
        }
    }

    private static class FormData
    implements Iterable<String> {
        private final List<FormDataField> fields;
        private final List<FormDataField> submitFields;

        private FormData(List<FormDataField> fields) {
            this.fields = fields;
            this.submitFields = new ArrayList<FormDataField>();
            this.fields.forEach(f -> {
                if (f.isSubmit()) {
                    this.submitFields.add((FormDataField)f);
                }
            });
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorImpl();
        }

        private class IteratorImpl
        implements Iterator<String> {
            private boolean started;
            private List<FormDataField> consumedSubmitFields = new ArrayList<FormDataField>();

            private IteratorImpl() {
            }

            @Override
            public boolean hasNext() {
                return !this.started || this.consumedSubmitFields.size() < FormData.this.submitFields.size();
            }

            @Override
            public String next() {
                if (!this.started) {
                    this.started = true;
                } else if (this.consumedSubmitFields.size() >= FormData.this.submitFields.size()) {
                    throw new NoSuchElementException("No more form data to generate.");
                }
                boolean submitted = false;
                StringBuilder formData = new StringBuilder(100);
                for (FormDataField field : FormData.this.fields) {
                    if (field.isSubmit()) {
                        if (submitted || this.consumedSubmitFields.contains(field)) continue;
                        submitted = true;
                        this.consumedSubmitFields.add(field);
                    }
                    if (formData.length() > 0) {
                        formData.append('&');
                    }
                    formData.append(field.getName());
                    formData.append('=');
                    formData.append(field.getValue());
                }
                return formData.toString();
            }
        }
    }

    private static class FormDataField {
        private String name;
        private String value;
        private boolean submit;

        public FormDataField(String name, String value, boolean submit) {
            try {
                this.name = URLEncoder.encode(name, SpiderHtmlFormParser.ENCODING_TYPE);
                this.value = URLEncoder.encode(value, SpiderHtmlFormParser.ENCODING_TYPE);
                this.submit = submit;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isSubmit() {
            return this.submit;
        }
    }
}

