/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTableModel;
import org.zaproxy.zap.view.MultipleOptionsTablePanel;

public abstract class AbstractMultipleOptionsBaseTablePanel<E>
extends MultipleOptionsTablePanel {
    protected static final long serialVersionUID = -7609757285865562636L;
    protected static final String ADD_BUTTON_LABEL = Constant.messages.getString("multiple.options.panel.add.button.label");
    protected static final String MODIFY_BUTTON_LABEL = Constant.messages.getString("multiple.options.panel.modify.button.label");
    protected static final String REMOVE_BUTTON_LABEL = Constant.messages.getString("multiple.options.panel.remove.button.label");
    protected static final String REMOVE_WO_CONFIRMATION_CHECKBOX_LABEL = Constant.messages.getString("multiple.options.panel.removeWithoutConfirmation.checkbox.label");
    protected JButton addButton;
    protected JButton modifyButton;
    protected JButton removeButton;
    protected AbstractMultipleOptionsBaseTableModel<E> model;
    protected GridBagConstraints gbcFooterPanel;
    protected JCheckBox removeWithoutConfirmationCheckBox;

    public AbstractMultipleOptionsBaseTablePanel(AbstractMultipleOptionsBaseTableModel<E> model) {
        this(model, true);
    }

    protected AbstractMultipleOptionsBaseTablePanel(AbstractMultipleOptionsBaseTableModel<E> model, boolean allowModification) {
        super(model);
        this.getFooterPanel().setLayout(new GridBagLayout());
        this.gbcFooterPanel = new GridBagConstraints();
        this.gbcFooterPanel.gridx = 0;
        this.gbcFooterPanel.weightx = 1.0;
        this.gbcFooterPanel.weighty = 1.0;
        this.gbcFooterPanel.anchor = 21;
        this.addFooterPanelComponent(this.getRemoveWithoutConfirmationCheckBox());
        this.model = model;
        this.addButton = new JButton(ADD_BUTTON_LABEL);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object e = AbstractMultipleOptionsBaseTablePanel.this.showAddDialogue();
                if (e != null) {
                    AbstractMultipleOptionsBaseTablePanel.this.getMultipleOptionsModel().addElement(e);
                }
            }
        });
        if (allowModification) {
            this.modifyButton = new JButton(MODIFY_BUTTON_LABEL);
            this.modifyButton.setEnabled(false);
            this.modifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AbstractMultipleOptionsBaseTablePanel.this.modifyElement(AbstractMultipleOptionsBaseTablePanel.this.getSelectedRow());
                }
            });
        }
        this.removeButton = new JButton(REMOVE_BUTTON_LABEL);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = AbstractMultipleOptionsBaseTablePanel.this.getSelectedRow();
                if (!AbstractMultipleOptionsBaseTablePanel.this.isRemoveWithoutConfirmation() && !AbstractMultipleOptionsBaseTablePanel.this.showRemoveDialogue(AbstractMultipleOptionsBaseTablePanel.this.getMultipleOptionsModel().getElement(row))) {
                    return;
                }
                AbstractMultipleOptionsBaseTablePanel.this.getMultipleOptionsModel().removeElement(row);
            }
        });
        this.addButton(this.addButton);
        if (allowModification) {
            this.addButton(this.modifyButton);
        }
        this.addButton(this.removeButton);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AbstractMultipleOptionsBaseTablePanel.this.selectionChanged(AbstractMultipleOptionsBaseTablePanel.this.getTable().getSelectionModel().getMinSelectionIndex() >= 0);
                }
            }
        });
        if (allowModification) {
            this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    Point p;
                    JXTable table;
                    int row;
                    if (me.getClickCount() == 2 && AbstractMultipleOptionsBaseTablePanel.this.modifyButton != null && AbstractMultipleOptionsBaseTablePanel.this.modifyButton.isEnabled() && (row = (table = (JXTable)me.getSource()).rowAtPoint(p = me.getPoint())) >= 0) {
                        AbstractMultipleOptionsBaseTablePanel.this.modifyElement(AbstractMultipleOptionsBaseTablePanel.this.getTable().convertRowIndexToModel(row));
                    }
                }
            });
        }
    }

    private void modifyElement(int row) {
        E e = this.showModifyDialogue(this.getMultipleOptionsModel().getElement(row));
        if (e != null) {
            this.getMultipleOptionsModel().modifyElement(row, e);
        }
    }

    protected void selectionChanged(boolean entrySelected) {
        if (this.modifyButton != null) {
            this.modifyButton.setEnabled(entrySelected);
        }
        this.removeButton.setEnabled(entrySelected);
    }

    public AbstractMultipleOptionsBaseTablePanel(TableModel model) {
        super(model);
    }

    @Override
    public void setComponentEnabled(boolean enabled) {
        boolean enable;
        super.setComponentEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeWithoutConfirmationCheckBox.setEnabled(enabled);
        boolean bl = enable = enabled && this.getTable().getSelectionModel().getMinSelectionIndex() >= 0;
        if (this.modifyButton != null) {
            this.modifyButton.setEnabled(enable);
        }
        this.removeButton.setEnabled(enable);
    }

    public final void addFooterPanelComponent(JComponent component) {
        this.getFooterPanel().add((Component)component, this.gbcFooterPanel);
    }

    public boolean isRemoveWithoutConfirmation() {
        return this.getRemoveWithoutConfirmationCheckBox().isSelected();
    }

    public void setRemoveWithoutConfirmation(boolean enabled) {
        this.getRemoveWithoutConfirmationCheckBox().setSelected(enabled);
    }

    protected String getRemoveWithoutConfirmationLabel() {
        return REMOVE_WO_CONFIRMATION_CHECKBOX_LABEL;
    }

    protected final JCheckBox getRemoveWithoutConfirmationCheckBox() {
        if (this.removeWithoutConfirmationCheckBox == null) {
            this.removeWithoutConfirmationCheckBox = new JCheckBox(this.getRemoveWithoutConfirmationLabel());
            this.removeWithoutConfirmationCheckBox.setHorizontalTextPosition(2);
        }
        return this.removeWithoutConfirmationCheckBox;
    }

    protected int getSelectedRow() {
        int selectedRow = this.getTable().getSelectionModel().getMinSelectionIndex();
        if (selectedRow == -1) {
            return -1;
        }
        return this.getTable().convertRowIndexToModel(selectedRow);
    }

    protected AbstractMultipleOptionsBaseTableModel<E> getMultipleOptionsModel() {
        return this.model;
    }

    public abstract E showAddDialogue();

    public abstract E showModifyDialogue(E var1);

    public abstract boolean showRemoveDialogue(E var1);
}

