/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagecontainer.http;

import java.awt.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSingleHttpMessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.SingleHistoryReferenceContainer;

public class DefaultSingleHistoryReferenceContainer
extends DefaultSingleHttpMessageContainer
implements SingleHistoryReferenceContainer {
    private static final Logger LOGGER = LogManager.getLogger(DefaultSingleHistoryReferenceContainer.class);
    private final HistoryReference historyReference;

    public DefaultSingleHistoryReferenceContainer(String name, Component component) {
        this(name, component, (HistoryReference)null);
    }

    public DefaultSingleHistoryReferenceContainer(String name, Component component, HistoryReference historyReference) {
        super(name, component);
        this.historyReference = historyReference;
    }

    @Override
    public boolean isEmpty() {
        return this.historyReference == null;
    }

    @Override
    public HttpMessage getMessage() {
        if (this.historyReference != null) {
            try {
                return this.historyReference.getHttpMessage();
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public HistoryReference getHistoryReference() {
        return this.historyReference;
    }
}

