/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagecontainer.http;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class PersistedHttpMessagesList
extends AbstractList<HttpMessage> {
    private static final Logger LOGGER = LogManager.getLogger(PersistedHttpMessagesList.class);
    private final List<HistoryReference> historyReferences;

    public PersistedHttpMessagesList(List<HistoryReference> historyReferences) {
        this.historyReferences = historyReferences == null || historyReferences.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<HistoryReference>(historyReferences));
    }

    @Override
    public HttpMessage get(int index) {
        try {
            return this.historyReferences.get(index).getHttpMessage();
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.debug("Failed to get the message from DB: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public int size() {
        return this.historyReferences.size();
    }
}

