/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.popup.PopupMenuItemExcludeFromContext;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuItemContextExclude
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 2282358266003940700L;
    private List<ExtensionPopupMenuItem> subMenus = new ArrayList<ExtensionPopupMenuItem>();

    public PopupMenuItemContextExclude() {
        super("excludeFromContextX", true);
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.exclude.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public boolean isDummyItem() {
        return true;
    }

    @Override
    public void performAction(SiteNode sn) {
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode sn) {
        this.reCreateSubMenu();
        return false;
    }

    protected void reCreateSubMenu() {
        Vector<JMenuItem> mainPopupMenuItems = View.getSingleton().getPopupList();
        for (ExtensionPopupMenuItem menu : this.subMenus) {
            mainPopupMenuItems.remove(menu);
        }
        this.subMenus.clear();
        Session session = Model.getSingleton().getSession();
        List<Context> contexts = session.getContexts();
        for (Context context : contexts) {
            ExtensionPopupMenuItem piicm = this.createPopupExcludeFromContextMenu(context);
            mainPopupMenuItems.add(piicm);
            this.subMenus.add(piicm);
        }
    }

    protected ExtensionPopupMenuItem createPopupExcludeFromContextMenu(Context context) {
        return new PopupMenuItemExcludeFromContext(context);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

