/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerRefresh;

public class NavigatorHandlerFilterClear
extends AbstractHandler {
    private static final Log log = Log.getLog(NavigatorHandlerFilterClear.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode node = NavigatorUtils.getSelectedNode(selection);
        DBNDatabaseNode parentNode = (DBNDatabaseNode)(node instanceof DBNDatabaseItem ? node.getParentNode() : node);
        if (parentNode == null) {
            return null;
        }
        try {
            DBXTreeItem itemsMeta = (DBXTreeItem)UIUtils.runWithMonitor(monitor -> DBNUtils.getValidItemsMeta((DBRProgressMonitor)monitor, (DBNDatabaseNode)parentNode));
            if (itemsMeta != null) {
                parentNode.setNodeFilter(itemsMeta, new DBSObjectFilter(), true);
                NavigatorHandlerRefresh.refreshNavigator(Collections.singleton(parentNode));
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return null;
    }
}

