/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders;

import java.util.Arrays;
import java.util.LinkedList;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.UserRoleConstraint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MenuStructureXmlHandler
extends DefaultHandler {
    private static final String USED_BY = "usedBy";
    private static final String NAME = "name";
    private static final String BUILDER = "builder";
    private final LinkedList<Entry> childStack = new LinkedList();

    public MenuStructureXmlHandler(Entry root) {
        this.childStack.add(root);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("Entry")) {
            Entry child = new Entry();
            for (int attributeIndex = 0; attributeIndex < attributes.getLength(); ++attributeIndex) {
                String attributeName = attributes.getQName(attributeIndex).intern();
                String attributeValue = attributes.getValue(attributeName).intern();
                if (attributeName == BUILDER) {
                    child.setBuilders(Arrays.asList(attributeValue.split("\\s*,\\s*")));
                    continue;
                }
                if (attributeName == NAME) {
                    child.setName(attributeValue);
                    continue;
                }
                if (attributeName == USED_BY) {
                    child.addConstraint(UserRoleConstraint.valueOf(attributeValue));
                    continue;
                }
                child.setAttribute(attributeName, this.toValueObject(attributeValue));
            }
            Entry parent = this.childStack.getLast();
            child.addConstraint(parent);
            parent.addChild(child);
            this.childStack.add(child);
        }
    }

    private Object toValueObject(String attributeValue) {
        if ("true".equalsIgnoreCase(attributeValue)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(attributeValue)) {
            return Boolean.FALSE;
        }
        return attributeValue;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        this.childStack.removeLast();
    }
}

