/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.core.importer.ImportedClasses;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DependencyResolutionProcess {
    private static final Logger log = LoggerFactory.getLogger(DependencyResolutionProcess.class);
    static final String DEPENDENCY_RESOLUTION_PROCESS_PROPERTY_PREFIX = "import.dependencyResolutionProcess";
    private final Properties resolutionProcessProperties = ArchConfiguration.get().getSubProperties("import.dependencyResolutionProcess");
    static final String MAX_ITERATIONS_FOR_MEMBER_TYPES_PROPERTY_NAME = "maxIterationsForMemberTypes";
    static final int MAX_ITERATIONS_FOR_MEMBER_TYPES_DEFAULT_VALUE = 1;
    private final int maxRunsForMemberTypes = this.getConfiguredIterations("maxIterationsForMemberTypes", 1);
    static final String MAX_ITERATIONS_FOR_ACCESSES_TO_TYPES_PROPERTY_NAME = "maxIterationsForAccessesToTypes";
    static final int MAX_ITERATIONS_FOR_ACCESSES_TO_TYPES_DEFAULT_VALUE = 1;
    private final int maxRunsForAccessesToTypes = this.getConfiguredIterations("maxIterationsForAccessesToTypes", 1);
    static final String MAX_ITERATIONS_FOR_SUPERTYPES_PROPERTY_NAME = "maxIterationsForSupertypes";
    static final int MAX_ITERATIONS_FOR_SUPERTYPES_DEFAULT_VALUE = -1;
    private final int maxRunsForSupertypes = this.getConfiguredIterations("maxIterationsForSupertypes", -1);
    static final String MAX_ITERATIONS_FOR_ENCLOSING_TYPES_PROPERTY_NAME = "maxIterationsForEnclosingTypes";
    static final int MAX_ITERATIONS_FOR_ENCLOSING_TYPES_DEFAULT_VALUE = -1;
    private final int maxRunsForEnclosingTypes = this.getConfiguredIterations("maxIterationsForEnclosingTypes", -1);
    static final String MAX_ITERATIONS_FOR_ANNOTATION_TYPES_PROPERTY_NAME = "maxIterationsForAnnotationTypes";
    static final int MAX_ITERATIONS_FOR_ANNOTATION_TYPES_DEFAULT_VALUE = -1;
    private final int maxRunsForAnnotationTypes = this.getConfiguredIterations("maxIterationsForAnnotationTypes", -1);
    static final String MAX_ITERATIONS_FOR_GENERIC_SIGNATURE_TYPES_PROPERTY_NAME = "maxIterationsForGenericSignatureTypes";
    static final int MAX_ITERATIONS_FOR_GENERIC_SIGNATURE_TYPES_DEFAULT_VALUE = -1;
    private final int maxRunsForGenericSignatureTypes = this.getConfiguredIterations("maxIterationsForGenericSignatureTypes", -1);
    private Set<String> currentTypeNames = new HashSet<String>();
    private int runNumber = 1;
    private boolean shouldContinue;

    DependencyResolutionProcess() {
    }

    void registerMemberType(String typeName) {
        if (this.runNumberHasNotExceeded(this.maxRunsForMemberTypes)) {
            this.currentTypeNames.add(typeName);
        }
    }

    void registerMemberTypes(Collection<String> typeNames) {
        for (String typeName : typeNames) {
            this.registerMemberType(typeName);
        }
    }

    void registerAccessToType(String typeName) {
        if (this.runNumberHasNotExceeded(this.maxRunsForAccessesToTypes)) {
            this.currentTypeNames.add(typeName);
        }
    }

    void registerSupertype(String typeName) {
        if (this.runNumberHasNotExceeded(this.maxRunsForSupertypes)) {
            this.currentTypeNames.add(typeName);
        }
    }

    void registerSupertypes(Collection<String> typeNames) {
        for (String typeName : typeNames) {
            this.registerSupertype(typeName);
        }
    }

    void registerEnclosingType(String typeName) {
        if (this.runNumberHasNotExceeded(this.maxRunsForEnclosingTypes)) {
            this.currentTypeNames.add(typeName);
        }
    }

    void registerAnnotationType(String typeName) {
        if (this.runNumberHasNotExceeded(this.maxRunsForAnnotationTypes)) {
            this.currentTypeNames.add(typeName);
        }
    }

    void registerGenericSignatureType(String typeName) {
        if (this.runNumberHasNotExceeded(this.maxRunsForGenericSignatureTypes)) {
            this.currentTypeNames.add(typeName);
        }
    }

    void resolve(ImportedClasses classes) {
        this.logConfiguration();
        do {
            this.executeRun(classes);
        } while (this.shouldContinue);
    }

    private void logConfiguration() {
        log.trace("Automatically resolving transitive class dependencies with the following configuration:{}{}{}{}{}{}", new Object[]{this.formatConfigProperty(MAX_ITERATIONS_FOR_MEMBER_TYPES_PROPERTY_NAME, this.maxRunsForMemberTypes), this.formatConfigProperty(MAX_ITERATIONS_FOR_ACCESSES_TO_TYPES_PROPERTY_NAME, this.maxRunsForAccessesToTypes), this.formatConfigProperty(MAX_ITERATIONS_FOR_SUPERTYPES_PROPERTY_NAME, this.maxRunsForSupertypes), this.formatConfigProperty(MAX_ITERATIONS_FOR_ENCLOSING_TYPES_PROPERTY_NAME, this.maxRunsForEnclosingTypes), this.formatConfigProperty(MAX_ITERATIONS_FOR_ANNOTATION_TYPES_PROPERTY_NAME, this.maxRunsForAnnotationTypes), this.formatConfigProperty(MAX_ITERATIONS_FOR_GENERIC_SIGNATURE_TYPES_PROPERTY_NAME, this.maxRunsForGenericSignatureTypes)});
    }

    private String formatConfigProperty(String propertyName, int number) {
        return System.lineSeparator() + DEPENDENCY_RESOLUTION_PROCESS_PROPERTY_PREFIX + "." + propertyName + " = " + number;
    }

    private void executeRun(ImportedClasses classes) {
        ++this.runNumber;
        Set<String> typeNamesToResolve = this.currentTypeNames;
        this.currentTypeNames = new HashSet<String>();
        this.shouldContinue = false;
        for (String typeName : typeNamesToResolve) {
            ImportedClasses.ImportedClassState classState = classes.ensurePresent(typeName);
            this.shouldContinue = this.shouldContinue || classState == ImportedClasses.ImportedClassState.HAD_TO_BE_IMPORTED;
        }
    }

    private boolean runNumberHasNotExceeded(int maxRuns) {
        return maxRuns < 0 || this.runNumber <= maxRuns;
    }

    private int getConfiguredIterations(String propertyName, int defaultValue) {
        return Integer.parseInt(this.resolutionProcessProperties.getProperty(propertyName, String.valueOf(defaultValue)));
    }
}

