/*
 * Copyright (c) 2020-2021, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

/* The macros that are fiddled with here are defined in <bits/floatn.h> or
   <bits/floatn-common.h>.  <bits/floatn-common.h> is only included by
   <bits/floatn.h>, so it is easier to deal with all the macros together in a
   single wrapper header. */

#pragma once

#if defined(__NVCC_HOST__)

/* NVCC's configuration for NV HPC does not include support for __float128.
   Some versions of glibc will not define __HAVE_FLOAT128 if __CUDACC__ is
   defined.  But other versions of glibc do not have that check.  In those
   versions, there is no way to prevent <bits/floatn.h> from using __float128
   in a typedef for _Float128, which NVCC will complain about.  Until NVCC's
   configuration for NV HPC is updated, the real <bits/floatn.h> cannot be
   included.  It is not worth the effort to recreate all the _FloatN types, so
   those are left undefined. */

#include <features.h>

#else

#include_next <bits/floatn.h>

/* No support for IEEE 16-bit or IEEE 128-bit extended types. */
#define __HAVE_FLOAT16 0
#define __HAVE_FLOAT128X 0

#endif /* __NVCC_HOST__ */
