/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedExample;
import org.openapitools.openapidiff.core.model.ChangedExamples;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedParameter
implements ComposedChanged {
    private final DiffContext context;
    private Parameter oldParameter;
    private Parameter newParameter;
    private String name;
    private String in;
    private boolean changeRequired;
    private boolean deprecated;
    private boolean changeStyle;
    private boolean changeExplode;
    private boolean changeAllowEmptyValue;
    private ChangedMetadata description;
    private ChangedExamples examples;
    private ChangedExample example;
    private ChangedSchema schema;
    private ChangedContent content;
    private ChangedExtensions extensions;

    public ChangedParameter(String name, String in, DiffContext context) {
        this.name = name;
        this.in = in;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Arrays.asList(this.description, this.examples, this.example, this.schema, this.content, this.extensions);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (!(this.changeRequired || this.deprecated || this.changeAllowEmptyValue || this.changeStyle || this.changeExplode)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.changeAllowEmptyValue && !Boolean.TRUE.equals(this.newParameter.getAllowEmptyValue()) && BackwardIncompatibleProp.REQUEST_PARAM_ALLOWEMPTY_DECREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.changeExplode && BackwardIncompatibleProp.REQUEST_PARAM_EXPLODE_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.changeRequired && !Boolean.TRUE.equals(this.oldParameter.getRequired()) && BackwardIncompatibleProp.REQUEST_PARAMS_REQUIRED_INCREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.changeStyle && BackwardIncompatibleProp.REQUEST_PARAM_STYLE_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Parameter getOldParameter() {
        return this.oldParameter;
    }

    public Parameter getNewParameter() {
        return this.newParameter;
    }

    public String getName() {
        return this.name;
    }

    public String getIn() {
        return this.in;
    }

    public boolean isChangeRequired() {
        return this.changeRequired;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isChangeStyle() {
        return this.changeStyle;
    }

    public boolean isChangeExplode() {
        return this.changeExplode;
    }

    public boolean isChangeAllowEmptyValue() {
        return this.changeAllowEmptyValue;
    }

    public ChangedMetadata getDescription() {
        return this.description;
    }

    public ChangedExamples getExamples() {
        return this.examples;
    }

    public ChangedExample getExample() {
        return this.example;
    }

    public ChangedSchema getSchema() {
        return this.schema;
    }

    public ChangedContent getContent() {
        return this.content;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedParameter setOldParameter(Parameter oldParameter) {
        this.oldParameter = oldParameter;
        return this;
    }

    public ChangedParameter setNewParameter(Parameter newParameter) {
        this.newParameter = newParameter;
        return this;
    }

    public ChangedParameter setName(String name) {
        this.name = name;
        return this;
    }

    public ChangedParameter setIn(String in) {
        this.in = in;
        return this;
    }

    public ChangedParameter setChangeRequired(boolean changeRequired) {
        this.changeRequired = changeRequired;
        return this;
    }

    public ChangedParameter setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public ChangedParameter setChangeStyle(boolean changeStyle) {
        this.changeStyle = changeStyle;
        return this;
    }

    public ChangedParameter setChangeExplode(boolean changeExplode) {
        this.changeExplode = changeExplode;
        return this;
    }

    public ChangedParameter setChangeAllowEmptyValue(boolean changeAllowEmptyValue) {
        this.changeAllowEmptyValue = changeAllowEmptyValue;
        return this;
    }

    public ChangedParameter setDescription(ChangedMetadata description) {
        this.description = description;
        return this;
    }

    public ChangedParameter setExamples(ChangedExamples examples) {
        this.examples = examples;
        return this;
    }

    public ChangedParameter setExample(ChangedExample example) {
        this.example = example;
        return this;
    }

    public ChangedParameter setSchema(ChangedSchema schema) {
        this.schema = schema;
        return this;
    }

    public ChangedParameter setContent(ChangedContent content) {
        this.content = content;
        return this;
    }

    public ChangedParameter setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedParameter that = (ChangedParameter)o;
        return this.changeRequired == that.changeRequired && this.deprecated == that.deprecated && this.changeStyle == that.changeStyle && this.changeExplode == that.changeExplode && this.changeAllowEmptyValue == that.changeAllowEmptyValue && Objects.equals(this.context, that.context) && Objects.equals(this.oldParameter, that.oldParameter) && Objects.equals(this.newParameter, that.newParameter) && Objects.equals(this.name, that.name) && Objects.equals(this.in, that.in) && Objects.equals(this.description, that.description) && Objects.equals(this.examples, that.examples) && Objects.equals(this.example, that.example) && Objects.equals(this.schema, that.schema) && Objects.equals(this.content, that.content) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.oldParameter, this.newParameter, this.name, this.in, this.changeRequired, this.deprecated, this.changeStyle, this.changeExplode, this.changeAllowEmptyValue, this.description, this.examples, this.example, this.schema, this.content, this.extensions);
    }

    public String toString() {
        return "ChangedParameter(context=" + this.getContext() + ", oldParameter=" + this.getOldParameter() + ", newParameter=" + this.getNewParameter() + ", name=" + this.getName() + ", in=" + this.getIn() + ", changeRequired=" + this.isChangeRequired() + ", deprecated=" + this.isDeprecated() + ", changeStyle=" + this.isChangeStyle() + ", changeExplode=" + this.isChangeExplode() + ", changeAllowEmptyValue=" + this.isChangeAllowEmptyValue() + ", description=" + this.getDescription() + ", examples=" + this.getExamples() + ", example=" + this.getExample() + ", schema=" + this.getSchema() + ", content=" + this.getContent() + ", extensions=" + this.getExtensions() + ")";
    }
}

