# This file has been autogenerated by the pywayland scanner

# Copyright © 2023-2024 Matthias Klumpp
# Copyright ©      2024 David Edmundson
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlBuffer


class XdgToplevelIconV1(Interface):
    """A toplevel window icon

    This interface defines a toplevel icon. An icon can have a name, and
    multiple buffers. In order to be applied, the icon must have either a name,
    or at least one buffer assigned. Applying an empty icon (with no buffer or
    name) to a toplevel should reset its icon to the default icon.

    It is up to compositor policy whether to prefer using a buffer or loading
    an icon via its name. See 'set_name' and 'add_buffer' for details.
    """

    name = "xdg_toplevel_icon_v1"
    version = 1

    class error(enum.IntEnum):
        invalid_buffer = 1
        immutable = 2
        no_buffer = 3


class XdgToplevelIconV1Proxy(Proxy[XdgToplevelIconV1]):
    interface = XdgToplevelIconV1

    @XdgToplevelIconV1.request()
    def destroy(self) -> None:
        """Destroy the icon object

        Destroys the 'xdg_toplevel_icon_v1' object. The icon must still remain
        set on every toplevel it was assigned to, until the toplevel icon is
        reset explicitly.
        """
        self._marshal(0)
        self._destroy()

    @XdgToplevelIconV1.request(
        Argument(ArgumentType.String),
    )
    def set_name(self, icon_name: str) -> None:
        """Set an icon name

        This request assigns an icon name to this icon. Any previously set name
        is overridden.

        The compositor must resolve 'icon_name' according to the lookup rules
        described in the XDG icon theme specification[1] using the
        environment's current icon theme.

        If the compositor does not support icon names or cannot resolve
        'icon_name' according to the XDG icon theme specification it must fall
        back to using pixel buffer data instead.

        If this request is made after the icon has been assigned to a toplevel
        via 'set_icon', a 'immutable' error must be raised.

        [1]: https://specifications.freedesktop.org/icon-theme-spec/icon-theme-
        spec-latest.html

        :param icon_name:
        :type icon_name:
            `ArgumentType.String`
        """
        self._marshal(1, icon_name)

    @XdgToplevelIconV1.request(
        Argument(ArgumentType.Object, interface=WlBuffer),
        Argument(ArgumentType.Int),
    )
    def add_buffer(self, buffer: WlBuffer, scale: int) -> None:
        """Add icon data from a pixel buffer

        This request adds pixel data supplied as
        :class:`~pywayland.protocol.wayland.WlBuffer` to the icon.

        The client should add pixel data for all icon sizes and scales that it
        can provide, or which are explicitly requested by the compositor via
        'icon_size' events on
        :class:`~pywayland.protocol.xdg_toplevel_icon_v1.XdgToplevelIconManagerV1`.

        The :class:`~pywayland.protocol.wayland.WlBuffer` supplying pixel data
        as 'buffer' must be backed by
        :class:`~pywayland.protocol.wayland.WlShm` and must be a square (width
        and height being equal). If any of these buffer requirements are not
        fulfilled, a 'invalid_buffer' error must be raised.

        If this icon instance already has a buffer of the same size and scale
        from a previous 'add_buffer' request, data from the last request
        overrides the preexisting pixel data.

        The :class:`~pywayland.protocol.wayland.WlBuffer` must be kept alive
        for as long as the xdg_toplevel_icon it is associated with is not
        destroyed, otherwise a 'no_buffer' error is raised. The buffer contents
        must not be modified after it was assigned to the icon. As a result,
        the region of the wl_shm_pool's backing storage used for the
        :class:`~pywayland.protocol.wayland.WlBuffer` must not be modified
        after this request is sent. The :func:`WlBuffer.release()
        <pywayland.protocol.wayland.WlBuffer.release>` event is unused.

        If this request is made after the icon has been assigned to a toplevel
        via 'set_icon', a 'immutable' error must be raised.

        :param buffer:
        :type buffer:
            :class:`~pywayland.protocol.wayland.WlBuffer`
        :param scale:
            the scaling factor of the icon, e.g. 1
        :type scale:
            `ArgumentType.Int`
        """
        self._marshal(2, buffer, scale)


class XdgToplevelIconV1Resource(Resource):
    interface = XdgToplevelIconV1


class XdgToplevelIconV1Global(Global):
    interface = XdgToplevelIconV1


XdgToplevelIconV1._gen_c()
XdgToplevelIconV1.proxy_class = XdgToplevelIconV1Proxy
XdgToplevelIconV1.resource_class = XdgToplevelIconV1Resource
XdgToplevelIconV1.global_class = XdgToplevelIconV1Global
